/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.qing.modeler;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.QingModelerNoPermissionException;
import com.kingdee.bos.qing.common.framework.web.AbstractQingAction;
import com.kingdee.bos.qing.response.ResponseErrorWrap;
import com.kingdee.bos.qing.util.JsonUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.mservice.qingshared.common.context.QingIntegratedContext;
import kd.bos.web.qing.QingSharedAction;
import kd.bos.web.qing.exception.FileUploadFailException;
import kd.bos.web.qing.i18n.Messages;
import kd.bos.web.qing.impl.QingMServiceDispatcher;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class QingModelerAction
extends QingSharedAction {
    private static final String APP_ID = "qing_modeler";
    private static final String FROM_PAGE_CLIENT_ID = "fromPageClientId";
    private static final String CURRENT_PAGE_CLIENT_ID = "currentPageClientId";
    private static final String HOMEPAGE_ID = "homePage";
    private static final String QING_MODELSET_MAIN_PAGE_ID = "modelSetMainPage";
    private static final String DESIGNER_ID = "designer";
    private static final String RELATION_DESIGNER_ID = "relationDesigner";
    private static final String METRIC_DESIGNER_ID = "metricDesigner";
    private static final String QING_MODELSET_ROLE_ID = "modelSetRoleManage";
    private static final String SOURCE_MANAGE_PAGE_ID = "sourceManagePage";
    private static final String QING_MODELSET_DATA_AUTH_ID = "qingModelSetDataAuth";
    private static final String DEPLOY_MANAGE_ID = "deployManage";
    private static final String METRIC_LIBRARY_ID = "metricLibrary";
    private static final String METRIC_SYSTEM_MANAGE_ID = "metricSystemManage";
    private static final String QING_MODELER_METRIC_CARD_CONFIG = "qingModelerMetricCardConfig";
    private static final String METRIC_ANALYSIS_DESIGNER_ID = "metricAnalysisDesigner";
    private static final String METRIC_ANALYSIS_CARD_EXHIBITION_ID = "metricAnalysisCardExhibition";
    private static final String GRID_CONTAINER_PAGE_ID = "gridContainerPageId";
    private static final String GRID_CONTAINER_CARD_ID = "gridContainerCardId";
    private static final String CARD_ID = "cardId";
    private static final String BIZ_TAG = "bizTag";
    private static final String HOMEPAGE_HTML = "qdm-modelset-manage.html";
    private static final String DESIGNER_ENTRANCE_HTML = "qing-model-designer.html";
    private static final String RELATION_DESIGNER_ENTRANCE_HTML = "qing-relation-designer.html";
    private static final String METRIC_DESIGNER_ENTRANCE_HTML = "qing-metric-designer.html";
    private static final String DEPLOY_DESIGNER_ENTRANCE_HTML = "qing-deploy-model-designer.html";
    private static final String DEPLOY_METRIC_DESIGNER_ENTRANCE_HTML = "qing-deploy-metric-designer.html";
    private static final String MODELSET_ROLE_MANAGE = "qdm-modelset-role.html";
    private static final String MODELSET_MAIN_PAGE = "qdm-modelset-main-page.html";
    private static final String QING_MODELSET_SOURCE_MANAGE_PAGE_ID = "qing-model-source-manage.html";
    private static final String MODELSET_DATA_AUTH_PAGE = "qdm-modelset-auth.html";
    private static final String DEPLOY_MANAGE = "qdm-deploy-manage.html";
    private static final String METRIC_LIBRARY_MAINPAGE_HTML = "qing-metric-system-mainpage.html";
    private static final String METRIC_SYSTEM_MANAGE_HTML = "qing-metric-system-manage.html";
    private static final String METRIC_SELECT_HTML = "qing-metric-card-config.html";
    private static final String METRIC_ANALYSIS_DESIGNER_HTML = "qing-metric-analysis-designer.html";
    private static final String METRIC_ANALYSIS_CARD_EXHIBITION_HTML = "qing-metric-analysis-exhibition.html";
    private static final String MODELSET_ID = "modelSetId";
    private static final String MODELSET_NAME = "modelSetName";
    private static final String IS_PRESET = "isPreset";
    private static final String MODEL_ID = "modelId";
    private static final String MODEL_NAME = "modelName";
    private static final String MODEL_DEPLOY_ID = "modelDeployId";
    private static final String MODEL_TYPE = "modelType";
    private static final String METRIC_LIB_ITEM_ID = "metricLibId";
    private static final String METRIC_SYSTEM_ID = "systemId";
    private static final String METRIC_SYSTEM_NAME = "systemName";
    private static final String NAME = "name";

    protected String getAppID() {
        return APP_ID;
    }

    public void doHomepage(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String title = Messages.getMLS((String)HOMEPAGE_ID, (String)"\u8f7b\u5efa\u6a21\u9996\u9875", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, HOMEPAGE_HTML);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String isPreset = this.getModelSetPermissionAndPreset(request, response);
            String title = Messages.getMLS((String)DESIGNER_ID, (String)"\u8f7b\u5efa\u6a21\u8bbe\u8ba1\u5668", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, DESIGNER_ENTRANCE_HTML);
            String modelSetId = request.getParameter(MODELSET_ID);
            String modelId = request.getParameter(MODEL_ID);
            String modelName = request.getParameter(MODEL_NAME);
            String modelSetName = request.getParameter(MODELSET_NAME);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.appendParamToUrl(MODEL_ID, modelId);
            safetyURL.appendParamToUrl(MODEL_NAME, modelName);
            safetyURL.appendParamToUrl(MODELSET_NAME, modelSetName);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doRelationDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            String isPreset = this.getModelSetPermissionAndPreset(request, response);
            String title = Messages.getMLS((String)RELATION_DESIGNER_ID, (String)"\u5173\u7cfb\u6a21\u578b\u8bbe\u8ba1\u5668", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, RELATION_DESIGNER_ENTRANCE_HTML);
            String modelSetId = request.getParameter(MODELSET_ID);
            String modelId = request.getParameter(MODEL_ID);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.appendParamToUrl(MODEL_ID, modelId);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doMetricDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            String isPreset = this.getModelSetPermissionAndPreset(request, response);
            String title = Messages.getMLS((String)METRIC_DESIGNER_ID, (String)"\u6307\u6807\u6a21\u578b\u8bbe\u8ba1\u5668", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, METRIC_DESIGNER_ENTRANCE_HTML);
            String modelSetId = request.getParameter(MODELSET_ID);
            String modelId = request.getParameter(MODEL_ID);
            String modelSetName = request.getParameter(MODELSET_NAME);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.appendParamToUrl(MODEL_ID, modelId);
            safetyURL.appendParamToUrl(MODELSET_NAME, modelSetName);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doDeployDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String isPreset = this.getModelSetPermissionAndPreset(request, response);
            String modelType = request.getParameter(MODEL_TYPE);
            String html = DEPLOY_DESIGNER_ENTRANCE_HTML;
            if ("4".equals(modelType)) {
                html = DEPLOY_METRIC_DESIGNER_ENTRANCE_HTML;
            }
            String title = Messages.getMLS((String)DESIGNER_ID, (String)"\u8f7b\u5efa\u6a21\u8bbe\u8ba1\u5668", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, html);
            String modelSetId = request.getParameter(MODELSET_ID);
            String modelId = request.getParameter(MODEL_ID);
            String modelName = request.getParameter(MODEL_NAME);
            String modelDeployId = request.getParameter(MODEL_DEPLOY_ID);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.appendParamToUrl(MODEL_ID, modelId);
            safetyURL.appendParamToUrl(MODEL_NAME, modelName);
            safetyURL.appendParamToUrl(MODEL_DEPLOY_ID, modelDeployId);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doModelSetMainPageEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String modelSetId = request.getParameter(MODELSET_ID);
            String isPreset = this.getModelSetPermissionAndPreset(request, response);
            String modelSetName = request.getParameter(MODELSET_NAME);
            String title = Messages.getMLS((String)QING_MODELSET_MAIN_PAGE_ID, (String)"\u6a21\u578b\u96c6\u4e3b\u754c\u9762", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, MODELSET_MAIN_PAGE);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.appendParamToUrl(MODELSET_NAME, modelSetName);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            safetyURL.appendParamToUrl(FROM_PAGE_CLIENT_ID, request.getParameter(CURRENT_PAGE_CLIENT_ID));
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doModelSetRoleManageEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String isPreset = this.getModelSetPermissionAndPreset(request, response);
            String title = Messages.getMLS((String)QING_MODELSET_ROLE_ID, (String)"\u6a21\u578b\u96c6\u89d2\u8272\u7ba1\u7406", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            String modelSetId = request.getParameter(MODELSET_ID);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, MODELSET_ROLE_MANAGE);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doModelSetSourceManageEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String isPreset = this.getModelSetPermissionAndPreset(request, response);
            String modelSetId = request.getParameter(MODELSET_ID);
            String modelSetName = request.getParameter(MODELSET_NAME);
            String title = Messages.getMLS((String)SOURCE_MANAGE_PAGE_ID, (String)"\u6a21\u578b\u96c6\u6570\u636e\u6e90\u7ba1\u7406", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, QING_MODELSET_SOURCE_MANAGE_PAGE_ID);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.appendParamToUrl(MODELSET_NAME, modelSetName);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doDeployManageEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            this.getModelSetPermissionAndPreset(request, response);
            String modelSetId = request.getParameter(MODELSET_ID);
            String title = Messages.getMLS((String)DEPLOY_MANAGE_ID, (String)"\u90e8\u7f72\u7ba1\u7406", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, DEPLOY_MANAGE);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doDataAuthEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String isPreset = this.getModelSetPermissionAndPreset(request, response);
            String title = Messages.getMLS((String)QING_MODELSET_DATA_AUTH_ID, (String)"\u6570\u636e\u6743\u9650", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            String modelSetId = request.getParameter(MODELSET_ID);
            String modelSetName = request.getParameter(MODELSET_NAME);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, MODELSET_DATA_AUTH_PAGE);
            safetyURL.appendParamToUrl(MODELSET_ID, modelSetId);
            safetyURL.appendParamToUrl(MODELSET_NAME, modelSetName);
            safetyURL.appendParamToUrl(IS_PRESET, isPreset);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void uploadFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            QingIntegratedContext qingContext = new QingIntegratedContext();
            List fileItems = QingModelerAction.getFileItem((HttpServletRequest)request);
            if (!fileItems.isEmpty()) {
                FileItem fileItem = (FileItem)fileItems.get(0);
                this.checkUploadFile(fileItem);
                QingSharedAction.protectedUpload((QingContext)qingContext, (String)APP_ID, (FileItem)fileItem, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        catch (IOException e) {
            QingModelerAction.writeErrorJsonResponse((Throwable)e, (HttpServletResponse)response);
        }
        catch (FileUploadException e) {
            QingModelerAction.writeErrorJsonResponse((Throwable)e, (HttpServletResponse)response);
        }
        catch (FileUploadFailException e) {
            QingModelerAction.writeErrorJsonResponse((Throwable)e, (HttpServletResponse)response);
        }
    }

    public void doMetricLibraryHomePage(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean hasPermission = this.checkQingMetricLibraryPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String systemId = request.getParameter(METRIC_SYSTEM_ID);
            String systemName = request.getParameter(METRIC_SYSTEM_NAME);
            String title = Messages.getMLS((String)METRIC_LIBRARY_ID, (String)"\u6307\u6807\u5e93\u9996\u9875", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, METRIC_LIBRARY_MAINPAGE_HTML);
            safetyURL.appendParamToUrl(METRIC_SYSTEM_ID, systemId);
            safetyURL.appendParamToUrl(METRIC_SYSTEM_NAME, systemName);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doMetricSystemManage(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean hasPermission = this.checkQingMetricLibraryPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String title = Messages.getMLS((String)METRIC_SYSTEM_MANAGE_ID, (String)"\u6307\u6807\u4f53\u7cfb\u7ba1\u7406", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, METRIC_SYSTEM_MANAGE_HTML);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doMetricSelectEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingModelerAction.checkQingModelerLicense();
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String title = Messages.getMLS((String)QING_MODELER_METRIC_CARD_CONFIG, (String)"\u8f7b\u5efa\u6a21\u6307\u6807\u5361\u7247\u914d\u7f6e", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, METRIC_SELECT_HTML);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doMetricAnalysisDesignerEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean hasPermission = this.checkQingModelerPermission(request, response);
            if (!hasPermission) {
                return;
            }
            String metricLibId = request.getParameter(METRIC_LIB_ITEM_ID);
            String title = Messages.getMLS((String)METRIC_ANALYSIS_DESIGNER_ID, (String)"\u6307\u6807\u5206\u6790\u8bbe\u8ba1\u5668", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, METRIC_ANALYSIS_DESIGNER_HTML);
            safetyURL.appendParamToUrl(METRIC_LIB_ITEM_ID, metricLibId);
            safetyURL.appendParamToUrl(BIZ_TAG, request.getParameter(CARD_ID));
            safetyURL.appendParamToUrl(GRID_CONTAINER_PAGE_ID, request.getParameter(GRID_CONTAINER_PAGE_ID));
            safetyURL.appendParamToUrl(GRID_CONTAINER_CARD_ID, request.getParameter(GRID_CONTAINER_CARD_ID));
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public void doMetricAnalysisCardExhibitionEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            String metricLibId = request.getParameter(METRIC_LIB_ITEM_ID);
            String name = request.getParameter(NAME);
            name = URLDecoder.decode(name, "UTF-8");
            String title = Messages.getMLS((String)METRIC_ANALYSIS_CARD_EXHIBITION_ID, (String)"\u6307\u6807\u5206\u6790", (Messages.ProjectName)Messages.ProjectName.QING_MODELER_WEBACTIONS);
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, title, METRIC_ANALYSIS_CARD_EXHIBITION_HTML);
            safetyURL.appendParamToUrl(METRIC_LIB_ITEM_ID, metricLibId);
            safetyURL.appendParamToUrl(BIZ_TAG, request.getParameter(CARD_ID));
            safetyURL.appendParamToUrl(NAME, name);
            safetyURL.sendRedirect(response);
        }
        catch (Exception e) {
            this.handlerException(request, response, e);
        }
    }

    public final String getModelSetPermissionAndPreset(HttpServletRequest request, HttpServletResponse response) throws QingModelerNoPermissionException {
        String modelSetId = request.getParameter(MODELSET_ID);
        String modelId = request.getParameter(MODEL_ID);
        byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)APP_ID, (String)"QingModelerService", (String)"getModelSetPermissionAndPreset", (Object[])new Object[]{modelSetId, modelId});
        String res = new String(result, Charset.forName("utf-8"));
        Map resultMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
        if (resultMap.containsKey("errorCode")) {
            ResponseErrorWrap responseErrorWrap = (ResponseErrorWrap)JsonUtil.decodeFromString((String)res, ResponseErrorWrap.class);
            this.handlerError(request, response, String.valueOf(responseErrorWrap.getErrorCode()), responseErrorWrap.getErrorMessage());
            resultMap = null;
        }
        if (resultMap == null) {
            throw new QingModelerNoPermissionException("check Qing Modeler Permission failed");
        }
        Map data = (Map)resultMap.get("data");
        boolean isHavePermission = Boolean.parseBoolean(data.get("permission").toString());
        if (!isHavePermission) {
            throw QingModelerNoPermissionException.NOPERMISSIONEXCEPTION;
        }
        Object isPreset = data.get(IS_PRESET);
        if (null == isPreset) {
            return "false";
        }
        return isPreset.toString();
    }
}

