/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.qing.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.web.ServerFileAccesser;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.mservice.qingshared.common.context.QingIntegratedContext;
import kd.bos.servicehelper.DispatchServiceHelper;

public class QingExportImportApi {
    private static final String APP_ID = "qing";
    private static final String QING_SERVICE = "QingService";
    private static final String JSON_DATA = "data";
    private static final String JSON_ERROR_CODE = "errorCode";
    private static final String JSON_ERROR_MESSAGE = "errorMessage";
    private static final String JSON_ERROR_STACK = "errorStackMessage";

    public Map<String, Object> loadSubject(String userId, int page, int size, Map<String, String> queryParams) throws Exception {
        try {
            HashMap<String, String> filterQueryParams = new HashMap<String, String>(3);
            filterQueryParams.put("themeID", queryParams.get("themeID"));
            filterQueryParams.put("themeName", queryParams.get("themeName"));
            filterQueryParams.put("themeType", queryParams.get("themeType"));
            byte[] response = (byte[])DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)QING_SERVICE, (String)"loadSubject", (Object[])new Object[]{userId, page, size, filterQueryParams});
            Object data = this.handleRPCResponse(response);
            ArrayList themeInfos = new ArrayList();
            Object themeListObj = ((JSONObject)data).get((Object)"themeList");
            for (Object jsonObject : (JSONArray)themeListObj) {
                HashMap<String, String> itemFieldMap = new HashMap<String, String>(3);
                itemFieldMap.put("themeID", ((JSONObject)jsonObject).getString("themeID"));
                itemFieldMap.put("themeType", ((JSONObject)jsonObject).getString("themeType"));
                itemFieldMap.put("themeName", ((JSONObject)jsonObject).getString("themeName"));
                themeInfos.add(itemFieldMap);
            }
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("page", ((JSONObject)data).get((Object)"page"));
            result.put("size", ((JSONObject)data).get((Object)"size"));
            result.put("total", ((JSONObject)data).get((Object)"total"));
            result.put("themeList", themeInfos);
            return result;
        }
        catch (Exception e) {
            LogUtil.error((String)("QingExportImport fetchTheme exception: " + e.getMessage()));
            throw e;
        }
    }

    public void exportSubject(String userId, List<String> subjectIds, OutputStream os) throws Exception {
        try {
            byte[] response = (byte[])DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)QING_SERVICE, (String)"exportSubject", (Object[])new Object[]{userId, subjectIds});
            Object data = this.handleRPCResponse(response);
            String fileName = (String)data;
            this.loadFile(fileName, os);
        }
        catch (Exception e) {
            String exceptionType = e instanceof IOException ? "io" : APP_ID;
            LogUtil.error((String)("QingExportImport exportTheme " + exceptionType + "exception: " + e.getMessage()));
            throw e;
        }
    }

    public void importSubject(String userId, InputStream is) throws Exception {
        try {
            String fileName = this.uploadFile(is);
            byte[] response = (byte[])DispatchServiceHelper.invokeBOSService((String)APP_ID, (String)QING_SERVICE, (String)"importSubject", (Object[])new Object[]{userId, fileName});
            this.handleRPCResponse(response);
        }
        catch (Exception e) {
            String exceptionType = e instanceof IOException ? "io" : APP_ID;
            LogUtil.error((String)("QingExportImport importTheme " + exceptionType + " exception: " + e.getMessage()));
            throw e;
        }
    }

    private Object handleRPCResponse(byte[] response) throws Exception {
        String res = new String(response, StandardCharsets.UTF_8);
        Map jsonMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
        if (jsonMap.containsKey(JSON_ERROR_CODE)) {
            LogUtil.error((String)("QingExportImport handleRPCResponse error: " + jsonMap.get(JSON_ERROR_MESSAGE)));
            LogUtil.error((String)("QingExportImport handleRPCResponse error stack: " + jsonMap.get(JSON_ERROR_STACK)));
            throw new Exception(jsonMap.get(JSON_ERROR_MESSAGE) != null ? (String)jsonMap.get(JSON_ERROR_MESSAGE) : (String)jsonMap.get(JSON_ERROR_STACK));
        }
        LogUtil.info((String)("QingExportImport handleRPCResponse data: " + res));
        return jsonMap.get(JSON_DATA);
    }

    private void loadFile(String fileName, OutputStream os) throws IOException {
        ServerFileAccesser.loadFile((QingContext)new QingIntegratedContext(), (String)APP_ID, (String)fileName, (AbstractQingFileType)QingTempFileType.EXPORT, (OutputStream)os);
    }

    private String uploadFile(InputStream is) throws IOException {
        try {
            String fileNameKey = UUID.randomUUID().toString();
            int available = is.available();
            byte[] result = null;
            int index = 0;
            for (int i = available; i <= available && i > 0; i -= 0x100000) {
                byte[] buffer = new byte[i > 0x100000 ? 0x100000 : i];
                if (is.read(buffer) <= 0 || (result = ServerFileAccesser.uploadPiece((QingContext)new QingIntegratedContext(), (String)APP_ID, (String)fileNameKey, (byte[])buffer, (int)(++index))) == null) continue;
                available = -1;
                break;
            }
            if (available > 0) {
                result = ServerFileAccesser.combineUpload((QingContext)new QingIntegratedContext(), (String)APP_ID, (String)fileNameKey, (int)index);
            }
            return (String)this.handleRPCResponse(result);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

