/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.model.FieldBlackListInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;

public class AbstractSelectPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener {
    protected static final String KEY_FIELDTREE = "FieldTree";
    protected static final String KEY_FIELDS = "fields";
    protected static final String KEY_ITEMS = "Items";
    protected static final String KEY_CHECKNODES = "checkNodes";
    protected static final String KEY_VALUE = "value";
    protected static final String KEY_FORMID = "formId";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnremove"});
        TreeView fieldtree = (TreeView)this.getControl(KEY_FIELDTREE);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnDataToParentAndClose();
        } else if ("btnremove".equalsIgnoreCase(key)) {
            this.removeRefreshFields();
        }
    }

    private void returnDataToParentAndClose() {
        HashMap data = new HashMap(16);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_FIELDTREE);
        List selNodes = treeView.getTreeState().getCheckedNodes();
        ArrayList<FieldBlackListInfo> selFields = new ArrayList<FieldBlackListInfo>(selNodes.size());
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        for (int i = 0; i < selNodes.size(); ++i) {
            boolean isParent;
            Map node = (Map)selNodes.get(i);
            if (node == null) continue;
            boolean bl = isParent = node.get("isParent") != null && (Boolean)node.get("isParent") != false;
            if (isParent) continue;
            String id = (String)node.get("id");
            String parentId = (String)node.get("parentid");
            String name = this.getFormatName((String)node.get("text"), id);
            FieldBlackListInfo fieldInfo = new FieldBlackListInfo(id, id, name, parentId);
            fieldInfo.setDisable(true);
            fieldInfo.setFormId(formId);
            selFields.add(fieldInfo);
        }
        data.put("Fields", selFields);
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    protected String getFormatName(String name, String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return name;
        }
        return name + "(" + key + ")";
    }

    protected void removeRefreshFields() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_FIELDS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79fb\u9664\u7684\u884c", (String)"AbstractSelectPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)model.getValue("fkey", row));
        }
        model.deleteEntryRows(KEY_FIELDS, rows);
        TreeView tree = (TreeView)this.getView().getControl(KEY_FIELDTREE);
        tree.uncheckNodes(nodeIds);
        this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    protected void buildTreeNode(String value, TreeNode root, TreeView tree) {
        this.getPageCache().put(KEY_FIELDTREE, SerializationUtils.toJsonString((Object)root));
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>();
        ArrayList<String> checkNodeIds = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            IDataModel model = this.getModel();
            model.deleteEntryData(KEY_FIELDS);
            List fieldIds = SerializationUtils.fromJsonStringToList((String)value, FieldBlackListInfo.class);
            for (FieldBlackListInfo fieldId : fieldIds) {
                String id = fieldId.getId();
                TreeNode node = root.getTreeNode(id, 16);
                if (node == null || node.getChildren() != null) continue;
                checkNodes.add(node);
                checkNodeIds.add(node.getId());
                int rowindex = model.createNewEntryRow(KEY_FIELDS);
                model.setValue("fkey", (Object)node.getId(), rowindex);
                model.setValue("fname", (Object)node.getText(), rowindex);
                String parentId = node.getId();
                while (!root.getId().equals(node.getParentid())) {
                    parentId = node.getParentid() + "." + parentId;
                    node = root.getTreeNode(node.getParentid(), root.getNodeLevel(node.getId(), 1));
                }
                model.setValue("fparentid", (Object)parentId, rowindex);
                this.getPageCache().put(id, parentId);
            }
            tree.checkNodes(checkNodes);
        }
        this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString(checkNodeIds));
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_FIELDTREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(KEY_FIELDTREE);
        ArrayList currChecks = new ArrayList(tree.getTreeState().getCheckedNodeIds());
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_CHECKNODES), List.class);
        IDataModel model = this.getModel();
        if (evt.getChecked().booleanValue()) {
            if (checkNodes.isEmpty() || currChecks.removeAll(checkNodes)) {
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    if (node == null) continue;
                    String parentId = node.getId();
                    if (node.getChildren() != null) continue;
                    int row = model.createNewEntryRow(KEY_FIELDS);
                    model.setValue("fkey", (Object)node.getId(), row);
                    model.setValue("fname", (Object)node.getText(), row);
                    while (!root.getId().equals(node.getParentid())) {
                        parentId = node.getParentid() + "." + parentId;
                        node = root.getTreeNode(node.getParentid(), root.getNodeLevel(node.getId(), 1));
                    }
                    model.setValue("fparentid", (Object)parentId, row);
                    this.getPageCache().put(id, parentId);
                }
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                checkNodes.remove(i);
            }
            int[] rows = new int[checkNodes.size()];
            int j = 0;
            for (int i = model.getEntryRowCount(KEY_FIELDS) - 1; i >= 0; --i) {
                if (!checkNodes.contains(model.getValue("fkey", i))) continue;
                rows[j++] = i;
            }
            model.deleteEntryRows(KEY_FIELDS, rows);
        }
        this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }
}

