/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.productmodel.kit.AppBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.FormBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.ProductModeTypeUtil;
import kd.bos.designer.productmodel.model.AppBlackListInfo;
import kd.bos.designer.productmodel.model.FeatureBlackListInfo;
import kd.bos.designer.productmodel.model.FunctionBlackListInfo;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class AppBlackListPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SEARCHBLACKLIST = "searchblacklist";
    private static final String CACHEID_BLACKLIST = "BlackList_CacheId";
    private static final String FORMID_SELECTFUNCTIONBLACKLIST = "bos_function_select_edit";
    private static final String FORMID_NEWFORMBLACKLIST = "bos_form_black_list";
    private static final String FORMID_FEATURES_BLACKLIST = "bos_features_blacklist";
    private static final String KEY_CLOUDID = "cloudid";
    private static final String KEY_APP = "app";
    private static final String KEY_APPID = "appid";
    private static final String KEY_APPNAME = "appname";
    private static final String KEY_APPNUM = "appnum";
    private static final String KEY_FUNCTION = "functions";
    private static final String KEY_FUNCTION_INNER = "functionsinner";
    private static final String KEY_FEATURES_INNER = "featuresinner";
    private static final String KEY_FORMS = "forms";
    private static final String KEY_DISABLE = "disable";
    private static final String KEY_ID = "id";
    protected static final String KEY_PRODUCTMODEL = "productmodel";
    private static final String KEY_EXPORTAPP = "exportapp";
    private static final String KEY_FEATURES = "features";
    private List<AppBlackListInfo> blackListInfos;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main"});
        this.addClickListeners(new String[]{KEY_FUNCTION, KEY_FORMS, KEY_FEATURES});
        Search search = (Search)this.getControl(KEY_SEARCHBLACKLIST);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(CACHEID_BLACKLIST);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            Donothing op = (Donothing)args.getSource();
            String key = op.getOperateKey();
            AppBlackListInfo blackList = this.getSelectBlacList();
            if (null == blackList) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"AppBlackListPlugin_3", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                return;
            }
            if (KEY_EXPORTAPP.equals(key)) {
                String productModel = (String)this.getView().getParentView().getModel().getValue(KEY_PRODUCTMODEL);
                String url = FormBlackListSaveHelper.exportResourceFile(productModel, blackList);
                if (url == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e94\u7528\u4e0b\u6ca1\u6709\u914d\u7f6e\u8868\u5355\u9ed1\u540d\u5355\uff0c\u8bf7\u914d\u7f6e\u540e\u5bfc\u51fa\u8d44\u6e90\u6587\u4ef6\u3002", (String)"AppBlackListPlugin_4", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                } else {
                    this.getView().download(url);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<AppBlackListInfo> allAppBlackList = this.loadAllAppBlackList();
        this.putBlackListCache(allAppBlackList);
        this.doSearch("");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_FUNCTION.equals(key)) {
            this.showSelectMenu();
        } else if (KEY_FORMS.equals(key)) {
            this.showSelectForm();
        } else if (KEY_FEATURES.equals(key)) {
            this.showFeaturesList();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equalsIgnoreCase(KEY_FUNCTION)) {
            this.afterShowFunction(closedCallBackEvent);
        } else if (actionId.equalsIgnoreCase(KEY_FEATURES)) {
            this.afterShowFeatures(closedCallBackEvent);
        }
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCHBLACKLIST, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearch(searchText);
        }
    }

    private void showSelectMenu() {
        String appId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFUNCTIONBLACKLIST);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APP, rowIndex);
        String functions = (String)this.getModel().getValue(KEY_FUNCTION_INNER, rowIndex);
        String string = appId = app == null ? "" : app.getPkValue().toString();
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        showParameter.getCustomParams().put(KEY_APPID, appId);
        showParameter.getCustomParams().put("value", functions);
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
        showParameter.getCustomParams().put(KEY_PRODUCTMODEL, modelType);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_FUNCTION);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showFeaturesList() {
        String appId;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(FORMID_FEATURES_BLACKLIST);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APP, rowIndex);
        String selectFeatures = (String)this.getModel().getValue(KEY_FEATURES_INNER, rowIndex);
        String string = appId = app == null ? "" : app.getPkValue().toString();
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        parameter.getCustomParams().put(KEY_APPID, appId);
        String cloudId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_CLOUDID);
        parameter.getCustomParams().put(KEY_CLOUDID, cloudId);
        parameter.getCustomParams().put("value", selectFeatures);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_FEATURES);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void showSelectForm() {
        String appId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_NEWFORMBLACKLIST);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APP, rowIndex);
        String string = appId = app == null ? "" : app.getPkValue().toString();
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        showParameter.getCustomParams().put(KEY_APPID, appId);
        showParameter.getCustomParams().put(KEY_PRODUCTMODEL, this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_FORMS);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void afterShowFeatures(ClosedCallBackEvent event) {
        String featuresStr;
        Map returnData = (Map)event.getReturnData();
        if (returnData != null && StringUtils.isNotBlank((CharSequence)(featuresStr = (String)returnData.get(KEY_FEATURES)))) {
            List selectFeatures = SerializationUtils.fromJsonStringToList((String)featuresStr, FeatureBlackListInfo.class);
            StringBuilder displayStr = new StringBuilder();
            for (FeatureBlackListInfo info : selectFeatures) {
                displayStr.append(',');
                displayStr.append(info.getFeatureName());
            }
            if (displayStr.length() > 0) {
                displayStr.deleteCharAt(0);
            }
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_FEATURES, (Object)displayStr.toString(), index);
            this.getModel().setValue(KEY_FEATURES_INNER, (Object)featuresStr, index);
        }
    }

    private void afterShowFunction(ClosedCallBackEvent closedCallBackEvent) {
        String menuesStr;
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null && StringUtils.isNotBlank((CharSequence)(menuesStr = (String)returnData.get("Menues")))) {
            List menues = SerializationUtils.fromJsonStringToList((String)menuesStr, FunctionBlackListInfo.class);
            StringBuilder displayStr = new StringBuilder();
            for (int i = 0; i < menues.size(); ++i) {
                FunctionBlackListInfo info = (FunctionBlackListInfo)menues.get(i);
                if (i == 0) {
                    displayStr.append(info.getMenuName());
                    continue;
                }
                displayStr.append(',').append(info.getMenuName());
            }
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_FUNCTION, (Object)displayStr.toString(), index);
            this.getModel().setValue(KEY_FUNCTION_INNER, (Object)menuesStr, index);
        }
    }

    private AppBlackListInfo getSelectBlacList() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || rowIndex < 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"AppBlackListPlugin_5", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return null;
        }
        String fid = (String)this.getModel().getValue(KEY_APPID, rowIndex);
        List<AppBlackListInfo> allBlackLists = this.getBlackListCache();
        AppBlackListInfo blackList = null;
        for (AppBlackListInfo app : allBlackLists) {
            if (!fid.equals(app.getAppId())) continue;
            blackList = app;
            break;
        }
        return blackList;
    }

    private void doSearch(String searchText) {
        List<AppBlackListInfo> allBlackLists = this.getBlackListCache();
        ArrayList<AppBlackListInfo> blackLists = new ArrayList<AppBlackListInfo>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            blackLists.addAll(allBlackLists);
        } else {
            for (AppBlackListInfo app : allBlackLists) {
                if ((!StringUtils.isNotBlank((CharSequence)app.getAppName()) || app.getAppName().indexOf(searchText) < 0) && (!StringUtils.isNotBlank((CharSequence)app.getAppId()) || app.getAppId().indexOf(searchText) < 0)) continue;
                blackLists.add(app);
            }
        }
        this.refreshEntryGrid(blackLists);
    }

    private void refreshEntryGrid(List<AppBlackListInfo> appBlackLists) {
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        if (!appBlackLists.isEmpty()) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, appBlackLists.size());
            for (int index = 0; index < appBlackLists.size(); ++index) {
                AppBlackListInfo app = appBlackLists.get(index);
                this.renderRow(app, index);
            }
            this.getModel().endInit();
        }
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private void renderRow(AppBlackListInfo app, int rowIndex) {
        this.getModel().setValue(KEY_APP, (Object)app.getAppId(), rowIndex);
        this.getModel().setValue(KEY_APPID, (Object)app.getAppId(), rowIndex);
        this.getModel().setValue(KEY_APPNAME, (Object)app.getAppName(), rowIndex);
        this.getModel().setValue(KEY_DISABLE, (Object)app.isDisable(), rowIndex);
        this.getModel().setValue(KEY_FUNCTION, (Object)app.getFunctionDisplay(), rowIndex);
        this.getModel().setValue(KEY_FUNCTION_INNER, (Object)app.getFunctionInner(), rowIndex);
        this.getModel().setValue(KEY_APPNUM, (Object)app.getAppNum(), rowIndex);
        this.getModel().setValue(KEY_ID, (Object)app.getId(), rowIndex);
        this.getModel().setValue(KEY_FEATURES, (Object)app.getFeatureDisplay(), rowIndex);
        this.getModel().setValue(KEY_FEATURES_INNER, (Object)app.getFeatureInner(), rowIndex);
    }

    protected boolean existScheme(String appId) {
        List<AppBlackListInfo> allBlackLists = this.getBlackListCache();
        if (allBlackLists == null || allBlackLists.isEmpty()) {
            return false;
        }
        for (AppBlackListInfo blackList : allBlackLists) {
            if (!appId.equals(blackList.getAppId())) continue;
            return true;
        }
        return false;
    }

    private void putBlackListCache(List<AppBlackListInfo> blackLists) {
        String blackListsJsonString = SerializationUtils.toJsonString(blackLists);
        this.getPageCache().put(CACHEID_BLACKLIST, blackListsJsonString);
        this.blackListInfos = blackLists;
    }

    private List<AppBlackListInfo> getBlackListCache() {
        if (this.blackListInfos != null && !this.blackListInfos.isEmpty()) {
            return this.blackListInfos;
        }
        String blackListJsonString = this.getPageCache().get(CACHEID_BLACKLIST);
        if (StringUtils.isNotBlank((CharSequence)blackListJsonString) && !"[]".equals(blackListJsonString)) {
            this.blackListInfos = SerializationUtils.fromJsonStringToList((String)blackListJsonString, AppBlackListInfo.class);
        }
        return this.blackListInfos;
    }

    private List<AppBlackListInfo> loadAllAppBlackList() {
        ArrayList<AppBlackListInfo> allApps = new ArrayList<AppBlackListInfo>(10);
        String cloudId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_CLOUDID);
        QFilter[] filters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])null, (String)KEY_ID);
        DynamicObjectCollection apps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,type,parentid,inheritpath,bizcloud,deploystatus,visible", (QFilter[])filters);
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
        Map<String, AppBlackListInfo> blackList = AppBlackListSaveHelper.getAppBlackList(modelType, apps);
        for (DynamicObject app : apps) {
            String bizCloudId = app.getString("bizcloud");
            if (cloudId != null && !cloudId.equals(bizCloudId)) continue;
            String appId = app.getString(KEY_ID);
            AppBlackListInfo appValue = blackList.get(appId);
            if (appValue != null) {
                allApps.add(blackList.get(appId));
                continue;
            }
            String appName = app.getString("name");
            String appNum = app.getString("number");
            long id = DB.genGlobalLongId();
            AppBlackListInfo appInfo = new AppBlackListInfo(id, cloudId, appId, appName, appNum, false, "", "");
            appInfo.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
            allApps.add(appInfo);
        }
        return allApps;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changedPropertyName = e.getProperty().getName();
        if (KEY_DISABLE.equals(changedPropertyName) || KEY_FUNCTION_INNER.equals(changedPropertyName)) {
            AppBlackListInfo info = this.getSelectBlacList();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            String menuStrInner = (String)this.getModel().getValue(KEY_FUNCTION_INNER, rowIndex);
            String menuStr = (String)this.getModel().getValue(KEY_FUNCTION, rowIndex);
            String featureStr = (String)this.getModel().getValue(KEY_FEATURES, rowIndex);
            String featureStrInner = (String)this.getModel().getValue(KEY_FEATURES_INNER, rowIndex);
            Boolean disable = (Boolean)this.getModel().getValue(KEY_DISABLE, rowIndex);
            if (info == null) {
                String cloudId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_CLOUDID);
                String appId = (String)this.getModel().getValue(KEY_APPID, rowIndex);
                String appName = (String)this.getModel().getValue(KEY_APPNAME, rowIndex);
                String appNum = (String)this.getModel().getValue(KEY_APPNUM, rowIndex);
                long id = DB.genGlobalLongId();
                info = new AppBlackListInfo(id, cloudId, appId, appName);
                info.setAppNum(appNum);
            }
            info.setFunctionDisplay(menuStr);
            info.setFunctionInner(menuStrInner);
            info.setFeatureDisplay(featureStr);
            info.setFeatureInner(featureStrInner);
            info.setDisable(disable);
            String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
            AppBlackListSaveHelper.updateToDB(modelType, info);
        }
    }
}

