/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.CloudBlackListPlugin;
import kd.bos.designer.productmodel.kit.AppBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.CloudBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.FormBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.ProductModeTypeUtil;
import kd.bos.designer.productmodel.model.AppBlackListInfo;
import kd.bos.designer.productmodel.model.CloudBlackListInfo;
import kd.bos.designer.productmodel.model.FormBlackListInfo;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class BlackListTreeEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_SAVE = "btnsave";
    private static final String KEY_CLOUDID = "cloudid";
    private static final String KEY_CLOUDNAME = "cloudname";
    private static final String KEY_CLOUDNUM = "cloudnum";
    private static final String KEY_ID = "id";
    private static final String KEY_DISABLE = "disable";
    private static final String KEY_APPID = "appid";
    private static final String KEY_APPNAME = "appname";
    private static final String KEY_APPNUM = "appnum";
    private static final String KEY_FUNCTION = "functions";
    private static final String KEY_FUNCTIONINNER = "functionsinner";
    private static final String KEY_FEATURE = "features";
    private static final String KEY_FEATURE_INNER = "featuresinner";
    private static final String KEY_ENRYENTITY = "entryentity";
    private static final String CACHEID_SHOWFORMPAGEID = "TabProductModelSettings_PageId";
    private static final String FORMID_CLOUD = "bos_cloud_black_list";
    private static final String FORMID_APP = "bos_app_black_list";
    private static final String KEY_CLOUDCLEARCACHE = "btncloudclearcache";
    private static final String KEY_APPCLEARCACHE = "btnappclearcache";
    private static final String KEY_CLEARCACHE = "clearcache";
    private static final String KEY_EXPORT = "export";
    private static final String KEY_EXPORTCLOUD = "exportcloud";
    private static final String KEY_RESETBLACKLIST = "resetblacklist";
    private static final String KEY_PRODUCTMODEL = "productmodel";
    private static final String KEY_CLEARSYSTEMCACHE = "clearsystemcache";

    public void initialize() {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"tbar_main"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeNode rootNode = this.buildTree();
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.addNode(rootNode);
        tView.treeNodeClick(rootNode.getParentid(), rootNode.getId());
        tView.focusNode(rootNode);
        this.checkTable();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String modelType = (String)this.getModel().getValue(KEY_PRODUCTMODEL);
        String msg = ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\u3002", (String)"BlackListTreeEditPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]);
        switch (key) {
            case "btnsave": {
                if (this.hasRight()) {
                    String showFormPageId = this.getPageCache().get(CACHEID_SHOWFORMPAGEID);
                    FormView showFormView = (FormView)this.getView().getView(showFormPageId);
                    String formId = showFormView.getFormId();
                    if (FORMID_CLOUD.equals(formId)) {
                        this.saveAllClouds(showFormView);
                    } else if (FORMID_APP.equals(formId)) {
                        this.saveAllApps(showFormView);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BlackListTreeEditPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u672a\u6388\u6743\uff0c\u8bf7\u8fdb\u884c\u6388\u6743\u3002", (String)"BlackListTreeEditPlugin_2", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                break;
            }
            case "btncloudclearcache": {
                CloudBlackListSaveHelper.clearCache(modelType);
                this.focusRoot();
                this.getView().showSuccessNotification(msg);
                break;
            }
            case "btnappclearcache": {
                AppBlackListSaveHelper.clearCache(modelType);
                this.focusRoot();
                this.getView().showSuccessNotification(msg);
                break;
            }
            case "clearcache": {
                CloudBlackListSaveHelper.clearCache(modelType);
                AppBlackListSaveHelper.clearCache(modelType);
                FormBlackListSaveHelper.clearCache(modelType);
                this.focusRoot();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\uff01", (String)"BlackListTreeEditPlugin_3", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                break;
            }
            case "export": {
                String url = FormBlackListSaveHelper.exportResourceFile(modelType);
                String blackListUrl = CloudBlackListSaveHelper.exportResourceFile(modelType);
                this.getView().download(url);
                this.getView().download(blackListUrl);
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff01\u4e0b\u8f7d\u5730\u5740\uff1a%s", (String)"BlackListTreeEditPlugin_4", (String)"bos-productmodel-resource", (Object[])new Object[0]), url));
                break;
            }
            case "exportcloud": {
                String blUrl = CloudBlackListSaveHelper.exportResourceFile(modelType);
                this.getView().download(blUrl);
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff01\u4e0b\u8f7d\u5730\u5740\uff1a%s", (String)"BlackListTreeEditPlugin_4", (String)"bos-productmodel-resource", (Object[])new Object[0]), blUrl));
                break;
            }
            case "resetblacklist": {
                this.doBeforeDelete();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f!", (String)"BlackListTreeEditPlugin_5", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                break;
            }
            case "clearsystemcache": {
                CloudBlackListSaveHelper.resetBlackList(modelType);
                CloudBlackListSaveHelper.clearCache(modelType);
                AppBlackListSaveHelper.clearCache(modelType);
                FormBlackListSaveHelper.clearCache(modelType);
                this.focusRoot();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f!", (String)"BlackListTreeEditPlugin_6", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = String.valueOf(evt.getNodeId());
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        String modelType = (String)this.getModel().getValue(KEY_PRODUCTMODEL);
        param.put(KEY_PRODUCTMODEL, modelType);
        if ("0".equals(nodeId)) {
            param.put(KEY_CLOUDID, nodeId);
            this.showForm(FORMID_CLOUD, param);
        } else {
            param.put(KEY_CLOUDID, nodeId);
            param.put(KEY_APPID, nodeId);
            this.showForm(FORMID_APP, param);
        }
    }

    private void focusRoot() {
        this.showForm(FORMID_CLOUD, null);
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BlackListTreeEditPlugin_7", (String)"bos-productmodel-resource", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.treeNodeClick(root.getParentid(), root.getId());
        tView.focusNode(root);
    }

    private void showForm(String formId, Map<String, Object> param) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("settingspanel");
        showParameter.setFormId(formId);
        if (param != null) {
            showParameter.getCustomParams().putAll(param);
        }
        this.getView().showForm(showParameter);
        this.getPageCache().put(CACHEID_SHOWFORMPAGEID, showParameter.getPageId());
    }

    private TreeNode buildTree() {
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u4e91\u540d\u5355", (String)"BlackListTreeEditPlugin_8", (String)"bos-productmodel-resource", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudData();
        root.addChildren(cloudNodes);
        ArrayList<TreeNode> tmpList = new ArrayList<TreeNode>();
        tmpList.addAll(cloudNodes);
        HashMap idMap = new HashMap();
        tmpList.forEach(node -> idMap.put(node.getId(), node));
        tmpList.forEach(node -> {
            if (idMap.containsKey(node.getParentid())) {
                TreeNode treeNode = (TreeNode)idMap.get(node.getParentid());
                treeNode.addChild(node);
            }
        });
        return root;
    }

    private List<TreeNode> getCloudData() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>(10);
        String selectFields = "id, sequence, number, name, image, backimage";
        QFilter[] filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])null, (String)KEY_ID);
        Set<String> cloudWhiteList = CloudBlackListPlugin.getCloudWhiteList();
        filters = RunModeServiceHelper.addFilterToFilters((QFilter[])filters, (QFilter)new QFilter(KEY_ID, "in", cloudWhiteList));
        DynamicObjectCollection clouds = QueryServiceHelper.query((String)"bos_devportal_bizcloud", (String)selectFields, (QFilter[])filters, (String)"sequence asc");
        for (DynamicObject cloud : clouds) {
            TreeNode node = new TreeNode();
            String nodeID = cloud.getString(KEY_ID);
            node.setText(cloud.getString("name"));
            node.setParentid("0");
            node.setId(nodeID);
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private void saveAllClouds(FormView view) {
        DynamicObjectCollection entryRows = view.getModel().getEntryEntity(KEY_ENRYENTITY);
        if (entryRows == null || entryRows.isEmpty()) {
            return;
        }
        String modelType = (String)this.getModel().getValue(KEY_PRODUCTMODEL);
        HashMap<String, CloudBlackListInfo> infos = new HashMap<String, CloudBlackListInfo>(entryRows.size());
        for (DynamicObject row : entryRows) {
            String cloudId = row.getString(KEY_CLOUDID);
            String name = row.getString(KEY_CLOUDNAME);
            String num = row.getString(KEY_CLOUDNUM);
            boolean disable = row.getBoolean(KEY_DISABLE);
            String idStr = row.getString(KEY_ID);
            long id = StringUtils.isBlank((CharSequence)idStr) ? 0L : Long.parseLong(idStr);
            CloudBlackListInfo info = new CloudBlackListInfo(id, cloudId, name, num, disable);
            info.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
            infos.put(cloudId, info);
        }
        CloudBlackListSaveHelper.updateToDBBatch(modelType, infos);
    }

    private void saveAllApps(FormView view) {
        DynamicObjectCollection entryRows = view.getModel().getEntryEntity(KEY_ENRYENTITY);
        if (entryRows == null || entryRows.isEmpty()) {
            return;
        }
        String cloudId = (String)view.getFormShowParameter().getCustomParam(KEY_CLOUDID);
        String modelType = (String)this.getModel().getValue(KEY_PRODUCTMODEL);
        HashMap<String, AppBlackListInfo> infos = new HashMap<String, AppBlackListInfo>(entryRows.size());
        for (DynamicObject row : entryRows) {
            String appId = row.getString(KEY_APPID);
            String appName = row.getString(KEY_APPNAME);
            String appNum = row.getString(KEY_APPNUM);
            boolean disable = row.getBoolean(KEY_DISABLE);
            String functionStr = row.getString(KEY_FUNCTION);
            String functionStrInner = row.getString(KEY_FUNCTIONINNER);
            String featureStr = row.getString(KEY_FEATURE);
            String featureStrInner = row.getString(KEY_FEATURE_INNER);
            String idStr = row.getString(KEY_ID);
            long id = StringUtils.isBlank((CharSequence)idStr) ? 0L : Long.parseLong(idStr);
            AppBlackListInfo info = new AppBlackListInfo(id, cloudId, appId, appName);
            info.setDisable(disable);
            info.setFunctionDisplay(functionStr);
            info.setFunctionInner(functionStrInner);
            info.setFeatureDisplay(featureStr);
            info.setFeatureInner(featureStrInner);
            info.setAppNum(appNum);
            info.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
            infos.put(appId, info);
        }
        AppBlackListSaveHelper.updateToDBBatch(modelType, infos);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_PRODUCTMODEL.equals(e.getProperty().getName())) {
            this.focusRoot();
        }
    }

    private void checkTable() {
        CloudBlackListInfo.checkCreateTable();
        AppBlackListInfo.checkCreateTable();
        FormBlackListInfo.checkCreateTable();
    }

    private void doBeforeDelete() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u6e05\u9664\u9ed1\u540d\u5355\u914d\u7f6e\u5417\uff1f", (String)"BlackListTreeEditPlugin_9", (String)"bos-productmodel-resource", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_DELETE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String modelType = (String)this.getModel().getValue(KEY_PRODUCTMODEL);
            CloudBlackListSaveHelper.deleteAll(modelType);
            AppBlackListSaveHelper.deleteAll(modelType);
            FormBlackListSaveHelper.deleteAll(modelType);
            this.focusRoot();
        }
    }

    private boolean hasRight() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter());
        return permissionService.checkPermission(userId, bizAppId, this.getView().getEntityId(), "4715a0df000000ac");
    }
}

