/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.productmodel.kit.CloudBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.FormBlackListSaveHelper;
import kd.bos.designer.productmodel.model.CloudBlackListInfo;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class CloudBlackListPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SEARCHBLACKLIST = "searchcloud";
    private static final String KEY_CLOUD = "cloud";
    private static final String KEY_CLOUDID = "cloudid";
    private static final String KEY_CLOUDNAME = "cloudname";
    private static final String KEY_DISABLE = "disable";
    private static final String KEY_CLOUDNUM = "cloudnum";
    private static final String KEY_ID = "id";
    private static final String CACHEID_CLOUDBLACKLIST = "CloudBlackList";
    private static final String KEY_PRODUCTMODEL = "productmodel";
    private static final String KEY_EXPORTCLOUD = "exportcloud";
    private List<CloudBlackListInfo> cloudBlackListInfos;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main"});
        Search search = (Search)this.getControl(KEY_SEARCHBLACKLIST);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(CACHEID_CLOUDBLACKLIST);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            Donothing op = (Donothing)args.getSource();
            String key = op.getOperateKey();
            CloudBlackListInfo blackList = this.getSelectBlacList();
            if (null == blackList) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u53ef\u80fd\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"CloudBlackListPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                return;
            }
            if (KEY_EXPORTCLOUD.equals(key)) {
                String productModel = (String)this.getView().getParentView().getModel().getValue(KEY_PRODUCTMODEL);
                String url = FormBlackListSaveHelper.exportResourceFile(productModel, blackList);
                String blackListUrl = CloudBlackListSaveHelper.exportResourceFile(productModel, blackList);
                this.getView().download(url);
                this.getView().download(blackListUrl);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<CloudBlackListInfo> allCloudBlackList = this.loadAllCloudBlackList();
        this.putBlackListCache(allCloudBlackList);
        this.doSearch("");
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCHBLACKLIST, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearch(searchText);
        }
    }

    private CloudBlackListInfo getSelectBlacList() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || rowIndex < 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"CloudBlackListPlugin_2", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return null;
        }
        String fid = (String)this.getModel().getValue(KEY_CLOUDID, rowIndex);
        List<CloudBlackListInfo> allBlackLists = this.getBlackListCache();
        CloudBlackListInfo blackList = null;
        for (CloudBlackListInfo cloud : allBlackLists) {
            if (!fid.equals(cloud.getCloudId())) continue;
            blackList = cloud;
            break;
        }
        return blackList;
    }

    protected static Set<String> getCloudWhiteList() {
        HashSet<String> whitelist = new HashSet<String>();
        String whiteListSql = "select fcloudid from t_meta_cloudwhitelist";
        List whiteListIds = (List)DB.query((DBRoute)DBRoute.meta, (String)whiteListSql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                return ids;
            }
        });
        if (whiteListIds.isEmpty()) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("isv", "=", (Object)"kingdee"), new QFilter(KEY_ID, "in", (Object)whiteListIds)};
        Map clouds = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"id,number", (QFilter[])qFilters);
        if (clouds != null && !clouds.isEmpty()) {
            for (Object cloudId : clouds.keySet()) {
                whitelist.add((String)cloudId);
            }
        }
        return whitelist;
    }

    private void doSearch(String searchText) {
        List<CloudBlackListInfo> allBlackLists = this.getBlackListCache();
        ArrayList<CloudBlackListInfo> blackLists = new ArrayList<CloudBlackListInfo>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            blackLists.addAll(allBlackLists);
        } else {
            for (CloudBlackListInfo cloud : allBlackLists) {
                if ((!StringUtils.isNotBlank((CharSequence)cloud.getCloudName()) || cloud.getCloudName().indexOf(searchText) < 0) && (!StringUtils.isNotBlank((CharSequence)cloud.getCloudId()) || cloud.getCloudId().indexOf(searchText) < 0)) continue;
                blackLists.add(cloud);
            }
        }
        this.refreshEntryGrid(blackLists);
    }

    private void refreshEntryGrid(List<CloudBlackListInfo> cloudBlackLists) {
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        Set<String> cloudWhiteList = CloudBlackListPlugin.getCloudWhiteList();
        if (cloudWhiteList != null && !cloudWhiteList.isEmpty() && !cloudBlackLists.isEmpty()) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, cloudWhiteList.size());
            int index = 0;
            int row = 0;
            while (index < cloudBlackLists.size() && row < cloudWhiteList.size()) {
                CloudBlackListInfo cloud;
                if (!cloudWhiteList.contains((cloud = cloudBlackLists.get(index++)).getCloudId())) continue;
                this.renderRow(cloud, row++);
            }
            this.getModel().endInit();
        }
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private void renderRow(CloudBlackListInfo cloud, int rowIndex) {
        this.getModel().setValue(KEY_CLOUD, (Object)cloud.getCloudId(), rowIndex);
        this.getModel().setValue(KEY_CLOUDID, (Object)cloud.getCloudId(), rowIndex);
        this.getModel().setValue(KEY_CLOUDNAME, (Object)cloud.getCloudName(), rowIndex);
        this.getModel().setValue(KEY_DISABLE, (Object)cloud.isDisable(), rowIndex);
        this.getModel().setValue(KEY_CLOUDNUM, (Object)cloud.getCloudNum(), rowIndex);
        this.getModel().setValue(KEY_ID, (Object)cloud.getId(), rowIndex);
    }

    protected boolean existScheme(String cloudId) {
        List<CloudBlackListInfo> allBlackLists = this.getBlackListCache();
        if (allBlackLists == null || allBlackLists.isEmpty()) {
            return false;
        }
        for (CloudBlackListInfo blackList : allBlackLists) {
            if (!cloudId.equals(blackList.getCloudId())) continue;
            return true;
        }
        return false;
    }

    private void putBlackListCache(List<CloudBlackListInfo> blackLists) {
        String blackListsJsonString = SerializationUtils.toJsonString(blackLists);
        this.getPageCache().put(CACHEID_CLOUDBLACKLIST, blackListsJsonString);
        this.cloudBlackListInfos = blackLists;
    }

    private List<CloudBlackListInfo> getBlackListCache() {
        if (this.cloudBlackListInfos != null && !this.cloudBlackListInfos.isEmpty()) {
            return this.cloudBlackListInfos;
        }
        String blackListJsonString = this.getPageCache().get(CACHEID_CLOUDBLACKLIST);
        this.cloudBlackListInfos = StringUtils.isBlank((CharSequence)blackListJsonString) || "[]".equals(blackListJsonString) ? this.loadAllCloudBlackList() : SerializationUtils.fromJsonStringToList((String)blackListJsonString, CloudBlackListInfo.class);
        return this.cloudBlackListInfos;
    }

    private List<CloudBlackListInfo> loadAllCloudBlackList() {
        String selectFields = "id, sequence, number, name, image, backimage";
        QFilter[] filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])null, (String)KEY_ID);
        DynamicObjectCollection clouds = QueryServiceHelper.query((String)"bos_devportal_bizcloud", (String)selectFields, (QFilter[])filters, (String)"sequence asc");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
        Map<String, CloudBlackListInfo> blackList = CloudBlackListSaveHelper.getCloudBlackList(modelType, clouds);
        ArrayList<CloudBlackListInfo> allClouds = new ArrayList<CloudBlackListInfo>(10);
        for (DynamicObject cloud : clouds) {
            String cloudId = cloud.getString(KEY_ID);
            CloudBlackListInfo cloudValue = blackList.get(cloudId);
            if (cloudValue != null) {
                allClouds.add(blackList.get(cloudId));
                continue;
            }
            String cloudName = cloud.getString("name");
            String cloudNum = cloud.getString("number");
            long id = DB.genGlobalLongId();
            CloudBlackListInfo cloudInfo = new CloudBlackListInfo(id, cloudId, cloudName, cloudNum, false);
            allClouds.add(cloudInfo);
        }
        return allClouds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changedPropertyName = e.getProperty().getName();
        if (KEY_DISABLE.equals(changedPropertyName)) {
            CloudBlackListInfo info = this.getSelectBlacList();
            if (info == null) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
                String cloudId = (String)this.getModel().getValue(KEY_CLOUDID, rowIndex);
                String cloudName = (String)this.getModel().getValue(KEY_CLOUDNAME, rowIndex);
                String cloudNum = (String)this.getModel().getValue(KEY_CLOUDNAME, rowIndex);
                String idStr = (String)this.getModel().getValue(KEY_CLOUDNAME, rowIndex);
                long id = StringUtils.isBlank((CharSequence)idStr) ? 0L : Long.parseLong(idStr);
                info = new CloudBlackListInfo(cloudId, cloudName);
                info.setId(id);
                info.setCloudNum(cloudNum);
            }
            Boolean disable = (Boolean)e.getChangeSet()[0].getNewValue();
            info.setDisable(disable);
            String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
            CloudBlackListSaveHelper.updateToDB(modelType, info);
        }
    }
}

