/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.model.FeatureBlackListInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FeatureSelectPlugin
extends AbstractFormPlugin
implements ClickListener,
HyperLinkClickListener,
ItemClickListener {
    private static final String Key_AppId = "appid";
    private static final String Key_EntryEntity = "entryentity";
    private static final String Key_Number = "number";
    private static final String Key_Name = "name";
    private static final String Key_Bizapp = "bizapp";
    private static final String Key_PkId = "pkid";
    private static final String Key_AdvToolBar = "advcontoolbarap";
    private static final String Key_Bar_Refresh = "bar_refresh";
    private static final String Key_Bar_AddLine = "bar_addline";
    private static final String Key_Bar_DelLine = "bar_delline";
    private static final String ActionId_Edit = "edit";
    private static final String ActionId_Add = "add";
    private static final String ActionId_Del = "del";
    private static final String Number_FeatureInput = "bos_features_input";
    protected static final String ReturnKey_Features = "features";
    private static int[] selectedRows = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid grid = (EntryGrid)this.getControl(Key_EntryEntity);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar toolbar = (Toolbar)this.getView().getControl(Key_AdvToolBar);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(Key_AppId);
        this.loadFromFeatureList(appId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectRows();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        if (Key_Number.equals(fieldName)) {
            this.showEditView();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_addline": {
                this.showAddView();
                break;
            }
            case "bar_delline": {
                this.deleteFeature();
                break;
            }
            case "bar_refresh": {
                this.refreshView();
                break;
            }
        }
    }

    private void showEditView() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_EntryEntity);
        String pkId = (String)this.getModel().getValue(Key_PkId, rowIndex);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(Number_FeatureInput);
        parameter.setPkId((Object)pkId);
        parameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u7279\u6027", (String)"FeatureSelectPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.NonModal);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ActionId_Edit);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showAddView() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(Number_FeatureInput);
        parameter.getOpenStyle().setShowType(ShowType.NonModal);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ActionId_Add);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void deleteFeature() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_EntryEntity);
        this.getModel().deleteEntryRow(Key_EntryEntity, rowIndex);
        this.getView().updateView(Key_EntryEntity);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.refreshView();
    }

    private void refreshView() {
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(Key_AppId);
        this.loadFromFeatureList(appId);
    }

    private void loadFromFeatureList(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        HashSet<String> selectFeatureNums = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            List selectFea = SerializationUtils.fromJsonStringToList((String)value, FeatureBlackListInfo.class);
            for (FeatureBlackListInfo select : selectFea) {
                selectFeatureNums.add(select.getFeatureNumber());
            }
        }
        Map<Object, DynamicObject> features = FeatureSelectPlugin.loadFeaturesFromCache(appId);
        this.getModel().deleteEntryData(Key_EntryEntity);
        if (features.isEmpty()) {
            this.getView().updateView();
            return;
        }
        this.getModel().batchCreateNewEntryRow(Key_EntryEntity, features.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_EntryEntity);
        selectedRows = new int[selectFeatureNums.size()];
        int index = 0;
        int j = 0;
        for (DynamicObject feature : features.values()) {
            DynamicObject row = (DynamicObject)entryEntity.get(index);
            String number = feature.getString(Key_Number);
            String name = feature.getString(Key_Name);
            DynamicObject app = feature.getDynamicObject(Key_Bizapp);
            Object pkId = feature.getPkValue();
            row.set(Key_Number, (Object)number);
            row.set(Key_Name, (Object)name);
            row.set(Key_Bizapp, (Object)app);
            row.set(Key_PkId, pkId);
            if (selectFeatureNums.contains(number) && j < selectedRows.length) {
                FeatureSelectPlugin.selectedRows[j++] = index;
            }
            ++index;
        }
        this.selectRows();
        this.getView().updateView(Key_EntryEntity);
    }

    private static Map<Object, DynamicObject> loadFeaturesFromCache(String appId) {
        QFilter[] filters = new QFilter[]{new QFilter(Key_Bizapp, "=", (Object)appId)};
        String selectProps = "number,name,bizapp";
        Map features = BusinessDataServiceHelper.loadFromCache((String)Number_FeatureInput, (String)selectProps, (QFilter[])filters, (String)"createtime desc");
        return features;
    }

    private void returnData() {
        List<FeatureBlackListInfo> data = this.getSelectFeatures();
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put(ReturnKey_Features, SerializationUtils.toJsonString(data));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private List<FeatureBlackListInfo> getSelectFeatures() {
        ArrayList<FeatureBlackListInfo> features = new ArrayList<FeatureBlackListInfo>();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(Key_EntryEntity);
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(Key_AppId);
        if (selectedRows != null && selectedRows.length > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                String featureNumber = (String)this.getModel().getValue(Key_Number, selectedRows[i]);
                String featureName = (String)this.getModel().getValue(Key_Name, selectedRows[i]);
                FeatureBlackListInfo info = new FeatureBlackListInfo(appId, featureNumber, featureName);
                features.add(info);
            }
        }
        return features;
    }

    private void selectRows() {
        if (selectedRows != null && selectedRows.length > 0) {
            EntryGrid grid = (EntryGrid)this.getView().getControl(Key_EntryEntity);
            grid.selectRows(selectedRows, 0);
        }
    }
}

