/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.AbstractSelectPlugin;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;

public class FormFieldSelectPlugin
extends AbstractSelectPlugin
implements TreeNodeCheckListener,
SearchEnterListener {
    @Override
    public void initialize() {
        super.initialize();
        Search search = (Search)this.getView().getControl("search");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        Map fieldTree = null;
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return;
        }
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801%1$s\u5143\u6570\u636e\u52a0\u8f7d\u4e3a\u7a7a\u3002", (String)"FormFieldSelectPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]), formNumber));
            return;
        }
        MainEntity entity = entityMetadata.getRootEntity();
        fieldTree = entity.createFieldsTreeByKey("billFields", true);
        TreeNode root = this.Parse("", fieldTree, "Id", "Name", "Items");
        TreeView tree = (TreeView)this.getView().getControl("FieldTree");
        tree.addNode(root);
        tree.expand(root.getId());
        this.buildTreeNode(value, root, tree);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("FieldTree"), TreeNode.class);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"FormFieldSelectPlugin_2", (String)"bos-productmodel-resource", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getView().getControl("FieldTree");
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    treeView.checkNode((TreeNode)treeNodes.get(indexCache));
                    treeView.treeNodeCheck(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId(), Boolean.TRUE);
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"FormFieldSelectPlugin_3", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private TreeNode Parse(String rootParentId, Map<String, Object> map, String idKey, String textKey, String itemsKey) {
        Object items = map.get(itemsKey);
        String id = (String)map.get(idKey);
        String text = (String)map.get(textKey);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            text = text + "(" + id + ")";
        }
        TreeNode root = new TreeNode(rootParentId, id, text, items != null, map);
        if (items instanceof List) {
            List children = (List)items;
            for (Map item : children) {
                TreeNode node = this.Parse(root.getId(), item, idKey, textKey, itemsKey);
                root.addChild(node);
            }
        }
        return root;
    }
}

