/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;

public class FormOperateSelectPlugin
extends AbstractFormPlugin {
    private int[] selectRows = null;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        String operates = (String)this.getView().getFormShowParameter().getCustomParam("operates");
        List<String> selectedOperats = this.operateString2List(operates);
        this.selectRows = new int[selectedOperats.size()];
        List ops = EntityMetadataCache.getDataEntityOperate((String)formNumber);
        if (ops != null && ops.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow("EntryEntity", ops.size());
            int i = 0;
            int j = 0;
            for (Map op : ops) {
                String name = op.get("name") == null ? "" : (String)((Map)op.get("name")).get(Lang.get().toString());
                model.setValue("ftype", op.get("type"), i);
                model.setValue("fcode", op.get("key"), i);
                model.setValue("fname", (Object)name, i);
                if (selectedOperats.contains(op.get("key"))) {
                    this.selectRows[j] = i;
                    ++j;
                }
                ++i;
            }
            this.getPageCache().put("value", SerializationUtils.toJsonString((Object)ops));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.selectRows(this.selectRows, 0);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnData();
        }
    }

    private List<Map<String, Object>> getSelectedOperation() {
        ArrayList<Map<String, Object>> ops = new ArrayList<Map<String, Object>>(10);
        HashMap<String, String> op = null;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rowIndexs = entryGrid.getEntryState().getSelectedRows();
        if (rowIndexs.length > 0) {
            for (int i = 0; i < rowIndexs.length; ++i) {
                op = new HashMap<String, String>(16);
                op.put("_Type_", "FormOperate");
                op.put("OpCode", this.getModel().getValue("FCode", rowIndexs[i]).toString());
                op.put("OpName", this.getModel().getValue("FName", rowIndexs[i]).toString());
                op.put("OpType", this.getModel().getValue("Ftype", rowIndexs[i]).toString());
                ops.add(op);
            }
        }
        return ops;
    }

    private void returnData() {
        List<Map<String, Object>> data = this.getSelectedOperation();
        HashMap<String, List<Map<String, Object>>> returnData = new HashMap<String, List<Map<String, Object>>>(16);
        returnData.put("Operations", data);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private List<String> operateString2List(String operats) {
        ArrayList<String> list = new ArrayList<String>(10);
        if (StringUtils.isNotBlank((CharSequence)operats)) {
            for (String op : operats.split(",")) {
                list.add(op);
            }
        }
        return list;
    }
}

