/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.treebuild.ControlsTreeBuildOption;
import kd.bos.designer.productmodel.treebuild.FormTreeBuilder;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.filter.FilterContainerAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.report.ReportCommFilterPanelAp;
import kd.bos.metadata.report.ReportFilterAp;
import kd.bos.metadata.report.ReportMoreFilterPanelAp;

public class FormPropSetPlugin
extends AbstractFormPlugin
implements F7SelectedListRemoveListener,
IBizRuleEditor,
TreeNodeCheckListener,
SearchEnterListener {
    static final String F7SELECTEDLISTAP = "f7selectedlistap";
    static final String TREEKEY = "treeviewap";
    static final String KEY_FORMID = "formId";
    private static final String KEY_FIELDTREE = "FieldTree";
    private static final String KEY_VALUE = "value";
    private static final String KEY_CHECKNODES = "checkNodes";
    private static ControlsTreeBuildOption CONTROLOPTION = new ControlsTreeBuildOption();
    protected List<String> checkNodeIds = new ArrayList<String>();
    protected TreeNode root = new TreeNode();
    List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7SELECTEDLISTAP);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        Search search = (Search)this.getView().getControl("search");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        AbstractMetadata metadata;
        super.afterCreateNewData(e);
        ArrayList<Map<String, Object>> formContext = new ArrayList<Map>();
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID);
        if (StringUtils.isBlank((CharSequence)formId)) {
            if (StringUtils.isBlank((CharSequence)formNumber)) {
                return;
            }
            formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        }
        if ((metadata = MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form)) == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801%s\u5143\u6570\u636e\u52a0\u8f7d\u4e3a\u7a7a", (String)"FormPropSetPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]), formNumber));
            return;
        }
        if (!(metadata instanceof FormMetadata)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801%s\u5143\u6570\u636e\u975e\u8868\u5355\u5143\u6570\u636e", (String)"FormPropSetPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]), formNumber));
            return;
        }
        FormMetadata formMetadata = (FormMetadata)metadata;
        Map designMeta = formMetadata.buildDesignMeta(Lang.get().name());
        Object context = ((Map)designMeta.get("formmeta")).get("Items");
        if (context instanceof Map) {
            Map tmp = (Map)context;
            formContext.add(tmp);
        } else if (context instanceof List) {
            formContext = (List)context;
        }
        this.getPageCache().put("context", SerializationUtils.toJsonString(formContext));
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        this.root = FormTreeBuilder.buildControlsTree(formContext, CONTROLOPTION);
        tree.addNode(this.root);
        this.root.setIsOpened(true);
        this.root.setExpend(true);
        this.getPageCache().put(KEY_FIELDTREE, SerializationUtils.toJsonString((Object)this.root));
        this.setCheckNodeList();
        String billKey = formNumber;
        this.getPageCache().put("billKey", billKey);
        ArrayList<Map<String, String>> listValue = new ArrayList<Map<String, String>>();
        for (String key : this.checkNodeIds) {
            TreeNode node = this.root.getTreeNode(key, 16);
            if (node == null || node.getChildren() != null && !node.getChildren().isEmpty() || node.getId().equals(billKey)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_VALUE, node.getId());
            TreeNode parentNode = this.root.getTreeNode(node.getParentid(), 16);
            if (parentNode != null) {
                String parentText = parentNode.getText();
                if ("_headNode_".equalsIgnoreCase(parentNode.getId()) && ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"FormPropSetPlugin_2", (String)"bos-productmodel-resource", (Object[])new Object[0]).equals(parentNode.getText())) {
                    map.put("text", node.getText());
                } else if (parentText.indexOf(40) == -1) {
                    map.put("text", parentText + "\u00b7" + node.getText());
                } else {
                    map.put("text", parentText.substring(0, parentText.indexOf(40)) + "\u00b7" + node.getText());
                }
            } else {
                map.put("text", node.getText());
            }
            listValue.add(map);
        }
        if (listValue != null) {
            this.addItems(listValue);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{F7SELECTEDLISTAP});
    }

    public void afterBindData(EventObject e) {
        List checkNodeIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_CHECKNODES), List.class);
        String selectedStatus = (String)this.getView().getFormShowParameter().getCustomParams().get("selectedStatus");
        if (checkNodeIds.size() <= 0 && !StringUtils.isBlank((CharSequence)selectedStatus)) {
            checkNodeIds.addAll((Collection)SerializationUtils.fromJsonString((String)selectedStatus, List.class));
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_FIELDTREE), TreeNode.class);
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(checkNodeIds.size());
        for (String key : checkNodeIds) {
            checkNodes.add(root.getTreeNode(key, 16));
        }
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        tree.checkNodes(checkNodes);
        this.getPageCache().put(KEY_FIELDTREE, SerializationUtils.toJsonString((Object)root));
        this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString((Object)checkNodeIds));
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_FIELDTREE), TreeNode.class);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"FormPropSetPlugin_3", (String)"bos-productmodel-resource", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(TREEKEY);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    treeView.checkNode((TreeNode)treeNodes.get(indexCache));
                    treeView.treeNodeCheck(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId(), Boolean.TRUE);
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"FormPropSetPlugin_4", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    protected void setCheckNodeList() {
        String value = (String)this.getView().getFormShowParameter().getCustomParams().get(KEY_VALUE);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.listMap = (List)SerializationUtils.fromJsonString((String)value, List.class);
            if (this.listMap != null && this.listMap.size() > 0) {
                for (Map<String, Object> fieldMap : this.listMap) {
                    this.checkNodeIds.add(fieldMap.get("id").toString());
                }
            }
        } else {
            String selectedStatus = (String)this.getView().getFormShowParameter().getCustomParams().get("selectedStatus");
            if (!StringUtils.isBlank((CharSequence)selectedStatus)) {
                this.checkNodeIds.addAll((Collection)SerializationUtils.fromJsonString((String)selectedStatus, List.class));
            }
        }
        this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString(this.checkNodeIds));
    }

    public boolean checkConfig() {
        return true;
    }

    public String getOutConfig() {
        HashMap<String, String> exp = new HashMap<String, String>();
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        List ids = tree.getTreeState().getCheckedNodeIds();
        ArrayList controlList = new ArrayList(ids.size());
        for (String str : ids) {
            HashMap<String, String> cMap = new HashMap<String, String>();
            cMap.put("_Type_", "FieldId");
            cMap.put("Id", str);
            controlList.add(cMap);
        }
        exp.put("Fields", SerializationUtils.toJsonString(controlList));
        return SerializationUtils.toJsonString(exp);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnDataToParentAndClose();
        }
    }

    public void returnDataToParentAndClose() {
        HashMap<String, Object> exp = new HashMap<String, Object>();
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        List controlList = tree.getTreeState().getCheckedNodes();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID);
        exp.put(KEY_FORMID, formId);
        exp.put("Fields", controlList);
        this.getView().returnDataToParent(exp);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        this.selectTreeNode(evt.getChecked());
    }

    private void selectTreeNode(boolean select) {
        TreeView tree;
        block11: {
            List checkNodes;
            List currChecks;
            TreeNode root;
            block10: {
                root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_FIELDTREE), TreeNode.class);
                tree = (TreeView)this.getView().getControl(TREEKEY);
                currChecks = tree.getTreeState().getCheckedNodeIds();
                checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_CHECKNODES), List.class);
                ArrayList selList = new ArrayList();
                selList.addAll(currChecks);
                if (!select) break block10;
                if (!checkNodes.isEmpty() && !selList.removeAll(checkNodes)) break block11;
                ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    String billKey = this.getPageCache().get("billKey");
                    if (node == null || node.getChildren() != null && !node.getChildren().isEmpty() || node.getId().equals(billKey)) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(KEY_VALUE, node.getId());
                    TreeNode parentNode = root.getTreeNode(node.getParentid(), 16);
                    if (parentNode != null) {
                        String parentText = parentNode.getText();
                        if ("_headNode_".equalsIgnoreCase(parentNode.getId()) && ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"FormPropSetPlugin_2", (String)"bos-productmodel-resource", (Object[])new Object[0]).equals(parentNode.getText())) {
                            map.put("text", node.getText());
                        } else if (parentText.indexOf(40) == -1) {
                            map.put("text", parentText + "\u00b7" + node.getText());
                        } else {
                            map.put("text", parentText.substring(0, parentText.indexOf(40)) + "\u00b7" + node.getText());
                        }
                    } else {
                        map.put("text", node.getText());
                    }
                    list.add(map);
                }
                if (list.isEmpty()) break block11;
                this.addItems(list);
                break block11;
            }
            if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
                for (int i = 0; i < checkNodes.size(); ++i) {
                    TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                    if (node == null || node.getChildren() == null) continue;
                    checkNodes.remove(i);
                }
                F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
                for (String value : checkNodes) {
                    f7SelectedList.removeItem((Object)value);
                }
            }
        }
        this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    public void addItems(List<Map<String, String>> list) {
        ArrayList<ValueTextItem> listValue = new ArrayList<ValueTextItem>(list.size());
        for (Map<String, String> map : list) {
            listValue.add(new ValueTextItem(map.get(KEY_VALUE), map.get("text")));
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        f7SelectedList.addItems(listValue);
    }

    public void RemoveClick(F7SelectedListRemoveEvent arg0) {
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        if (arg0.getParam() != null) {
            tree.uncheckNode(arg0.getParam().toString());
        } else {
            tree.uncheckNodes(tree.getTreeState().getCheckedNodeIds());
        }
        this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    static {
        CONTROLOPTION.addInvalidClassTypes(FormAp.class);
        CONTROLOPTION.addInvalidClassTypes(FieldAp.class);
        CONTROLOPTION.addInvalidClassTypes(TabPageAp.class);
        CONTROLOPTION.addInvalidClassTypes(FilterContainerAp.class);
        CONTROLOPTION.addInvalidClassTypes(ReportFilterAp.class);
        CONTROLOPTION.addInvalidClassTypes(ReportCommFilterPanelAp.class);
        CONTROLOPTION.addInvalidClassTypes(ReportMoreFilterPanelAp.class);
    }
}

