/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.AbstractSelectPlugin;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;

public class ListFieldSelectPlugin
extends AbstractSelectPlugin
implements TreeNodeCheckListener {
    private static final String KEY_TYPE = "Type";
    private static final String KEY_TYPE_UNDERLINE = "_Type_";

    @Override
    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        Map<String, Object> fieldTree = null;
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return;
        }
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        Map listMeta = FormMetadataCache.getListMeta((String)formNumber);
        if (listMeta == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801\u3010%s\u3011\u7684\u8868\u5355\u6ca1\u6709\u5217\u8868\u5143\u6570\u636e\uff0c\u65e0\u9700\u914d\u7f6e\u5217\u8868\u5b57\u6bb5", (String)"ListFieldSelectPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]), formNumber));
            return;
        }
        fieldTree = this.createFieldsTree(listMeta, formNumber);
        TreeNode root = TreeNode.Parse((String)"", fieldTree, (String)"Id", (String)"Name", (String)"Items");
        TreeView tree = (TreeView)this.getView().getControl("FieldTree");
        tree.addNode(root);
        this.buildTreeNode(value, root, tree);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    private Map<String, Object> createFieldsTree(Map<String, Object> listMeta, String formNumber) {
        HashMap<String, Object> node = new HashMap<String, Object>(4);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formNumber);
        String billListStr = (String)listMeta.get("BillList");
        Map billList = (Map)SerializationUtils.fromJsonString((String)billListStr, Map.class);
        if (billList == null || billList.isEmpty()) {
            return node;
        }
        node.put("Id", billList.get("EntityId"));
        node.put(KEY_TYPE, billList.get(KEY_TYPE_UNDERLINE));
        node.put("Name", type.getDisplayName().getLocaleValue_zh_CN());
        node.put("CreateType", 1);
        List items = (List)billList.get("Items");
        ArrayList nodeItems = new ArrayList(items.size());
        node.put("Items", nodeItems);
        for (Map item : items) {
            String itemType = (String)item.get(KEY_TYPE_UNDERLINE);
            String name = this.getTypeName(itemType);
            List secItems = (List)item.get("Items");
            ArrayList secNodeItems = new ArrayList(10);
            HashMap<String, Object> secNode = new HashMap<String, Object>(3);
            secNode.put("Id", itemType);
            secNode.put(KEY_TYPE, itemType);
            secNode.put("Name", name);
            secNode.put("Items", secNodeItems);
            nodeItems.add(secNode);
            if (secItems == null || secItems.isEmpty()) continue;
            for (Map fieldItem : secItems) {
                Map caption = (Map)fieldItem.get("Caption");
                String fieldName = caption == null ? "" : (String)caption.get("zh_CN");
                HashMap fieldNode = new HashMap(3);
                fieldNode.put("Id", fieldItem.get("ListFieldKey"));
                fieldNode.put(KEY_TYPE, fieldItem.get(KEY_TYPE_UNDERLINE));
                fieldNode.put("Name", fieldName);
                secNodeItems.add(fieldNode);
            }
        }
        return node;
    }

    private String getTypeName(String type) {
        String name = "";
        switch (type) {
            case "ListGridView": {
                name = ResManager.loadKDString((String)"\u8868\u683c\u89c6\u56fe", (String)"ListFieldSelectPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]);
                break;
            }
            case "ListCardView": {
                name = ResManager.loadKDString((String)"\u5361\u7247\u89c6\u56fe", (String)"ListFieldSelectPlugin_2", (String)"bos-productmodel-resource", (Object[])new Object[0]);
                break;
            }
            default: {
                name = ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u5361\u7247\u89c6\u56fe", (String)"ListFieldSelectPlugin_3", (String)"bos-productmodel-resource", (Object[])new Object[0]);
            }
        }
        return name;
    }

    @Override
    protected String getFormatName(String name, String key) {
        return name;
    }
}

