/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel.kit;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.productmodel.kit.BlackListCacheUtils;
import kd.bos.designer.productmodel.kit.BlackListType;
import kd.bos.designer.productmodel.kit.CloudBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.ProductModeTypeUtil;
import kd.bos.designer.productmodel.kit.ProductModelType;
import kd.bos.designer.productmodel.model.AppBlackListInfo;
import kd.bos.designer.productmodel.model.AppBlackListMap;
import kd.bos.designer.productmodel.model.FeatureBlackListInfo;
import kd.bos.designer.productmodel.model.FunctionBlackListInfo;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.productmodel.ProductBlackList;
import kd.bos.productmodel.ProductFileServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class AppBlackListSaveHelper {
    public static void UpdateToCache(String id, String key, String value) {
        if (id == null) {
            return;
        }
        String o = BlackListCacheUtils.getFromCache(ProductModelType.Standard, BlackListType.App);
        Map apps = new HashMap(10);
        if (o != null) {
            apps = (Map)SerializationUtils.fromJsonString((String)o, Map.class);
            HashMap<String, String> app = (HashMap<String, String>)apps.get(id);
            if (app == null) {
                app = new HashMap<String, String>(10);
                app.put(key, value);
            }
        } else {
            HashMap<String, String> app = new HashMap<String, String>(10);
            app.put(key, value);
            apps.put(id, app);
        }
        BlackListCacheUtils.putToCache(ProductModelType.Standard, BlackListType.App, apps);
    }

    public static void updateToCache(String modelType, AppBlackListInfo info) {
        if (info == null) {
            return;
        }
        Map<String, AppBlackListInfo> apps = AppBlackListSaveHelper.getAppFromCache(modelType);
        apps.put(info.getAppId(), info);
        BlackListCacheUtils.putToCache(ProductModeTypeUtil.getType(modelType), BlackListType.App, apps);
    }

    public static void updateToCacheBatch(String modelType, Map<String, AppBlackListInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        Map<String, AppBlackListInfo> apps = AppBlackListSaveHelper.getAppFromCache(modelType);
        apps.putAll(infos);
        BlackListCacheUtils.putToCache(ProductModeTypeUtil.getType(modelType), BlackListType.App, apps);
    }

    public static void updateToDB(String modelType, AppBlackListInfo info) {
        if (info == null) {
            return;
        }
        info.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
        IDataEntityType dt = OrmUtils.getDataEntityType(AppBlackListInfo.class);
        try (TXHandle h = TX.required();){
            AppBlackListSaveHelper.delete(info, modelType);
            BusinessDataWriter.save((IDataEntityType)dt, (Object[])new Object[]{info});
        }
    }

    private static void delete(AppBlackListInfo info, String modelType) {
        String sql = String.format("delete from %s where fappid = '%s' and fmodeltype = '%s' ", "T_BAS_AppBlackList", info.getAppId(), ProductModeTypeUtil.getType(modelType).getValue());
        DB.execute((DBRoute)DBRoute.meta, (String)sql);
    }

    public static void updateToDBBatch(String modelType, Map<String, AppBlackListInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        for (Map.Entry<String, AppBlackListInfo> entry : infos.entrySet()) {
            AppBlackListSaveHelper.updateToDB(modelType, entry.getValue());
        }
    }

    public static Map<String, AppBlackListInfo> getAppBlackList(String modelType, DynamicObjectCollection apps) {
        ProductBlackList blackList;
        Map<String, AppBlackListInfo> appInfos = AppBlackListSaveHelper.getAppFromDB(modelType);
        if (appInfos != null && !appInfos.isEmpty()) {
            return appInfos;
        }
        if (CloudBlackListSaveHelper.isLoadBlackList() && (blackList = ProductFileServiceHelper.loadBlackListSetting()) != null && !blackList.getAppBlackList().isEmpty()) {
            List<String> appBlackList = blackList.getAppBlackList();
            appInfos = new HashMap<String, AppBlackListInfo>(appBlackList.size());
            Map<String, DynamicObject> appsMap = AppBlackListSaveHelper.groupApp(apps);
            for (String appId : appBlackList) {
                String appName = "";
                String cloudId = "";
                String appNum = "";
                DynamicObject appsMapValue = appsMap.get(appId);
                if (appsMapValue != null) {
                    DynamicObject obj = appsMap.get(appId);
                    appName = obj.getString("name");
                    cloudId = obj.getString("bizcloud");
                    appNum = obj.getString("number");
                }
                List<String> appFunctionList = blackList.getAppFuncPackBlackList(appId);
                Map<String, AppMenuElement> menues = AppBlackListSaveHelper.groupMenu(appId);
                List<FunctionBlackListInfo> funcInfos = AppBlackListSaveHelper.FuncPackToBlackList(appId, appName, menues, appFunctionList);
                String functionInner = funcInfos.isEmpty() ? "" : SerializationUtils.toJsonString(funcInfos);
                List<String> featureNumList = blackList.getFeatureBlackList(appId);
                List<FeatureBlackListInfo> featureInfos = AppBlackListSaveHelper.featurePackToInfo(appId, featureNumList);
                String featureInner = featureInfos.isEmpty() ? "" : SerializationUtils.toJsonString(featureInfos);
                long id = DB.genGlobalLongId();
                AppBlackListInfo info = new AppBlackListInfo(id, cloudId, appId, appName, appNum, true, functionInner, featureInner);
                info.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
                appInfos.put(appId, info);
            }
            AppBlackListSaveHelper.updateToDBBatch(modelType, appInfos);
            return appInfos;
        }
        return new HashMap<String, AppBlackListInfo>(1);
    }

    protected static Map<String, AppBlackListInfo> getAppFromCache(String modelType) {
        String o = BlackListCacheUtils.getFromCache(ProductModeTypeUtil.getType(modelType), BlackListType.App);
        Map<String, AppBlackListInfo> apps = new HashMap<String, AppBlackListInfo>(10);
        if (o != null) {
            apps = (Map)SerializationUtils.fromJsonString((String)o, AppBlackListMap.class);
        }
        return apps;
    }

    protected static Map<String, AppBlackListInfo> getAppFromDB(String modelType) {
        String sql = String.format("select FID, FCLOUDID, FAPPID, FAPPNUM, FAPPNAME, FFUNCTIONS, FDISABLE, FMODELTYPE, FFEATURES from %s where FMODELTYPE = '%s'", "T_BAS_AppBlackList", ProductModeTypeUtil.getType(modelType).getValue());
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, AppBlackListInfo> map = new HashMap<String, AppBlackListInfo>(16);
            try {
                while (rs.next()) {
                    long id = rs.getLong("FID");
                    String cloudId = rs.getString("FCLOUDID");
                    String appId = rs.getString("FAPPID");
                    String appNum = rs.getString("FAPPNUM");
                    String appName = rs.getString("FAPPNAME");
                    boolean disable = rs.getBoolean("FDISABLE");
                    String functions = rs.getString("FFUNCTIONS");
                    String features = rs.getString("FFEATURES");
                    int type = rs.getInt("FMODELTYPE");
                    AppBlackListInfo info = new AppBlackListInfo(id, cloudId, appId, appName, appNum, disable, functions, features);
                    info.setModelType(type);
                    map.put(appId, info);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return map;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)callBackHanlder);
    }

    protected static Set<String> getAppIdsByCloud(String cloudId) {
        String sql = String.format("select fid,fnumber,fbizcloudid from %s where fbizcloudid = '%s'", "t_meta_bizapp", cloudId);
        ResultSetHandler callBackHanlder = rs -> {
            HashSet<String> appIds = new HashSet<String>(16);
            try {
                while (rs.next()) {
                    String appId = rs.getString("fid");
                    appIds.add(appId);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return appIds;
        };
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)callBackHanlder);
    }

    protected static Set<String> getAppIdsByClouds(String cloudIdStr) {
        String sql = String.format("select fid,fnumber,fbizcloudid from %s where fbizcloudid in (%s)", "t_meta_bizapp", cloudIdStr);
        ResultSetHandler callBackHanlder = rs -> {
            HashSet<String> appIds = new HashSet<String>(16);
            try {
                while (rs.next()) {
                    String appId = rs.getString("fid");
                    appIds.add(appId);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return appIds;
        };
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)callBackHanlder);
    }

    public static void clearCache(String modelType) {
        BlackListCacheUtils.removeCache(ProductModeTypeUtil.getType(modelType), BlackListType.App);
    }

    public static void deleteAll(String modelType) {
        String sql = String.format("delete from %s where fmodeltype = '%s' ", "T_BAS_AppBlackList", ProductModeTypeUtil.getType(modelType).getValue());
        DB.execute((DBRoute)DBRoute.meta, (String)sql);
    }

    @Deprecated
    public static ProductModelType getType(String modelType) {
        ProductModelType type = ProductModelType.Standard;
        if (StringUtils.isBlank((CharSequence)modelType)) {
            return type;
        }
        switch (modelType) {
            case "2": {
                type = ProductModelType.Enterprise;
                break;
            }
            case "3": {
                type = ProductModelType.Exclusive;
                break;
            }
        }
        return type;
    }

    private static Map<String, DynamicObject> groupApp(DynamicObjectCollection apps) {
        if (apps == null || apps.isEmpty()) {
            return new HashMap<String, DynamicObject>(1);
        }
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(apps.size());
        for (DynamicObject obj : apps) {
            String id = obj.getString("id");
            map.put(id, obj);
        }
        return map;
    }

    private static Map<String, AppMenuElement> groupMenu(String appId) {
        HashMap<String, AppMenuElement> map = new HashMap<String, AppMenuElement>(16);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        if (appMeta == null) {
            return map;
        }
        List menues = appMeta.getAppMenus();
        if (menues == null || menues.isEmpty()) {
            return map;
        }
        for (AppMenuElement menu : menues) {
            String menuId = menu.getId();
            map.put(menuId, menu);
        }
        return map;
    }

    private static List<FunctionBlackListInfo> FuncPackToBlackList(String appId, String appName, Map<String, AppMenuElement> menues, List<String> appFunctionList) {
        if (appFunctionList == null || appFunctionList.isEmpty()) {
            return new ArrayList<FunctionBlackListInfo>(1);
        }
        ArrayList<FunctionBlackListInfo> infos = new ArrayList<FunctionBlackListInfo>(appFunctionList.size());
        for (String funcId : appFunctionList) {
            AppMenuElement menu = menues.get(funcId);
            if (menu == null) {
                infos.add(new FunctionBlackListInfo(appId, appName, funcId, funcId, funcId, "", "", ""));
                continue;
            }
            String id = menu.getId();
            String name = menu.getName() == null ? "" : menu.getName().getLocaleValue();
            String number = menu.getNumber();
            String formName = menu.getFormName() == null ? "" : menu.getFormName();
            String formNumber = menu.getFormNumber();
            String formId = menu.getFormId();
            infos.add(new FunctionBlackListInfo(appId, appName, id, name, number, formId, formName, formNumber));
        }
        return infos;
    }

    private static List<FeatureBlackListInfo> featurePackToInfo(String appId, List<String> featureNumList) {
        if (StringUtils.isBlank((CharSequence)appId) || featureNumList == null || featureNumList.isEmpty()) {
            return new ArrayList<FeatureBlackListInfo>();
        }
        String sql = String.format("select fnumber,fname from %s where fbizapp = '%s'", "t_meta_featuresblacklist", appId);
        ResultSetHandler callBackHandler = rs -> {
            ArrayList<FeatureBlackListInfo> infos = new ArrayList<FeatureBlackListInfo>();
            try {
                while (rs.next()) {
                    String fnumber = rs.getString("fnumber");
                    String fname = rs.getString("fname");
                    if (!featureNumList.contains(fnumber)) continue;
                    FeatureBlackListInfo info = new FeatureBlackListInfo(appId, fnumber, fname);
                    infos.add(info);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return infos;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)callBackHandler);
    }
}

