/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel.kit;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.productmodel.kit.BlackListType;
import kd.bos.designer.productmodel.kit.ProductModelType;
import kd.bos.entity.cache.CacheKeyUtil;

public class BlackListCacheUtils {
    private static final String PRODUCT_MODEL_BLACK_LIST = "PRODUCT_MODEL_BLACK_LIST";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("PRODUCT_MODEL_BLACK_LIST", new DistributeCacheHAPolicy());

    protected static void putToCache(ProductModelType productModelType, BlackListType blackListType, Object info) {
        String rootCacheKey = BlackListCacheUtils.getRootCacheKey(productModelType.getNumber());
        String key = BlackListCacheUtils.genBlackListCacheKey(blackListType.getNumber());
        BlackListCacheUtils.putToCache(rootCacheKey, key, SerializationUtils.toJsonString((Object)info));
    }

    private static void putToCache(String type, String key, String data) {
        cache.put(type, key, (Object)data);
    }

    protected static String getFromCache(ProductModelType productModelType, BlackListType blackListType) {
        String type = BlackListCacheUtils.getRootCacheKey(productModelType.getNumber());
        String key = BlackListCacheUtils.genBlackListCacheKey(blackListType.getNumber());
        return (String)ThreadCache.get((Object)(type + "." + key), () -> (String)cache.get(type, key));
    }

    private static String getRootCacheKey(String productModel) {
        return String.format("%s_%s_%s", CacheKeyUtil.getAcctId(), PRODUCT_MODEL_BLACK_LIST, productModel);
    }

    private static String genBlackListCacheKey(String key) {
        return (key + ".cache_key").toLowerCase();
    }

    protected static void removeCache(ProductModelType productModelType) {
        String type = BlackListCacheUtils.getRootCacheKey(productModelType.getNumber());
        cache.remove(type);
    }

    protected static void removeCache(ProductModelType productModelType, BlackListType blackListType) {
        String type = BlackListCacheUtils.getRootCacheKey(productModelType.getNumber());
        String key = BlackListCacheUtils.genBlackListCacheKey(blackListType.getNumber());
        cache.remove(type, key);
    }
}

