/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel.kit;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.productmodel.kit.AppBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.BlackListCacheUtils;
import kd.bos.designer.productmodel.kit.BlackListType;
import kd.bos.designer.productmodel.kit.FormBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.ProductModeTypeUtil;
import kd.bos.designer.productmodel.kit.ProductModelType;
import kd.bos.designer.productmodel.model.AppBlackListInfo;
import kd.bos.designer.productmodel.model.CloudBlackListInfo;
import kd.bos.designer.productmodel.model.CloudBlackListMap;
import kd.bos.designer.productmodel.model.FeatureBlackListInfo;
import kd.bos.designer.productmodel.model.FormBlackListInfo;
import kd.bos.designer.productmodel.model.FunctionBlackListInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.param.ParameterReader;
import kd.bos.productmodel.ProductBlackList;
import kd.bos.productmodel.ProductFileServiceHelper;

public class CloudBlackListSaveHelper {
    private static String LOAD_BLACK_LIST = "loadblacklist";

    public static void UpdateToCache(String id, String key, String value) {
        if (id == null) {
            return;
        }
        String o = BlackListCacheUtils.getFromCache(ProductModelType.Standard, BlackListType.Cloud);
        Map clouds = new HashMap(10);
        if (o != null) {
            clouds = (Map)SerializationUtils.fromJsonString((String)o, Map.class);
            HashMap<String, String> cloud = (HashMap<String, String>)clouds.get(id);
            if (cloud == null) {
                cloud = new HashMap<String, String>(10);
                cloud.put(key, value);
            }
        } else {
            HashMap<String, String> cloud = new HashMap<String, String>(10);
            cloud.put(key, value);
            clouds.put(id, cloud);
        }
        BlackListCacheUtils.putToCache(ProductModelType.Standard, BlackListType.Cloud, clouds);
    }

    @Deprecated
    public static void pdateToCache(String modelType, CloudBlackListInfo info) {
        if (info == null) {
            return;
        }
        Map<String, CloudBlackListInfo> clouds = CloudBlackListSaveHelper.getCloudFromCache(modelType);
        clouds.put(info.getCloudId(), info);
        BlackListCacheUtils.putToCache(ProductModeTypeUtil.getType(modelType), BlackListType.Cloud, clouds);
    }

    @Deprecated
    public static void pdateToCacheBatch(String modelType, Map<String, CloudBlackListInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        Map<String, CloudBlackListInfo> clouds = CloudBlackListSaveHelper.getCloudFromCache(modelType);
        clouds.putAll(infos);
        BlackListCacheUtils.putToCache(ProductModeTypeUtil.getType(modelType), BlackListType.Cloud, clouds);
    }

    public static void updateToDB(String modelType, CloudBlackListInfo info) {
        if (info == null) {
            return;
        }
        info.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
        IDataEntityType dt = OrmUtils.getDataEntityType(CloudBlackListInfo.class);
        try (TXHandle h = TX.required();){
            CloudBlackListSaveHelper.delete(info, modelType);
            BusinessDataWriter.save((IDataEntityType)dt, (Object[])new Object[]{info});
        }
    }

    private static void delete(CloudBlackListInfo info, String modelType) {
        String sql = String.format("delete from %s where fcloudid = '%s' and fmodeltype = '%s' ", "T_BAS_CloudBlackList", info.getCloudId(), ProductModeTypeUtil.getType(modelType).getValue());
        DB.execute((DBRoute)DBRoute.meta, (String)sql);
    }

    public static void updateToDBBatch(String modelType, Map<String, CloudBlackListInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        for (Map.Entry<String, CloudBlackListInfo> entry : infos.entrySet()) {
            CloudBlackListSaveHelper.updateToDB(modelType, entry.getValue());
        }
    }

    public static Map<String, CloudBlackListInfo> getCloudBlackList(String modelType, DynamicObjectCollection clouds) {
        ProductBlackList blackList;
        Map<String, CloudBlackListInfo> cloudInfos = CloudBlackListSaveHelper.getCloudFromDB(modelType);
        if (cloudInfos != null && !cloudInfos.isEmpty()) {
            return cloudInfos;
        }
        if (CloudBlackListSaveHelper.isLoadBlackList() && (blackList = ProductFileServiceHelper.loadBlackListSetting()) != null && !blackList.getCloudBlackList().isEmpty()) {
            List<String> clouldBlackList = blackList.getCloudBlackList();
            cloudInfos = new HashMap<String, CloudBlackListInfo>(clouldBlackList.size());
            Map<String, DynamicObject> cloudsMap = CloudBlackListSaveHelper.groupClouds(clouds);
            for (String cloudId : clouldBlackList) {
                String cloudName = "";
                String cloudNum = "";
                DynamicObject cloudValue = cloudsMap.get(cloudId);
                if (cloudValue != null) {
                    DynamicObject obj = cloudsMap.get(cloudId);
                    cloudName = obj.getString("name");
                    cloudNum = obj.getString("number");
                }
                long id = DB.genGlobalLongId();
                CloudBlackListInfo info = new CloudBlackListInfo(id, cloudId, cloudName, cloudNum, true);
                cloudInfos.put(cloudId, info);
            }
            return cloudInfos;
        }
        return new HashMap<String, CloudBlackListInfo>(1);
    }

    private static Map<String, CloudBlackListInfo> getCloudFromCache(String modelType) {
        String o = BlackListCacheUtils.getFromCache(ProductModeTypeUtil.getType(modelType), BlackListType.Cloud);
        Map<String, CloudBlackListInfo> clouds = new HashMap<String, CloudBlackListInfo>(10);
        if (o != null) {
            clouds = (Map)SerializationUtils.fromJsonString((String)o, CloudBlackListMap.class);
        }
        return clouds;
    }

    private static Map<String, CloudBlackListInfo> getCloudFromDB(String modelType) {
        String sql = String.format("select FID, FCLOUDID, FCLOUDNUM, FCLOUDNAME, FDISABLE, FMODELTYPE from %s where FMODELTYPE = '%s'", "T_BAS_CloudBlackList", ProductModeTypeUtil.getType(modelType).getValue());
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, CloudBlackListInfo> map = new HashMap<String, CloudBlackListInfo>(16);
            try {
                while (rs.next()) {
                    long id = rs.getLong("FID");
                    String cloudId = rs.getString("FCLOUDID");
                    String cloudNum = rs.getString("FCLOUDNUM");
                    String cloudName = rs.getString("FCLOUDNAME");
                    boolean disable = rs.getBoolean("FDISABLE");
                    int type = rs.getInt("FMODELTYPE");
                    CloudBlackListInfo info = new CloudBlackListInfo(id, cloudId, cloudName, cloudNum, disable);
                    info.setModelType(type);
                    map.put(cloudId, info);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return map;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)callBackHanlder);
    }

    public static void clearCache(String modelType) {
        BlackListCacheUtils.removeCache(ProductModeTypeUtil.getType(modelType), BlackListType.Cloud);
    }

    public static void deleteAll(String modelType) {
        String sql = String.format("delete from %s where fmodeltype = '%s' ", "T_BAS_CloudBlackList", ProductModeTypeUtil.getType(modelType).getValue());
        DB.execute((DBRoute)DBRoute.meta, (String)sql);
    }

    public static String exportResourceFile(String modelType) {
        return ProductFileServiceHelper.saveBlackListAsTempFile(CloudBlackListSaveHelper.createPblByModeType(modelType), ProductModeTypeUtil.getType(modelType).getValue());
    }

    public static String exportClearResourceFile(String modelType) {
        return ProductFileServiceHelper.saveBlackListAsClearTempFile(CloudBlackListSaveHelper.createPblByModeType(modelType), ProductModeTypeUtil.getType(modelType).getValue());
    }

    private static ProductBlackList createPblByModeType(String modelType) {
        Object info;
        Map<String, CloudBlackListInfo> cloudInfos = CloudBlackListSaveHelper.getCloudFromDB(modelType);
        Map<String, AppBlackListInfo> appInfos = AppBlackListSaveHelper.getAppFromDB(modelType);
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType);
        ProductBlackList pbl = ProductFileServiceHelper.creatProductBlackList();
        if (cloudInfos != null && !cloudInfos.isEmpty()) {
            ArrayList<String> cloudIds = new ArrayList<String>(10);
            for (Map.Entry<String, CloudBlackListInfo> entry : cloudInfos.entrySet()) {
                info = entry.getValue();
                if (!((CloudBlackListInfo)info).isDisable()) continue;
                cloudIds.add(((CloudBlackListInfo)info).getCloudId());
            }
            pbl.setCloudBlackList(cloudIds);
        } else {
            pbl.setCloudBlackList(new ArrayList<String>(1));
        }
        if (appInfos != null && !appInfos.isEmpty()) {
            ArrayList<String> appIds = new ArrayList<String>(10);
            for (Map.Entry<String, Object> entry : appInfos.entrySet()) {
                info = (AppBlackListInfo)entry.getValue();
                if (((AppBlackListInfo)info).isDisable()) {
                    appIds.add(((AppBlackListInfo)info).getAppId());
                }
                if (StringUtils.isNotBlank((CharSequence)((AppBlackListInfo)info).getFunctionInner())) {
                    List functions = SerializationUtils.fromJsonStringToList((String)((AppBlackListInfo)info).getFunctionInner(), FunctionBlackListInfo.class);
                    ArrayList<String> funcIds = new ArrayList<String>(functions.size());
                    for (FunctionBlackListInfo funcInfo : functions) {
                        funcIds.add(funcInfo.getMenuId());
                    }
                    pbl.setAppMenuBlackList(((AppBlackListInfo)info).getAppId(), funcIds);
                }
                if (!StringUtils.isNotBlank((CharSequence)((AppBlackListInfo)info).getFeatureInner())) continue;
                List features = SerializationUtils.fromJsonStringToList((String)((AppBlackListInfo)info).getFeatureInner(), FeatureBlackListInfo.class);
                ArrayList<String> featureNums = new ArrayList<String>(features.size());
                for (FeatureBlackListInfo featureInfo : features) {
                    featureNums.add(featureInfo.getFeatureNumber());
                }
                pbl.setFeatureBlackList(((AppBlackListInfo)info).getAppId(), featureNums);
            }
            pbl.setAppBlackList(appIds);
        } else {
            pbl.setAppBlackList(new ArrayList<String>(1));
        }
        if (formInfos != null && !formInfos.isEmpty()) {
            ArrayList<String> formIds = new ArrayList<String>(10);
            for (Map.Entry<String, Object> entry : formInfos.entrySet()) {
                info = (FormBlackListInfo)entry.getValue();
                if (!((FormBlackListInfo)info).isDisable()) continue;
                formIds.add(((FormBlackListInfo)info).getFormId());
            }
            pbl.setFormBlackList(formIds);
        } else {
            pbl.setFormBlackList(new ArrayList<String>(1));
        }
        return pbl;
    }

    public static String exportResourceFile(String modelType, CloudBlackListInfo blackList) {
        Object info;
        Map<String, CloudBlackListInfo> cloudInfos = CloudBlackListSaveHelper.getCloudFromDB(modelType);
        Map<String, AppBlackListInfo> appInfos = AppBlackListSaveHelper.getAppFromDB(modelType);
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType);
        ProductBlackList pbl = ProductFileServiceHelper.creatProductBlackList();
        if (cloudInfos != null && !cloudInfos.isEmpty()) {
            ArrayList<String> cloudIds = new ArrayList<String>(10);
            for (Map.Entry<String, CloudBlackListInfo> entry : cloudInfos.entrySet()) {
                info = entry.getValue();
                if (!((CloudBlackListInfo)info).isDisable() || !((CloudBlackListInfo)info).getCloudId().equals(blackList.getCloudId())) continue;
                cloudIds.add(((CloudBlackListInfo)info).getCloudId());
            }
            pbl.setCloudBlackList(cloudIds);
        } else {
            pbl.setCloudBlackList(new ArrayList<String>(1));
        }
        ArrayList<String> appIds = new ArrayList<String>(10);
        if (appInfos != null && !appInfos.isEmpty()) {
            for (Map.Entry<String, Object> entry : appInfos.entrySet()) {
                info = (AppBlackListInfo)entry.getValue();
                if (!((AppBlackListInfo)info).getCloudId().equals(blackList.getCloudId())) continue;
                if (((AppBlackListInfo)info).isDisable()) {
                    appIds.add(((AppBlackListInfo)info).getAppId());
                }
                if (StringUtils.isNotBlank((CharSequence)((AppBlackListInfo)info).getFunctionInner())) {
                    List functions = SerializationUtils.fromJsonStringToList((String)((AppBlackListInfo)info).getFunctionInner(), FunctionBlackListInfo.class);
                    ArrayList<String> funcIds = new ArrayList<String>(functions.size());
                    for (FunctionBlackListInfo funcInfo : functions) {
                        funcIds.add(funcInfo.getMenuId());
                    }
                    pbl.setAppMenuBlackList(((AppBlackListInfo)info).getAppId(), funcIds);
                }
                if (!StringUtils.isNotBlank((CharSequence)((AppBlackListInfo)info).getFeatureInner())) continue;
                List features = SerializationUtils.fromJsonStringToList((String)((AppBlackListInfo)info).getFeatureInner(), FeatureBlackListInfo.class);
                ArrayList<String> feaNums = new ArrayList<String>(features.size());
                for (FeatureBlackListInfo fea : features) {
                    feaNums.add(fea.getFeatureNumber());
                }
                pbl.setFeatureBlackList(((AppBlackListInfo)info).getAppId(), feaNums);
            }
            pbl.setAppBlackList(appIds);
        } else {
            pbl.setAppBlackList(new ArrayList<String>(1));
        }
        Set<String> appIdsByCloud = AppBlackListSaveHelper.getAppIdsByCloud(blackList.getCloudId());
        if (formInfos != null && !formInfos.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(10);
            for (Map.Entry<String, FormBlackListInfo> entry : formInfos.entrySet()) {
                FormBlackListInfo info2 = entry.getValue();
                if (!info2.isDisable() || !appIdsByCloud.contains(info2.getAppId())) continue;
                arrayList.add(info2.getFormId());
            }
            pbl.setFormBlackList(arrayList);
        } else {
            pbl.setFormBlackList(new ArrayList<String>(1));
        }
        return ProductFileServiceHelper.saveBlackListAsTempFile(pbl, ProductModeTypeUtil.getType(modelType).getValue(), blackList);
    }

    public static void resetBlackList(String modelType) {
        ProductFileServiceHelper.clearBlackListCache();
        ProductFileServiceHelper.clearFormCache(new ArrayList<String>());
    }

    private static Map<String, DynamicObject> groupClouds(DynamicObjectCollection clouds) {
        if (clouds == null || clouds.isEmpty()) {
            return new HashMap<String, DynamicObject>(1);
        }
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(clouds.size());
        for (DynamicObject obj : clouds) {
            String cloudId = obj.getString("id");
            map.put(cloudId, obj);
        }
        return map;
    }

    protected static boolean isLoadBlackList() {
        Map paramData = ParameterReader.loadPublicParameterFromCache();
        if (!paramData.containsKey(LOAD_BLACK_LIST)) {
            return false;
        }
        Object value = paramData.get(LOAD_BLACK_LIST);
        return StringUtils.isBlank(value) ? false : (Boolean)value;
    }
}

