/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel.kit;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.productmodel.kit.AppBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.BlackListCacheUtils;
import kd.bos.designer.productmodel.kit.BlackListType;
import kd.bos.designer.productmodel.kit.CloudBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.FormControlBuilder;
import kd.bos.designer.productmodel.kit.ProductModeTypeUtil;
import kd.bos.designer.productmodel.kit.ProductModelType;
import kd.bos.designer.productmodel.model.AppBlackListInfo;
import kd.bos.designer.productmodel.model.CloudBlackListInfo;
import kd.bos.designer.productmodel.model.ControlBlackListInfo;
import kd.bos.designer.productmodel.model.FieldBlackListInfo;
import kd.bos.designer.productmodel.model.FormBlackListInfo;
import kd.bos.designer.productmodel.model.FormBlackListMap;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.productmodel.FileHandler.ProductMetaInstructionUtil;
import kd.bos.productmodel.ProductBlackList;
import kd.bos.productmodel.ProductFileServiceHelper;
import kd.bos.productmodel.ProductFormSetting;

public class FormBlackListSaveHelper {
    public static void UpdateToCache(String id, String key, String value) {
        if (id == null) {
            return;
        }
        String o = BlackListCacheUtils.getFromCache(ProductModelType.Standard, BlackListType.Form);
        Map forms = new HashMap(10);
        if (o != null) {
            forms = (Map)SerializationUtils.fromJsonString((String)o, Map.class);
            HashMap<String, String> form = (HashMap<String, String>)forms.get(id);
            if (form == null) {
                form = new HashMap<String, String>(10);
                form.put(key, value);
            }
        } else {
            HashMap<String, String> form = new HashMap<String, String>(10);
            form.put(key, value);
            forms.put(id, form);
        }
        BlackListCacheUtils.putToCache(ProductModelType.Standard, BlackListType.Form, forms);
    }

    @Deprecated
    public static void updateToCache(String modelType, FormBlackListInfo info) {
        if (info == null) {
            return;
        }
        Map<String, FormBlackListInfo> forms = FormBlackListSaveHelper.getFormFromCache(modelType);
        forms.put(info.getFormId(), info);
        BlackListCacheUtils.putToCache(ProductModeTypeUtil.getType(modelType), BlackListType.Form, forms);
    }

    @Deprecated
    public static void updateToCacheBatch(String modelType, Map<String, FormBlackListInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        Map<String, FormBlackListInfo> forms = FormBlackListSaveHelper.getFormFromCache(modelType);
        forms.putAll(infos);
        BlackListCacheUtils.putToCache(ProductModeTypeUtil.getType(modelType), BlackListType.Form, forms);
    }

    public static void updateToDB(String modelType, FormBlackListInfo info) {
        if (info == null) {
            return;
        }
        info.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
        IDataEntityType dt = OrmUtils.getDataEntityType(FormBlackListInfo.class);
        try (TXHandle h = TX.required();){
            FormBlackListSaveHelper.delete(info, modelType);
            BusinessDataWriter.save((IDataEntityType)dt, (Object[])new Object[]{info});
        }
    }

    private static void delete(FormBlackListInfo info, String modelType) {
        String sql = String.format("delete from %s where fformid = '%s' and fmodeltype = '%s' ", "T_BAS_FormBlackList", info.getFormId(), ProductModeTypeUtil.getType(modelType).getValue());
        DB.execute((DBRoute)DBRoute.meta, (String)sql);
    }

    public static void updateToDBBatch(String modelType, Map<String, FormBlackListInfo> infos) {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        for (Map.Entry<String, FormBlackListInfo> entry : infos.entrySet()) {
            FormBlackListSaveHelper.updateToDB(modelType, entry.getValue());
        }
    }

    public static Map<String, FormBlackListInfo> getFormBlackList(String modelType, String appId, Map<Object, DynamicObject> forms) {
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType);
        if (formInfos != null && !formInfos.isEmpty()) {
            return formInfos;
        }
        if (CloudBlackListSaveHelper.isLoadBlackList()) {
            ProductBlackList blackList = ProductFileServiceHelper.loadBlackListSetting();
            List<String> formBlackListIds = blackList.getFormBlackList();
            formInfos = new HashMap<String, FormBlackListInfo>(16);
            if (formBlackListIds == null) {
                formBlackListIds = new ArrayList<String>(1);
            }
            if (forms == null || forms.isEmpty()) {
                return formInfos;
            }
            for (Map.Entry<Object, DynamicObject> entry : forms.entrySet()) {
                String formId = (String)entry.getKey();
                DynamicObject form = entry.getValue();
                String formNumber = form.getString("number");
                FormBlackListInfo formInfo = FormBlackListSaveHelper.getFormControlFromSetting(form, formNumber);
                if (formBlackListIds.contains(formId)) {
                    formInfo.setDisable(true);
                }
                long id = DB.genGlobalLongId();
                formInfo.setId(id);
                formInfo.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
                formInfos.put(formId, formInfo);
            }
        }
        return formInfos;
    }

    public static List<String> getFormBlackList1(String modelType) {
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType);
        if (formInfos != null && !formInfos.isEmpty()) {
            ArrayList<String> formBlackList = new ArrayList<String>(10);
            for (Map.Entry<String, FormBlackListInfo> entry : formInfos.entrySet()) {
                FormBlackListInfo info = entry.getValue();
                if (!info.isDisable()) continue;
                formBlackList.add(entry.getKey());
            }
            return formBlackList;
        }
        ProductBlackList blackList = ProductFileServiceHelper.loadBlackListSetting();
        return blackList.getFormBlackList();
    }

    public static Map<String, FormBlackListInfo> getFormControlBlackList(String modelType) {
        return FormBlackListSaveHelper.getFormFromDB(modelType);
    }

    private static FormBlackListInfo getFormControlFromSetting(DynamicObject form, String formNum) {
        ProductFormSetting formSetting = ProductFileServiceHelper.loadFormSetting(formNum);
        return FormBlackListSaveHelper.convertToFormBlackListInfo(form, formSetting);
    }

    protected static Map<String, FormBlackListInfo> getFormFromCache(String modelType) {
        String o = BlackListCacheUtils.getFromCache(ProductModeTypeUtil.getType(modelType), BlackListType.Form);
        Map<String, FormBlackListInfo> forms = new HashMap<String, FormBlackListInfo>(10);
        if (o != null) {
            forms = (Map)SerializationUtils.fromJsonString((String)o, FormBlackListMap.class);
        }
        return forms;
    }

    protected static Map<String, FormBlackListInfo> getFormFromDB(String modelType, AppBlackListInfo blackList) {
        String sql = String.format("select FID, FAPPID, FFORMID, FFORMNUM, FFORMNAME, FDISABLE, FFIELDS, FCONTROLS, FLISTFIELDS, FLISTCTLS, FMODELTYPE from %s where FMODELTYPE = '%s' and FAPPID = '%s'", "T_BAS_FormBlackList", ProductModeTypeUtil.getType(modelType).getValue(), blackList.getAppId());
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, FormBlackListInfo> map = new HashMap<String, FormBlackListInfo>(16);
            try {
                while (rs.next()) {
                    long id = rs.getLong("FID");
                    String appId = rs.getString("FAPPID");
                    String formId = rs.getString("FFORMID");
                    String formNum = rs.getString("FFORMNUM");
                    String formName = rs.getString("FFORMNAME");
                    String fields = rs.getString("FFIELDS");
                    String controls = rs.getString("FCONTROLS");
                    String listFields = rs.getString("FLISTFIELDS");
                    String listCtls = rs.getString("FLISTCTLS");
                    boolean disable = rs.getBoolean("FDISABLE");
                    int type = rs.getInt("FMODELTYPE");
                    FormBlackListInfo info = new FormBlackListInfo(id, appId, formId, formName, formNum, fields, controls);
                    info.setListFieldInner(listFields);
                    info.setListCtlInner(listCtls);
                    info.setDisable(disable);
                    info.setModelType(type);
                    map.put(formId, info);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return map;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)callBackHanlder);
    }

    public static Map<String, FormBlackListInfo> getFormFromDB(String modelType) {
        String sql = String.format("select FID, FAPPID, FFORMID, FFORMNUM, FFORMNAME, FDISABLE, FFIELDS, FCONTROLS, FLISTFIELDS, FLISTCTLS, FMODELTYPE from %s where FMODELTYPE = '%s'", "T_BAS_FormBlackList", ProductModeTypeUtil.getType(modelType).getValue());
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, FormBlackListInfo> map = new HashMap<String, FormBlackListInfo>(16);
            try {
                while (rs.next()) {
                    long id = rs.getLong("FID");
                    String appId = rs.getString("FAPPID");
                    String formId = rs.getString("FFORMID");
                    String formNum = rs.getString("FFORMNUM");
                    String formName = rs.getString("FFORMNAME");
                    String fields = rs.getString("FFIELDS");
                    String controls = rs.getString("FCONTROLS");
                    String listFields = rs.getString("FLISTFIELDS");
                    String listCtls = rs.getString("FLISTCTLS");
                    boolean disable = rs.getBoolean("FDISABLE");
                    int type = rs.getInt("FMODELTYPE");
                    FormBlackListInfo info = new FormBlackListInfo(id, appId, formId, formName, formNum, fields, controls);
                    info.setListFieldInner(listFields);
                    info.setListCtlInner(listCtls);
                    info.setDisable(disable);
                    info.setModelType(type);
                    map.put(formId, info);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return map;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)callBackHanlder);
    }

    public static void clearCache(String modelType) {
        BlackListCacheUtils.removeCache(ProductModeTypeUtil.getType(modelType), BlackListType.Form);
    }

    public static void deleteAll(String modelType) {
        String sql = String.format("delete from %s where fmodeltype = '%s' ", "T_BAS_FormBlackList", ProductModeTypeUtil.getType(modelType).getValue());
        DB.execute((DBRoute)DBRoute.meta, (String)sql);
    }

    public static String exportResourceFile(String modelType) {
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType);
        if (formInfos == null || formInfos.isEmpty()) {
            return null;
        }
        ArrayList<ProductFormSetting> settings = new ArrayList<ProductFormSetting>(formInfos.size());
        for (Map.Entry<String, FormBlackListInfo> entry : formInfos.entrySet()) {
            FormBlackListInfo info = entry.getValue();
            if (!info.isDisable() && !StringUtils.isNotBlank((CharSequence)info.getControlInner()) && !StringUtils.isNotBlank((CharSequence)info.getFieldInner()) && !StringUtils.isNotBlank((CharSequence)info.getListCtlInner())) continue;
            ProductFormSetting formSetting = FormBlackListSaveHelper.convertToSetting(info);
            settings.add(formSetting);
        }
        return ProductFileServiceHelper.saveFormSettingFileAsTempFile(settings, (int)ProductModeTypeUtil.getType(modelType).getValue());
    }

    public static String exportResourceFile(String modelType, CloudBlackListInfo blackList) {
        if (blackList == null || StringUtils.isBlank((CharSequence)blackList.getCloudId())) {
            return null;
        }
        Set<String> appIds = AppBlackListSaveHelper.getAppIdsByCloud(blackList.getCloudId());
        if (null == FormBlackListSaveHelper.createSettingList(modelType, appIds)) {
            return null;
        }
        return ProductFileServiceHelper.saveFormSettingFileAsTempFile(FormBlackListSaveHelper.createSettingList(modelType, appIds), (int)ProductModeTypeUtil.getType(modelType).getValue());
    }

    public static String exportAllClearResourceFile(String modelType, String cloudIdStr) {
        if (StringUtils.isBlank((CharSequence)cloudIdStr)) {
            return null;
        }
        Set<String> appIds = AppBlackListSaveHelper.getAppIdsByClouds(cloudIdStr);
        if (null == FormBlackListSaveHelper.createSettingList(modelType, appIds)) {
            return null;
        }
        return ProductFileServiceHelper.saveFormSettingAsClearFile(FormBlackListSaveHelper.createSettingList(modelType, appIds), ProductModeTypeUtil.getType(modelType).getValue());
    }

    private static List<ProductFormSetting> createSettingList(String modelType, Set<String> appIds) {
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType);
        if (formInfos == null || formInfos.isEmpty()) {
            return null;
        }
        ArrayList<ProductFormSetting> settings = new ArrayList<ProductFormSetting>(formInfos.size());
        if (appIds != null && !appIds.isEmpty()) {
            for (Map.Entry<String, FormBlackListInfo> entry : formInfos.entrySet()) {
                FormBlackListInfo info = entry.getValue();
                if (!appIds.contains(info.getAppId()) || !info.isDisable() && !StringUtils.isNotBlank((CharSequence)info.getControlInner()) && !StringUtils.isNotBlank((CharSequence)info.getFieldInner()) && !StringUtils.isNotBlank((CharSequence)info.getListCtlInner())) continue;
                ProductFormSetting formSetting = FormBlackListSaveHelper.convertToSetting(info);
                settings.add(formSetting);
            }
        }
        return settings;
    }

    public static String exportResourceFile(String modelType, AppBlackListInfo blackList) {
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType, blackList);
        if (formInfos == null || formInfos.isEmpty()) {
            return null;
        }
        ArrayList<ProductFormSetting> settings = new ArrayList<ProductFormSetting>(formInfos.size());
        for (Map.Entry<String, FormBlackListInfo> entry : formInfos.entrySet()) {
            FormBlackListInfo info = entry.getValue();
            if (info == null || !info.getAppId().equals(blackList.getAppId()) || !info.isDisable() && !StringUtils.isNotBlank((CharSequence)info.getControlInner()) && !StringUtils.isNotBlank((CharSequence)info.getFieldInner()) && !StringUtils.isNotBlank((CharSequence)info.getListCtlInner())) continue;
            ProductFormSetting formSetting = FormBlackListSaveHelper.convertToSetting(info);
            settings.add(formSetting);
        }
        return ProductFileServiceHelper.saveFormSettingFileAsTempFile(settings, (int)ProductModeTypeUtil.getType(modelType).getValue());
    }

    private static ProductFormSetting convertToSetting(FormBlackListInfo info) {
        ProductFormSetting formSetting = ProductFileServiceHelper.createProductFormSetting(info.getFormNumber());
        String controlStr = info.getControlInner();
        String fieldStr = info.getFieldInner();
        String listCtls = info.getListCtlInner();
        ArrayList<String> formVisisbleList = new ArrayList<String>(10);
        ArrayList<String> listVisisbleList = new ArrayList<String>(10);
        if (StringUtils.isNotBlank((CharSequence)controlStr)) {
            List controls = SerializationUtils.fromJsonStringToList((String)controlStr, ControlBlackListInfo.class);
            for (ControlBlackListInfo control : controls) {
                formVisisbleList.add(control.getId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)fieldStr)) {
            List fields = SerializationUtils.fromJsonStringToList((String)fieldStr, FieldBlackListInfo.class);
            for (FieldBlackListInfo field : fields) {
                formVisisbleList.add(field.getId());
            }
        }
        formSetting.setFormDisVisitControl(formVisisbleList);
        if (StringUtils.isNotBlank((CharSequence)listCtls)) {
            List ctls = SerializationUtils.fromJsonStringToList((String)listCtls, FieldBlackListInfo.class);
            HashMap<String, ArrayList<String>> dorpDownItems = new HashMap<String, ArrayList<String>>(16);
            for (FieldBlackListInfo fieldBlackListInfo : ctls) {
                String parentId = fieldBlackListInfo.getParentId();
                if (StringUtils.isBlank((CharSequence)parentId) || parentId.indexOf("_title") == -1) {
                    listVisisbleList.add(fieldBlackListInfo.getKey());
                    continue;
                }
                if ((parentId = parentId.substring(0, parentId.indexOf("_title"))).equals(fieldBlackListInfo.getKey())) {
                    listVisisbleList.add(fieldBlackListInfo.getKey());
                    continue;
                }
                ArrayList<String> items = (ArrayList<String>)dorpDownItems.get(parentId);
                if (items == null) {
                    items = new ArrayList<String>(10);
                }
                items.add(fieldBlackListInfo.getKey());
                dorpDownItems.put(parentId, items);
            }
            for (Map.Entry entry : dorpDownItems.entrySet()) {
                List hideDropItem = (List)entry.getValue();
                String itemKey = (String)entry.getKey();
                if (hideDropItem == null || hideDropItem.isEmpty()) continue;
                listVisisbleList.addAll(ProductMetaInstructionUtil.getListDropItemIds(info.getFormNumber(), itemKey, hideDropItem));
            }
            formSetting.setListDisVisitControl(listVisisbleList);
        }
        return formSetting;
    }

    private static FormBlackListInfo convertToFormBlackListInfo(DynamicObject form, ProductFormSetting formSetting) {
        String formId = form.getPkValue().toString();
        String formName = form.getString("name");
        String bizAppId = form.getString("bizappid");
        String formNumber = form.getString("number");
        FormBlackListInfo formInfo = new FormBlackListInfo(bizAppId, formId, formName, formNumber);
        if (formSetting == null) {
            return formInfo;
        }
        List<String> list = formSetting.getFormDisVisitControl();
        if (list != null && !list.isEmpty()) {
            List<ControlBlackListInfo> controlInfos = FormBlackListSaveHelper.convertToControls(formId, list);
            formInfo.setControlDisplay(FormBlackListSaveHelper.getControlDisplayName(controlInfos));
            formInfo.setControlInner(SerializationUtils.toJsonString(controlInfos));
            List<FieldBlackListInfo> fieldInfos = FormBlackListSaveHelper.convertToFields(formSetting.getFormNum(), list);
            formInfo.setFieldDisplay(FormBlackListSaveHelper.getFieldDisplayName(fieldInfos));
            formInfo.setFieldInner(SerializationUtils.toJsonString(fieldInfos));
        }
        return formInfo;
    }

    private static List<ControlBlackListInfo> convertToControls(String formId, List<String> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<ControlBlackListInfo>(1);
        }
        ArrayList<ControlBlackListInfo> controlInfos = new ArrayList<ControlBlackListInfo>(list.size());
        FormControlBuilder build = new FormControlBuilder();
        TreeNode root = build.buildTree(formId);
        for (String id : list) {
            TreeNode node = root.getTreeNode(id, 16);
            if (node == null) continue;
            ControlBlackListInfo controlInfo = new ControlBlackListInfo(id, node.getText(), node.getId(), node.getParentid());
            controlInfo.setDisable(true);
            controlInfos.add(controlInfo);
        }
        return controlInfos;
    }

    private static List<FieldBlackListInfo> convertToFields(String formNum, List<String> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<FieldBlackListInfo>(1);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formNum);
        if (!(type instanceof MainEntityType)) {
            return new ArrayList<FieldBlackListInfo>(1);
        }
        MainEntityType mainType = type;
        Map fields = mainType.getFields();
        ArrayList<FieldBlackListInfo> fieldInfos = new ArrayList<FieldBlackListInfo>(list.size());
        for (String id : list) {
            IDataEntityProperty fieldValue = (IDataEntityProperty)fields.get(id);
            if (fieldValue == null) continue;
            IDataEntityProperty field = (IDataEntityProperty)fields.get(id);
            FieldBlackListInfo fieldInfo = new FieldBlackListInfo(id, id, field.getDisplayName().getLocaleValue(), field.getParent().getName());
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    private static String getControlDisplayName(List<ControlBlackListInfo> infos) {
        StringBuilder name = new StringBuilder();
        if (infos == null || infos.isEmpty()) {
            return name.toString();
        }
        for (int i = 0; i < infos.size(); ++i) {
            ControlBlackListInfo info = infos.get(i);
            if (i == 0) {
                name.append(info.getText());
                continue;
            }
            name.append(',').append(info.getText());
        }
        return name.toString();
    }

    private static String getFieldDisplayName(List<FieldBlackListInfo> infos) {
        StringBuilder name = new StringBuilder();
        if (infos == null || infos.isEmpty()) {
            return name.toString();
        }
        for (int i = 0; i < infos.size(); ++i) {
            FieldBlackListInfo info = infos.get(i);
            if (i == 0) {
                name.append(info.getName());
                continue;
            }
            name.append(',').append(info.getName());
        }
        return name.toString();
    }
}

