/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.productmodel.kit.ProductModelType;
import kd.bos.designer.productmodel.model.FeatureBlackListInfo;
import kd.bos.designer.productmodel.model.FunctionBlackListInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

@DataEntityTypeAttribute(tableName="T_BAS_AppBlackList", dbRouteKey="sys.meta")
public class AppBlackListInfo {
    public static final String T_BAS_AppBlackList = "T_BAS_AppBlackList";
    private long id;
    private String cloudId;
    private String appId;
    private String appName;
    private String appNum;
    private boolean disable;
    private String functionDisplay;
    private String functionInner;
    private String featureDisplay;
    private String featureInner;
    private int modelType;
    private Map<String, FunctionBlackListInfo> functionInfos = new HashMap<String, FunctionBlackListInfo>(16);

    public AppBlackListInfo() {
    }

    public AppBlackListInfo(String cloudId, String appId, String appName) {
        this.cloudId = cloudId;
        this.appId = appId;
        this.appName = appName;
        this.modelType = ProductModelType.Standard.getValue();
    }

    public AppBlackListInfo(long id, String cloudId, String appId, String appName) {
        this.id = id;
        this.cloudId = cloudId;
        this.appId = appId;
        this.appName = appName;
        this.modelType = ProductModelType.Standard.getValue();
    }

    @Deprecated
    public AppBlackListInfo(long id, String cloudId, String appId, String appName, String appNum, boolean disable, String functions) {
    }

    public AppBlackListInfo(long id, String cloudId, String appId, String appName, String appNum, boolean disable, String functions, String features) {
        this(id, cloudId, appId, appName);
        this.appNum = appNum;
        this.disable = disable;
        this.functionInner = functions;
        this.functionDisplay = this.getfunctionDisplayName();
        this.featureInner = features;
        this.featureDisplay = this.getFeatureDisplayName();
    }

    public Map<String, FunctionBlackListInfo> formatFunction() {
        if (StringUtils.isBlank((CharSequence)this.functionInner)) {
            return new HashMap<String, FunctionBlackListInfo>(1);
        }
        List functions = SerializationUtils.fromJsonStringToList((String)this.functionInner, FunctionBlackListInfo.class);
        HashMap<String, FunctionBlackListInfo> map = new HashMap<String, FunctionBlackListInfo>(functions.size());
        for (FunctionBlackListInfo info : functions) {
            map.put(info.getMenuId(), info);
        }
        return map;
    }

    private String getfunctionDisplayName() {
        StringBuilder displayStr = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.functionInner)) {
            List menues = SerializationUtils.fromJsonStringToList((String)this.functionInner, FunctionBlackListInfo.class);
            for (int i = 0; i < menues.size(); ++i) {
                FunctionBlackListInfo info = (FunctionBlackListInfo)menues.get(i);
                if (i == 0) {
                    displayStr.append(info.getMenuName());
                    continue;
                }
                displayStr.append(",").append(info.getMenuName());
            }
        }
        return displayStr.toString();
    }

    private String getFeatureDisplayName() {
        StringBuilder displayStr = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.featureInner)) {
            List features = SerializationUtils.fromJsonStringToList((String)this.featureInner, FeatureBlackListInfo.class);
            for (int i = 0; i < features.size(); ++i) {
                FeatureBlackListInfo info = (FeatureBlackListInfo)features.get(i);
                if (i == 0) {
                    displayStr.append(info.getFeatureName());
                    continue;
                }
                displayStr.append(",").append(info.getFeatureName());
            }
        }
        return displayStr.toString();
    }

    @SimplePropertyAttribute(isPrimaryKey=true, alias="FId", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="FAPPNUM", dbType=12)
    public String getAppNum() {
        return this.appNum;
    }

    public void setAppNum(String appNum) {
        this.appNum = appNum;
    }

    @SimplePropertyAttribute(alias="FCLOUDID", dbType=12)
    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    @SimplePropertyAttribute(alias="FAPPID", dbType=12)
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @SimplePropertyAttribute(alias="FAPPNAME", dbType=12)
    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Map<String, FunctionBlackListInfo> getFunctionInfos() {
        return this.functionInfos;
    }

    public void setFunctionInfos(Map<String, FunctionBlackListInfo> functionInfos) {
        this.functionInfos = functionInfos;
    }

    @SimplePropertyAttribute(alias="FDISABLE", dbType=1)
    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public String getFunctionDisplay() {
        return this.functionDisplay;
    }

    public void setFunctionDisplay(String functionDisplay) {
        this.functionDisplay = functionDisplay;
    }

    @SimplePropertyAttribute(alias="FFUNCTIONS", dbType=2011)
    public String getFunctionInner() {
        return this.functionInner;
    }

    public void setFunctionInner(String functionInner) {
        this.functionInner = functionInner;
    }

    public String getFeatureDisplay() {
        return this.featureDisplay;
    }

    public void setFeatureDisplay(String featureDisplay) {
        this.featureDisplay = featureDisplay;
    }

    @SimplePropertyAttribute(alias="FFEATURES", dbType=2011)
    public String getFeatureInner() {
        return this.featureInner;
    }

    public void setFeatureInner(String featureInner) {
        this.featureInner = featureInner;
    }

    @SimplePropertyAttribute(alias="FMODELTYPE", dbType=1)
    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public static synchronized boolean checkCreateTable() {
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)T_BAS_AppBlackList)) {
            AppBlackListInfo.createTable();
            return true;
        }
        AppBlackListInfo.alterTable();
        return false;
    }

    private static void createTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlCreateTable = "create table T_BAS_AppBlackList (FID bigint not null primary key, FCLOUDID\t\t\t\tVARCHAR(36)\t\t NOT NULL, FAPPID\t\t\t\tVARCHAR(36)\t\t NOT NULL, FAPPNUM\t\t\t\tVARCHAR(50)\t \t NOT NULL, FAPPNAME\t\t\t\tNVARCHAR(50)\t NOT NULL, FDISABLE        \t\tCHAR(1)          NOT NULL, FFUNCTIONS\t\t\tNCLOB         \t NOT NULL DEFAULT ' ', FMODELTYPE           CHAR(1)      \t NOT NULL )";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"T_BAS_AppBlackList\u5efa\u8868\u5931\u8d25", (String)"AppBlackListInfo_0", (String)"bos-productmodel-resource", (Object[])new Object[0])});
        }
    }

    private static void alterTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlAddFeatureField = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME ='T_BAS_AppBlackList' and  KSQL_COL_NAME ='ffeatures') alter table T_BAS_AppBlackList ADD  FFEATURES  NCLOB";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlAddFeatureField, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"T_BAS_AppBlackList\u589e\u52a0\u5b57\u6bb5\u5931\u8d25", (String)"AppBlackListInfo_1", (String)"bos-productmodel-resource", (Object[])new Object[0])});
        }
    }
}

