/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.designer.productmodel.kit.ProductModelType;
import kd.bos.designer.productmodel.model.ControlBlackListInfo;
import kd.bos.designer.productmodel.model.FieldBlackListInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

@DataEntityTypeAttribute(tableName="T_BAS_FormBlackList", dbRouteKey="sys.meta")
public class FormBlackListInfo {
    public static final String T_BAS_FormBlackList = "T_BAS_FormBlackList";
    private long id;
    private String appId;
    private String formId;
    private String formName;
    private String formNumber;
    private boolean disable;
    private String controlDisplay;
    private String controlInner;
    private String fieldDisplay;
    private String fieldInner;
    private String listFieldDisplay;
    private String listFieldInner;
    private String listCtlDisplay;
    private String listCtlInner;
    private int modelType;
    private Map<String, ControlBlackListInfo> controls = new HashMap<String, ControlBlackListInfo>(16);
    private Map<String, FieldBlackListInfo> fields = new HashMap<String, FieldBlackListInfo>(16);

    public FormBlackListInfo() {
    }

    public FormBlackListInfo(String appId, String formId, String formName, String formNumber) {
        this.appId = appId;
        this.formId = formId;
        this.formName = formName;
        this.formNumber = formNumber;
        this.modelType = ProductModelType.Standard.getValue();
    }

    public FormBlackListInfo(long id, String appId, String formId, String formName, String formNumber) {
        this.id = id;
        this.appId = appId;
        this.formId = formId;
        this.formName = formName;
        this.formNumber = formNumber;
        this.modelType = ProductModelType.Standard.getValue();
    }

    public FormBlackListInfo(long id, String appId, String formId, String formName, String formNumber, String fieldInner, String controlInner) {
        this(id, appId, formId, formName, formNumber);
        this.fieldInner = fieldInner;
        this.fieldDisplay = this.getFieldDisplayName();
        this.controlInner = controlInner;
        this.controlDisplay = this.getControlDisplayName();
    }

    @SimplePropertyAttribute(isPrimaryKey=true, alias="FId", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="FAPPID", dbType=12)
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @SimplePropertyAttribute(alias="FFORMID", dbType=12)
    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    @SimplePropertyAttribute(alias="FFORMNAME", dbType=12)
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @SimplePropertyAttribute(alias="FFORMNUM", dbType=12)
    public String getFormNumber() {
        return this.formNumber;
    }

    public void setFormNumber(String formNumber) {
        this.formNumber = formNumber;
    }

    @SimplePropertyAttribute(alias="FDISABLE", dbType=1)
    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public Map<String, ControlBlackListInfo> getControls() {
        return this.controls;
    }

    public void setControls(Map<String, ControlBlackListInfo> controls) {
        this.controls = controls;
    }

    public Map<String, ControlBlackListInfo> formatControl() {
        if (StringUtils.isBlank((CharSequence)this.controlInner)) {
            return new HashMap<String, ControlBlackListInfo>(1);
        }
        List ctls = SerializationUtils.fromJsonStringToList((String)this.controlInner, ControlBlackListInfo.class);
        HashMap<String, ControlBlackListInfo> map = new HashMap<String, ControlBlackListInfo>(ctls.size());
        for (ControlBlackListInfo info : ctls) {
            map.put(info.getId(), info);
        }
        return map;
    }

    public Map<String, FieldBlackListInfo> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, FieldBlackListInfo> fields) {
        this.fields = fields;
    }

    public Map<String, FieldBlackListInfo> formatField() {
        if (StringUtils.isBlank((CharSequence)this.fieldInner)) {
            return new HashMap<String, FieldBlackListInfo>(1);
        }
        List flds = SerializationUtils.fromJsonStringToList((String)this.fieldInner, FieldBlackListInfo.class);
        HashMap<String, FieldBlackListInfo> map = new HashMap<String, FieldBlackListInfo>(flds.size());
        for (FieldBlackListInfo info : flds) {
            map.put(info.getId(), info);
        }
        return map;
    }

    public String getControlDisplay() {
        return this.controlDisplay;
    }

    public void setControlDisplay(String controlDisplay) {
        this.controlDisplay = controlDisplay;
    }

    @SimplePropertyAttribute(alias="FCONTROLS", dbType=2011)
    public String getControlInner() {
        return this.controlInner;
    }

    public void setControlInner(String controlInner) {
        this.controlInner = controlInner;
    }

    public String getFieldDisplay() {
        return this.fieldDisplay;
    }

    public void setFieldDisplay(String fieldDisplay) {
        this.fieldDisplay = fieldDisplay;
    }

    @SimplePropertyAttribute(alias="FFIELDS", dbType=2011)
    public String getFieldInner() {
        return this.fieldInner;
    }

    public void setFieldInner(String fieldInner) {
        this.fieldInner = fieldInner;
    }

    @SimplePropertyAttribute(alias="FMODELTYPE", dbType=1)
    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public String getListFieldDisplay() {
        return this.listFieldDisplay;
    }

    public void setListFieldDisplay(String listFieldDisplay) {
        this.listFieldDisplay = listFieldDisplay;
    }

    @SimplePropertyAttribute(alias="FLISTFIELDS", dbType=2011)
    public String getListFieldInner() {
        return this.listFieldInner;
    }

    public void setListFieldInner(String listFieldInner) {
        this.listFieldInner = listFieldInner;
        this.listFieldDisplay = this.getListFieldDisplayName();
    }

    public String getListCtlDisplay() {
        return this.listCtlDisplay;
    }

    public void setListCtlDisplay(String listCtlDisplay) {
        this.listCtlDisplay = listCtlDisplay;
    }

    @SimplePropertyAttribute(alias="FLISTCTLS", dbType=2011)
    public String getListCtlInner() {
        return this.listCtlInner;
    }

    public void setListCtlInner(String listCtlInner) {
        this.listCtlInner = listCtlInner;
        this.listCtlDisplay = this.getFieldName(this.listCtlInner);
    }

    private String getControlDisplayName() {
        return this.getControlName(this.controlInner);
    }

    private String getFieldDisplayName() {
        return this.getFieldName(this.fieldInner);
    }

    private String getListFieldDisplayName() {
        return this.getFieldName(this.listFieldInner);
    }

    private String getFieldName(String fieldInner) {
        StringBuilder name = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)fieldInner)) {
            return name.toString();
        }
        List infos = SerializationUtils.fromJsonStringToList((String)fieldInner, FieldBlackListInfo.class);
        for (int i = 0; i < infos.size(); ++i) {
            FieldBlackListInfo info = (FieldBlackListInfo)infos.get(i);
            if (i == 0) {
                name.append(info.getName());
                continue;
            }
            name.append(',').append(info.getName());
        }
        return name.toString();
    }

    private String getControlName(String controlInner) {
        StringBuilder name = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)controlInner)) {
            return name.toString();
        }
        List infos = SerializationUtils.fromJsonStringToList((String)controlInner, ControlBlackListInfo.class);
        for (int i = 0; i < infos.size(); ++i) {
            ControlBlackListInfo info = (ControlBlackListInfo)infos.get(i);
            if (i == 0) {
                name.append(info.getText());
                continue;
            }
            name.append(',').append(info.getText());
        }
        return name.toString();
    }

    public static synchronized boolean checkCreateTable() {
        if (!DB.exitsTable((DBRoute)DBRoute.meta, (String)T_BAS_FormBlackList)) {
            FormBlackListInfo.createTable();
            return true;
        }
        return false;
    }

    private static void createTable() {
        try (TXHandle h = TX.notSupported();){
            String sqlCreateTable = "create table T_BAS_FormBlackList (FID bigint not null primary key, FAPPID\t\t\t\tVARCHAR(36)\t\t NOT NULL, FFORMID\t\t\t\tVARCHAR(36)\t\t NOT NULL, FFORMNUM\t\t\t\tVARCHAR(50)\t \t NOT NULL, FFORMNAME\t\t\tNVARCHAR(50)\t NOT NULL, FDISABLE        \t\tCHAR(1)          NOT NULL, FFIELDS\t\t\t\tNCLOB         \t NOT NULL DEFAULT ' ', FCONTROLS\t\t\tNCLOB         \t NOT NULL DEFAULT ' ', FLISTFIELDS\t\t\tNCLOB        \t NOT NULL DEFAULT ' ', FLISTCTLS\t\t\tNCLOB        \t NOT NULL DEFAULT ' ', FMODELTYPE           CHAR(1)      \t NOT NULL )";
            DB.execute((DBRoute)DBRoute.meta, (String)sqlCreateTable, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"T_BAS_FormBlackList\u5efa\u8868\u5931\u8d25", (String)"FormBlackListInfo_0", (String)"bos-productmodel-resource", (Object[])new Object[0])});
        }
    }
}

