/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel.treebuild;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.productmodel.treebuild.BuildHelper;
import kd.bos.designer.productmodel.treebuild.ControlGroup;
import kd.bos.designer.productmodel.treebuild.ControlsTreeBuildOption;
import kd.bos.designer.productmodel.treebuild.IFormTreeBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.RuntimeMetaCollection;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.cardentry.CardEntryFlexPanelAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.cardentry.CardEntryViewAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.ToolbarAp;
import kd.bos.metadata.list.ListRuntimeMetaBuilder;

class ControlsTreeBuilderImpl
implements IFormTreeBuilder {
    private static String BOS_METADATA = "bos-metadata";
    private FormMetadata formMetadata;
    private FormAp formAp;
    private ControlsTreeBuildOption option;
    private static Set<String> ControlAps_invalid;
    private static Map<String, Class<?>> ControlAps_CardEntry;
    private static List<ControlGroup> ControlAps_Types;
    private static ControlGroup ControlType_Other;

    private static void initControlTypes() {
        ControlAps_Types = new ArrayList<ControlGroup>();
        ControlAps_Types.add(new ControlGroup("button_001", ResManager.loadKDString((String)"\u6309\u94ae\u7c7b", (String)"ControlsTreeBuilderImpl_0", (String)BOS_METADATA, (Object[])new Object[0]), ButtonAp.class));
        ControlAps_Types.add(new ControlGroup("toolbar_001", ResManager.loadKDString((String)"\u5de5\u5177\u680f\u7c7b", (String)"ControlsTreeBuilderImpl_1", (String)BOS_METADATA, (Object[])new Object[0]), ToolbarAp.class));
        ControlAps_Types.add(new ControlGroup("ta_b_001", ResManager.loadKDString((String)"\u9875\u7b7e\u7c7b", (String)"ControlsTreeBuilderImpl_2", (String)BOS_METADATA, (Object[])new Object[0]), TabAp.class));
        ControlAps_Types.add(new ControlGroup("fl_ex_001", ResManager.loadKDString((String)"\u9762\u677f\u7c7b", (String)"ControlsTreeBuilderImpl_3", (String)BOS_METADATA, (Object[])new Object[0]), FlexPanelAp.class));
        ControlAps_Types.add(new ControlGroup("ent_ry_001", ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7c7b", (String)"ControlsTreeBuilderImpl_4", (String)BOS_METADATA, (Object[])new Object[0]), EntryAp.class));
        ControlAps_Types.add(new ControlGroup("ca_rd_001", ResManager.loadKDString((String)"\u5361\u7247\u7c7b", (String)"ControlsTreeBuilderImpl_5", (String)BOS_METADATA, (Object[])new Object[0]), ControlAps_CardEntry.values()));
        ControlAps_Types.add(new ControlGroup("oth_er_001", ResManager.loadKDString((String)"\u5176\u4ed6\u7c7b", (String)"ControlsTreeBuilderImpl_6", (String)BOS_METADATA, (Object[])new Object[0]), ControlAp.class));
        ControlType_Other = new ControlGroup("oth_er_001", ResManager.loadKDString((String)"\u5176\u4ed6\u7c7b", (String)"ControlsTreeBuilderImpl_6", (String)BOS_METADATA, (Object[])new Object[0]), ControlAp.class);
    }

    private static void initListControlTypes() {
        ControlAps_Types = new ArrayList<ControlGroup>();
        ControlAps_Types.add(new ControlGroup("toolbar_001", ResManager.loadKDString((String)"\u5de5\u5177\u680f\u7c7b", (String)"ControlsTreeBuilderImpl_1", (String)BOS_METADATA, (Object[])new Object[0]), ToolbarAp.class));
    }

    public ControlsTreeBuilderImpl(FormMetadata formMetadata, ControlsTreeBuildOption option) {
        this.formMetadata = formMetadata;
        this.formMetadata.createIndex();
        this.formAp = this.formMetadata.getRootAp();
        this.option = option;
        if (this.option == null) {
            this.option = new ControlsTreeBuildOption();
        }
    }

    public ControlsTreeBuilderImpl(FormMetadata formMetadata, ControlsTreeBuildOption option, boolean isList) {
        this(formMetadata, option);
        if (isList) {
            option.addMatchedClassTypes(ToolbarAp.class);
            option.addMatchedClassTypes(BarItemAp.class);
            ControlAps_invalid.remove(BarItemAp.class.getSimpleName());
            FormAp rootap = formMetadata.getRootAp();
            ControlsTreeBuilderImpl.initListControlTypes();
            if (rootap instanceof BillFormAp) {
                RuntimeMetaCollection metas = new RuntimeMetaCollection();
                ListRuntimeMetaBuilder.buildList((FormMetadata)this.formMetadata, (FormMetadata)((BillFormAp)rootap).getListMeta(), (List)metas, (String)"");
                this.formMetadata = ((BillFormAp)rootap).getListMeta();
            }
        }
    }

    @Override
    public TreeNode build() {
        TreeNode root = this.buildRootNode();
        HashMap groupNodes = new HashMap();
        for (ControlAp controlAp : this.formMetadata.getItems()) {
            if (!this.canAdd(controlAp)) continue;
            ControlGroup controlGroup = this.getControlGroup(controlAp);
            TreeNode node = new TreeNode();
            node.setParentid(controlGroup.getId());
            node.setId(this.option.isOutKey() ? controlAp.getKey() : controlAp.getId());
            node.setText(controlAp.getName() == null ? controlAp.getKey() : controlAp.getName().toString() + "(" + controlAp.getKey() + ")");
            if (!groupNodes.containsKey(controlGroup.getId())) {
                ArrayList nodes = new ArrayList();
                groupNodes.put(controlGroup.getId(), nodes);
            }
            ((List)groupNodes.get(controlGroup.getId())).add(node);
            if (controlAp instanceof TabAp) {
                this.addTabPageNodes(node, (TabAp)controlAp);
                continue;
            }
            if (!(controlAp instanceof ToolbarAp)) continue;
            this.addBarItemNodes(node, (ToolbarAp)controlAp);
        }
        for (ControlGroup controlGroup : ControlAps_Types) {
            if (!groupNodes.containsKey(controlGroup.getId())) continue;
            TreeNode groupNode = new TreeNode();
            groupNode.setParentid(this.formAp.getKey());
            groupNode.setId(controlGroup.getId());
            groupNode.setText(controlGroup.getText());
            List listNode = (List)groupNodes.get(controlGroup.getId());
            for (TreeNode treeNode : listNode) {
                groupNode.addChild(treeNode);
            }
            root.addChild(groupNode);
        }
        return root;
    }

    private boolean canAdd(ControlAp<?> controlAp) {
        if (ControlAps_invalid.contains(controlAp.getClass().getSimpleName()) || BuildHelper.isAssignableFrom(this.option.getInvalidClassTypes(), controlAp.getClass())) {
            return false;
        }
        return this.option.getMatchedClassTypes().isEmpty() || BuildHelper.isAssignableFrom(this.option.getMatchedClassTypes(), controlAp.getClass());
    }

    private TreeNode buildRootNode() {
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(this.formAp.getKey());
        root.setText(this.formAp.getName() == null ? this.formAp.getKey() : this.formAp.getName().toString());
        root.setIsOpened(true);
        return root;
    }

    private void addTabPageNodes(TreeNode tabNode, TabAp tabAp) {
        for (ControlAp control : tabAp.getItems()) {
            TreeNode tabPageNode = new TreeNode();
            tabPageNode.setParentid(tabAp.getKey());
            tabPageNode.setId(this.option.isOutKey() ? control.getKey() : control.getId());
            tabPageNode.setText(control.getName() == null ? control.getKey() : control.getName() + "(" + control.getKey() + ")");
            tabNode.addChild(tabPageNode);
        }
    }

    private void addBarItemNodes(TreeNode toolBarNode, ToolbarAp toolbarAp) {
        for (ControlAp control : toolbarAp.getItems()) {
            if (!(control instanceof BarItemAp)) continue;
            TreeNode barItemNode = new TreeNode();
            barItemNode.setParentid(toolbarAp.getKey());
            barItemNode.setId(this.option.isOutKey() ? control.getKey() : control.getId());
            barItemNode.setText(control.getName() == null ? control.getKey() : control.getName() + "(" + control.getKey() + ")");
            toolBarNode.addChild(barItemNode);
            for (DropdownItem subItem : ((BarItemAp)control).getDropdownItems()) {
                TreeNode subItemNode = new TreeNode();
                subItemNode.setParentid(toolbarAp.getKey());
                subItemNode.setId(subItem.getKey());
                subItemNode.setText(subItem.getTitle() == null ? subItem.getKey() : subItem.getTitle().toString() + "(" + subItem.getKey() + ")");
                toolBarNode.addChild(subItemNode);
            }
        }
    }

    private ControlGroup getControlGroup(ControlAp<?> controlAp) {
        for (ControlGroup type : ControlAps_Types) {
            if (!BuildHelper.isAssignableFrom(type.getControls(), controlAp.getClass())) continue;
            return type;
        }
        return ControlType_Other;
    }

    static {
        ControlAps_CardEntry = new HashMap();
        ControlAps_CardEntry.put("CardEntryAp", CardEntryAp.class);
        ControlAps_CardEntry.put("CardEntryFieldAp", CardEntryFieldAp.class);
        ControlAps_CardEntry.put("CardEntryFlexPanelAp", CardEntryFlexPanelAp.class);
        ControlAps_CardEntry.put("CardEntryRowAp", CardEntryRowAp.class);
        ControlAps_CardEntry.put("CardEntryViewAp", CardEntryViewAp.class);
        ControlAps_invalid = new HashSet<String>();
        ControlAps_invalid.add(FormAp.class.getSimpleName());
        ControlAps_invalid.add(FieldAp.class.getSimpleName());
        ControlAps_invalid.add(TabPageAp.class.getSimpleName());
        ControlAps_invalid.add(BarItemAp.class.getSimpleName());
        ControlsTreeBuilderImpl.initControlTypes();
    }
}

