/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel.FileHandler;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.productmodel.IProductBlackFileHandler;
import kd.bos.productmodel.ProductBlackList;
import kd.bos.productmodel.encry.BlackListEncryHelper;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public abstract class AbstractBlackFileHandler
implements IProductBlackFileHandler {
    private static final String QUERY_BIZAPP_SQL = "select fid,fnumber,fbizcloudid from t_meta_bizapp";
    private static final String KEY_FNUMBER = "fnumber";
    protected ProductBlackList blackList;
    private Map<String, String> cloudIdMapping = new CaseInsensitiveMap();
    private Map<String, String> appIdMapping = new CaseInsensitiveMap();
    private Map<String, String> appNumMapping = new CaseInsensitiveMap();
    private Map<String, String> appCloudIdMapping = new CaseInsensitiveMap();

    AbstractBlackFileHandler(ProductBlackList value) {
        this.blackList = value;
    }

    @Override
    public String buildEncryptContent() {
        return BlackListEncryHelper.EncryptContent(SerializationUtils.toJsonString((Object)this.blackList));
    }

    @Override
    public String buildFileContent() {
        return SerializationUtils.toJsonString((Object)this.blackList);
    }

    protected Map<String, String> getAppNumMapping() {
        if (this.appNumMapping.isEmpty()) {
            DB.query((DBRoute)DBRoute.meta, (String)QUERY_BIZAPP_SQL, rs -> {
                while (rs.next()) {
                    String pkid = rs.getString("fid");
                    String appId = rs.getString(KEY_FNUMBER);
                    this.appNumMapping.put(appId.toLowerCase(), pkid);
                }
                return Boolean.TRUE;
            });
        }
        return this.appNumMapping;
    }

    protected Map<String, String> getAppCloudIdMapping() {
        if (this.appCloudIdMapping.isEmpty()) {
            DB.query((DBRoute)DBRoute.meta, (String)QUERY_BIZAPP_SQL, rs -> {
                while (rs.next()) {
                    String pkid = rs.getString("fid");
                    String cloudId = rs.getString("fbizcloudid");
                    this.appCloudIdMapping.put(pkid, cloudId);
                }
                return Boolean.TRUE;
            });
        }
        return this.appCloudIdMapping;
    }

    protected Map<String, String> getAppIdMapping() {
        if (this.appIdMapping.isEmpty()) {
            boolean initNumMapping = this.appNumMapping.isEmpty();
            DB.query((DBRoute)DBRoute.meta, (String)QUERY_BIZAPP_SQL, rs -> {
                while (rs.next()) {
                    String pkid = rs.getString("fid");
                    String appId = rs.getString(KEY_FNUMBER);
                    this.appIdMapping.put(pkid, appId.toLowerCase());
                    if (!initNumMapping) continue;
                    this.appNumMapping.put(appId.toLowerCase(), pkid);
                }
                return Boolean.TRUE;
            });
            String sql2 = "select fid,fappid from t_meta_appruntime";
            DB.query((DBRoute)DBRoute.meta, (String)sql2, rs -> {
                while (rs.next()) {
                    String pkid = rs.getString("fid");
                    String appId = rs.getString("fappid");
                    this.appIdMapping.put(pkid, appId.toLowerCase());
                }
                return Boolean.TRUE;
            });
        }
        return this.appIdMapping;
    }

    protected String getAppNum(String id) {
        Pattern pattern = Pattern.compile("[a-z]");
        Matcher matcher = pattern.matcher(id);
        if (id.length() > 10 || !matcher.find()) {
            return this.getAppIdMapping().get(id.toLowerCase());
        }
        return id;
    }

    protected String getCloudNum(String id) {
        if (this.cloudIdMapping.isEmpty()) {
            String sql = "select fid,fnumber from t_meta_bizcloud";
            DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
                while (rs.next()) {
                    String pkid = rs.getString("fid");
                    String appId = rs.getString(KEY_FNUMBER);
                    this.cloudIdMapping.put(appId.toLowerCase(), pkid);
                }
                return Boolean.TRUE;
            });
        }
        return this.cloudIdMapping.get(id.toLowerCase());
    }
}

