/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel.FileHandler;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.productmodel.IProductFormFileHandler;
import kd.bos.productmodel.ProductFormSetting;
import kd.bos.productmodel.encry.BlackListEncryHelper;
import kd.bos.service.ServiceFactory;

public abstract class AbstractFormFileHandler
implements IProductFormFileHandler {
    protected ProductFormSetting setting;
    private FormMetadata formMetadata;
    private static final Log log = LogFactory.getLog(AbstractFormFileHandler.class);

    AbstractFormFileHandler(ProductFormSetting setting) {
        this.setting = setting;
    }

    protected FormMetadata getFormMetadata() {
        if (this.formMetadata != null) {
            return this.formMetadata;
        }
        String formId = MetadataDao.getIdByNumber((String)this.getFormNum(), (MetaCategory)MetaCategory.Form);
        if (StringUtils.isBlank((CharSequence)formId)) {
            log.info(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801\uff1a%1$s \u83b7\u53d6\u5230id\u4e3a\uff1a%2$s\uff0c\u65e0\u6cd5\u8bfb\u53d6\u5143\u6570\u636e\u3002", (String)"FormSettingCacheManager_0", (String)"bos-productmodel-resource", (Object[])new Object[0]), this.getFormNum(), formId));
            return new FormMetadata();
        }
        this.formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isNotBlank((CharSequence)this.formMetadata.getEntityId())) {
            EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)this.formMetadata.getEntityId(), (MetaCategory)MetaCategory.Entity);
            this.formMetadata.bindEntityMetadata(meta);
        }
        return this.formMetadata;
    }

    @Override
    public void clear() {
        this.formMetadata = null;
        this.setting.clear();
    }

    @Override
    public String getFormNum() {
        return String.valueOf(this.setting.get("form"));
    }

    @Override
    public void setFormNum(String formNum) {
        if (StringUtils.equals((CharSequence)formNum, (CharSequence)this.getFormNum())) {
            return;
        }
        this.clear();
        this.setting.put("form", formNum);
        String id = MetadataDao.getIdByNumber((String)formNum, (MetaCategory)MetaCategory.Form);
        this.formMetadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isNotBlank((CharSequence)this.formMetadata.getEntityId())) {
            EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)this.formMetadata.getEntityId(), (MetaCategory)MetaCategory.Entity);
            this.formMetadata.bindEntityMetadata(meta);
        }
    }

    public ProductFormSetting buildDiffSetting() {
        return this.setting;
    }

    @Override
    public String buildEncryptContent() {
        return BlackListEncryHelper.EncryptContent(this.buildFileContent());
    }

    @Override
    public String getAppNum() {
        return this.getFormMetadata().getBizappNumber();
    }

    @Override
    public String getCloudNum() {
        BizAppService service = (BizAppService)ServiceFactory.getService(BizAppService.class);
        Object info = service.getCloudAndAppInfoByFormId(this.getFormNum());
        return String.valueOf(((Map)info).get("cloudnumber"));
    }

    protected long getPk() {
        String pk = String.valueOf(this.setting.get("filepkid"));
        if (!"null".equals(pk) && StringUtils.isNotBlank((CharSequence)pk)) {
            return Long.parseLong(pk);
        }
        return 0L;
    }

    protected void setPk(long pk) {
        this.setting.put("filepkid", pk);
    }

    protected boolean isControlVisible(String v) {
        return !"0".equals(v) && !StringUtils.isBlank((CharSequence)v);
    }

    @Override
    public String getFileVer() {
        Object ver = this.setting.get("version");
        return ver == null ? "" : ver.toString();
    }
}

