/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.productmodel.BlackSettingCacheManager;
import kd.bos.productmodel.FormSettingCacheManager;
import kd.bos.service.ServiceFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class ProductSettingServiceImpl
implements ProductSettingService {
    private static Log log = LogFactory.getLog(ProductSettingServiceImpl.class);
    private static final String PRODUCTMODELENABLE = "sys.productmodelsetting.enable";
    private static boolean applyModelSetting = true;

    private String getLogMessage() {
        return ResManager.loadKDString((String)"\u8fd0\u884c\u6a21\u5f0f\uff1a%1$s\uff0c\u5e94\u7528\u9ed1\u540d\u5355\uff1a%2$s", (String)"ProductSettingServiceImpl_0", (String)"bos-productmodel-resource", (Object[])new Object[0]);
    }

    public List<String> getAppNumBlackList() {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        Map<String, String> map = BlackSettingCacheManager.getAllAppInfoBlackList();
        log.info(String.format(this.getLogMessage(), this.getProductModel(), map == null ? "" : SerializationUtils.toJsonString(map)));
        return map == null ? new ArrayList<String>() : new ArrayList<String>(map.values());
    }

    public List<String> getAppIdBlackList() {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        Map<String, String> map = BlackSettingCacheManager.getAllAppInfoBlackList();
        log.info(String.format(this.getLogMessage(), this.getProductModel(), map == null ? "" : SerializationUtils.toJsonString(map)));
        return map == null ? new ArrayList<String>() : new ArrayList<String>(map.keySet());
    }

    public List<String> getCloudIdBlackList() {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        Map<String, String> map = BlackSettingCacheManager.getAllBlackCloudList();
        log.info(String.format(this.getLogMessage(), this.getProductModel(), map == null ? "" : SerializationUtils.toJsonString(map)));
        return map == null ? new ArrayList<String>() : new ArrayList<String>(map.keySet());
    }

    public List<String> getFormBlackList() {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        Map<String, String> map = BlackSettingCacheManager.getAllFormInfoBlackList();
        log.info(String.format(ResManager.loadKDString((String)"\u8fd0\u884c\u6a21\u5f0f\uff1a%1$s\uff0c\u8868\u5355\u9ed1\u540d\u5355\uff1a%2$s", (String)"ProductSettingServiceImpl_1", (String)"bos-productmodel-resource", (Object[])new Object[0]), this.getProductModel(), map == null ? "" : SerializationUtils.toJsonString(map)));
        return map == null ? new ArrayList<String>() : new ArrayList<String>(map.values());
    }

    public List<String> getFormBlackListByAppId(String id) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        Map<String, String> map = BlackSettingCacheManager.getFormInfoBlackListByAppId(id = this.getAppId(id));
        return map == null ? new ArrayList<String>() : new ArrayList<String>(map.values());
    }

    private String getAppId(String idOrNum) {
        String appId = AppReader.getAppIdByNumber((String)idOrNum);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return idOrNum;
        }
        return appId;
    }

    public List<String> getFormIdBlackListByAppId(String id) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        Map<String, String> map = BlackSettingCacheManager.getFormInfoBlackListByAppId(id = this.getAppId(id));
        return map == null ? new ArrayList<String>() : new ArrayList<String>(map.keySet());
    }

    public Map<String, Map<String, Object>> getFormCtlMetaSetting(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new HashMap<String, Map<String, Object>>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getFormCtlMetaSetting();
    }

    public List<String> getFormDisVistCtl(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getFormDisVistCtl();
    }

    public QFilter[] getFormBlacklistFilters(QFilter[] filters, String filterKey) {
        QFilter qFilter = ProductSettingServiceImpl.wrapNotinFilter(this.getFormBlackList(), filterKey);
        return ProductSettingServiceImpl.addFilterToFilters(filters, qFilter);
    }

    private static QFilter wrapNotinFilter(List<String> formBlackList, String filterKey) {
        try {
            if (formBlackList == null || formBlackList.isEmpty() || StringUtils.isEmpty((CharSequence)filterKey)) {
                return null;
            }
            return new QFilter(filterKey, "not in", formBlackList);
        }
        catch (Exception e) {
            log.error("\u6839\u636e" + filterKey + "\u5c01\u88c5\u8868\u5355\u9ed1\u540d\u5355\u5230QFilter[]\u6709\u8bef\uff01", (Throwable)e);
            return null;
        }
    }

    private static QFilter[] addFilterToFilters(QFilter[] filters, QFilter qf) {
        try {
            if (qf == null) {
                return filters;
            }
            if (filters == null) {
                filters = new QFilter[]{qf};
            } else {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
                filterList.add(qf);
                filters = filterList.toArray(new QFilter[filterList.size()]);
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u8868\u5355\u9ed1\u540d\u5355\u5230QFilter[]\u6709\u8bef\uff01", (Throwable)e);
        }
        return filters;
    }

    public List<String> getListDisVistCtl(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getListDisVistCtl();
    }

    public List<String> getListDisVistField(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getListDisVistField();
    }

    public List<String> getMobDisVistCtl(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getMobDisVistCtl();
    }

    public List<String> getMobListDisVistCtl(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getMobListDisVistCtl();
    }

    public List<String> getAppMenuBlackList(String id) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        id = this.getAppId(id);
        List<String> menus = BlackSettingCacheManager.getBlackMenuByAppId(id);
        log.info(String.format("appid\uff1a%s,\u8fd0\u884c\u6a21\u5f0f\uff1a%s\uff0c\u9ed1\u540d\u5355\u83dc\u5355\uff1a%s", id, this.getProductModel(), menus == null ? "" : SerializationUtils.toJsonString(menus)));
        return menus;
    }

    public Map<String, List<String>> getBlackMenuAndApp(Map<String, String> appMap) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return null;
        }
        Map<String, List<String>> result = BlackSettingCacheManager.getBlackMenuAndApp(appMap);
        log.info(String.format("\u8fd0\u884c\u6a21\u5f0f\uff1a%s\uff0c\u9ed1\u540d\u5355\u83dc\u5355\uff1a%s", this.getProductModel(), result == null ? "" : SerializationUtils.toJsonString(result)));
        return result;
    }

    public List<String> getFormDisVisitField(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getFormDisVisitField();
    }

    private int getProductModel() {
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        return service.getModeType();
    }

    private boolean isUltimateMode() {
        int model = this.getProductModel();
        return model == 2 || model == 4;
    }

    public void clearAllCache() {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return;
        }
        BlackSettingCacheManager.clearAllCacheData();
        FormSettingCacheManager.clearCache();
    }

    public Map<String, Map<String, Object>> getListCtlMetaInstruct(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new HashMap<String, Map<String, Object>>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getListCtlMetaSetting();
    }

    public List<Map<String, Object>> getFormHideInstructions(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<Map<String, Object>>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getFormCtlHideInstructions();
    }

    public List<Map<String, Object>> getListHideInstructions(String formNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<Map<String, Object>>();
        }
        return FormSettingCacheManager.getCacheData(formNum).getListCtlHideInstructions();
    }

    public List<String> getFeatureBlackListByAppId(String appIdOrNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return new ArrayList<String>();
        }
        String appId = this.getAppId(appIdOrNum);
        List<String> features = BlackSettingCacheManager.getBlackFeatureByAppId(appId);
        log.info(String.format("appid\uff1a%s,\u8fd0\u884c\u6a21\u5f0f\uff1a%s\uff0c\u9ed1\u540d\u5355\u7279\u6027\uff1a%s", appId, this.getProductModel(), features == null ? "" : SerializationUtils.toJsonString(features)));
        return features;
    }

    public boolean hasBlackFeature(String appIdOrNum, String featureNum) {
        if (!applyModelSetting || !this.isUltimateMode()) {
            return false;
        }
        String appId = this.getAppId(appIdOrNum);
        List<String> featureBlackList = this.getFeatureBlackListByAppId(appId);
        if (featureBlackList != null && !featureBlackList.isEmpty()) {
            return featureBlackList.contains(featureNum);
        }
        return false;
    }

    static {
        applyModelSetting = Boolean.parseBoolean(System.getProperty(PRODUCTMODELENABLE, "true"));
        ConfigurationUtil.observeChange((String)PRODUCTMODELENABLE, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                applyModelSetting = Boolean.parseBoolean(System.getProperty(ProductSettingServiceImpl.PRODUCTMODELENABLE, "true"));
            }
        });
    }
}

