/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel.encry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kd.bos.dataentity.utils.StringUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

class OneTimePadUtil {
    private static final Logger logger = Logger.getLogger(OneTimePadUtil.class);

    OneTimePadUtil() {
    }

    static byte[] xorLengthEqual(byte[] bytes, byte[] keyBytes) {
        if (keyBytes.length != bytes.length) {
            throw new IllegalArgumentException("keyBytes.length not equal orignBytes.length");
        }
        byte[] resultBytes = new byte[bytes.length];
        for (int i = 0; i < resultBytes.length; ++i) {
            resultBytes[i] = (byte)(keyBytes[i] ^ bytes[i]);
        }
        return resultBytes;
    }

    static byte[] xor(byte[] bytes, byte[] keyBytes) {
        if (bytes.length <= 0 || keyBytes.length <= 0) {
            throw new IllegalArgumentException("Bytes.length is 0");
        }
        byte[] resultBytes = new byte[bytes.length];
        int keyLength = keyBytes.length;
        for (int i = 0; i < resultBytes.length; ++i) {
            int j = i % keyLength;
            resultBytes[i] = (byte)(keyBytes[j] ^ bytes[i]);
        }
        return resultBytes;
    }

    static String processObject2Xml(Object value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream obj = new ObjectOutputStream(baos);
            obj.writeObject(value);
        }
        catch (IOException ioe) {
            logger.error((Object)("processObject2Xml : Object Serializable Error,IOException :" + ioe));
        }
        return Base64.encodeBase64String((byte[])baos.toByteArray());
    }

    static Object processXml2Object(String xml) {
        Object object = null;
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return object;
        }
        try {
            byte[] bytes = Base64.decodeBase64((String)xml);
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(bytes));
            object = input.readObject();
        }
        catch (IOException e) {
            logger.error((Object)("processXml2Object : Object DeSerializable Error,IOException :" + e));
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("processXml2Object : Object DeSerializable Error,ClassNotFoundException :" + e));
        }
        return object;
    }
}

