/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.ai.IUIVoiceText;
import kd.bos.ai.model.AICommandType;
import kd.bos.ai.model.CommandModel;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.UiNameModel;
import kd.bos.ai.util.AICommandUtil;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.session.SessionQuery;

public class OpenBillServicePlugin
extends AbstractBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(OpenBillServicePlugin.class);
    private static final String SEPARATOR = "\\s+";
    private static final String PARAM_BILL_NAME = "billName";
    private static final String PARAM_FORM_ID = "formId";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String FORM_ID = "formid";
    private static final String APPDESC = "appDesc";
    private static final String APPNAME = "appName";
    private static final String OPENBILLSERVICEPLUGIN_6 = "OpenBillServicePlugin_6";
    private List<AppMetadata> cacheList = null;

    public void doAICommand(AICommandEvent e) {
        long start = System.currentTimeMillis();
        this.wrapAICommand(e);
        long end = System.currentTimeMillis();
        logger.info("doAICommand take times: " + (end - start));
    }

    public List<AppMetadata> getAllAppMetadatas() {
        if (this.cacheList == null) {
            this.cacheList = BizAppServiceHelp.getAllAppMetadatas();
        }
        return this.cacheList;
    }

    private void wrapAICommand(AICommandEvent e) {
        try (EntityTraceSpan span = EntityTracer.create((String)"OpenBillServicePlugin", (String)"wrapAICommand");){
            ResponseModel data;
            block30: {
                List<Map<String, Object>> queryResult;
                String aitoken;
                RequestContext requestContext;
                String billName;
                Map commandParams;
                block31: {
                    String formId;
                    AICommand cmd = e.getCommand();
                    commandParams = cmd.getParameter();
                    span.addLocaleTag("parameter", (Object)commandParams);
                    billName = commandParams.get(PARAM_BILL_NAME).toString();
                    String string = formId = commandParams.get(PARAM_FORM_ID) == null ? "" : commandParams.get(PARAM_FORM_ID).toString();
                    if (billName == null || billName.isEmpty()) {
                        ApiResult ret = new ApiResult();
                        ret.setSuccess(true);
                        ResponseModel data2 = ResponseModel.createTextResponse(ResManager.loadKDString((String)"\u6253\u5f00\u62a5\u8868\u5931\u8d25\u3002\u53c2\u6570\u4e2d\u62a5\u8868\u540d\u79f0\u4e3a\u7a7a", (String)"OpenBillServicePlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        ret.setData((Object)data2);
                        e.setResult(ret);
                        span.addLocaleTag("ApiResult", (Object)ret);
                        return;
                    }
                    long aitokenStart = System.currentTimeMillis();
                    requestContext = RequestContext.get();
                    aitoken = requestContext.getGlobalSessionId();
                    aitoken = commandParams.get("kdSessionId") != null ? commandParams.get("kdSessionId").toString() : this.getAiTokenFromCache(requestContext.getUserOpenId());
                    long aitokenEnd = System.currentTimeMillis();
                    span.addLocaleTag("getAiTokenFromCache take times: ", (Object)(aitokenEnd - aitokenStart));
                    data = null;
                    long start = System.currentTimeMillis();
                    queryResult = this.getTargetFormInfos(billName, formId);
                    long end = System.currentTimeMillis();
                    span.addLocaleTag("getMostLikelyTarget take times:", (Object)(end - start));
                    span.addLocaleTag(ResManager.loadKDString((String)"\u8868\u5355\u4fe1\u606f\u5982\u4e0b", (String)"OpenBillServicePlugin_14", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), (Object)SerializationUtils.toJsonString(queryResult));
                    if (queryResult.isEmpty()) {
                        data = ResponseModel.createTextResponse(this.getNotFoundMsg(billName));
                        break block30;
                    }
                    if (queryResult.size() <= 1) break block31;
                    UiNameModel uiNameModel = this.formatResultMsg(queryResult);
                    String playMsg = String.format(ResManager.loadKDString((String)"\u60a8\u8981\u627e\u54ea\u4e2a\u201c%s\u201d", (String)"OpenBillServicePlugin_16", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), billName);
                    uiNameModel.setTitle(playMsg);
                    data = ResponseModel.createUiNameResponse(uiNameModel);
                    return;
                }
                try {
                    Map<String, Object> oOpenTarget = queryResult.get(0);
                    String menuItemId = (String)oOpenTarget.get("menuId");
                    String bizappid = (String)oOpenTarget.get("bizappId");
                    String appMainPageId = (String)oOpenTarget.get(FORM_ID);
                    if (menuItemId != null || appMainPageId != null || bizappid != null) {
                        CommandModel command = new CommandModel();
                        command.setType(AICommandType.OPEN_MENU.getCommand());
                        Map<String, Object> para = this.fetchParams(commandParams);
                        if (para == null) {
                            para = new HashMap<String, Object>();
                        }
                        para.put("menuId", menuItemId);
                        para.put("bizappId", bizappid);
                        para.put("isAIVoiceRequest", Boolean.TRUE);
                        para.put(PARAM_FORM_ID, oOpenTarget.get(FORM_ID));
                        command.setPara(para);
                        if (StringUtils.isBlank((CharSequence)aitoken)) {
                            span.addTag("aitoken==null || aitoken.isEmpty() =", "true");
                            long getUserSessionsStart = System.currentTimeMillis();
                            List sessionIds = SessionQuery.getUserSessions((String)requestContext.getAccountId(), (String)requestContext.getUserId());
                            long getUserSessionsEnd = System.currentTimeMillis();
                            span.addLocaleTag("getUserSessions take times", (Object)(getUserSessionsEnd - getUserSessionsStart));
                            span.addLocaleTag("sessionids len", (Object)sessionIds.size());
                            for (String id : sessionIds) {
                                AICommandUtil.sendOpenMenuCommand(id, command);
                            }
                            long sendOpenMenuCommandEnd = System.currentTimeMillis();
                            span.addLocaleTag("sendOpenMenuCommand take times: ", (Object)(sendOpenMenuCommandEnd - getUserSessionsEnd));
                        } else {
                            long tokenStart = System.currentTimeMillis();
                            span.addTag("aitoken==null || aitoken.isEmpty() =", "false");
                            AICommandUtil.sendOpenMenuCommand(aitoken, command);
                            long tokenEnd = System.currentTimeMillis();
                            span.addLocaleTag("aitoken sendOpenMenuCommand take times", (Object)(tokenEnd - tokenStart));
                        }
                        UiNameModel uiNameModel = this.formatResultMsg(queryResult);
                        String playMsg = this.getToPlayMsg(billName, commandParams);
                        uiNameModel.setTitle(playMsg);
                        data = ResponseModel.createUiNameResponse(uiNameModel);
                    } else {
                        data = ResponseModel.createTextResponse(this.getNotFoundMsg(billName));
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    data = ResponseModel.createTextResponse(String.format(ResManager.loadKDString((String)"\u62b1\u6b49\uff01\u6253\u5f00%s\u7684\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"OpenBillServicePlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), billName));
                }
            }
            if (data == null) {
                throw new RuntimeException(ResManager.loadKDString((String)"data\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OpenBillServicePlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            ApiResult ret = new ApiResult();
            ret.setSuccess(true);
            ret.setData((Object)data);
            e.setResult(ret);
            span.addLocaleTag("ApiResult", (Object)ret);
        }
    }

    private UiNameModel formatResultMsg(List<Map<String, Object>> queryResult) {
        ArrayList<UiNameModel.AppItem> list = new ArrayList<UiNameModel.AppItem>(10);
        HashMap<String, ArrayList<Map<String, Object>>> appMaps = new HashMap<String, ArrayList<Map<String, Object>>>(16);
        for (Map<String, Object> map : queryResult) {
            String appId = (String)map.get("bizappId");
            if (StringUtils.isEmpty((CharSequence)appId)) continue;
            ArrayList<Map<String, Object>> appForms = (ArrayList<Map<String, Object>>)appMaps.get(appId);
            if (appForms == null) {
                appForms = new ArrayList<Map<String, Object>>(10);
            }
            appForms.add(map);
            appMaps.put(appId, appForms);
        }
        for (Map.Entry entry : appMaps.entrySet()) {
            List forms = (List)entry.getValue();
            if (forms == null || forms.isEmpty()) continue;
            Map first = (Map)forms.get(0);
            String appDesc = first.get(APPDESC) == null ? "" : (String)first.get(APPDESC);
            String appName = first.get(APPNAME) == null ? "" : (String)first.get(APPNAME);
            String logo = first.get("logo") == null ? "" : (String)first.get("logo");
            int size = forms.size();
            ArrayList<UiNameModel.SelectItem> selects = new ArrayList<UiNameModel.SelectItem>(size);
            for (int i = 0; i < size; ++i) {
                Map menu = (Map)forms.get(i);
                String desc = menu.get("name") == null ? "" : menu.get("name").toString();
                String value = menu.get(FORM_ID) == null ? "" : menu.get(FORM_ID).toString();
                selects.add(new UiNameModel.SelectItem(value, desc));
            }
            list.add(new UiNameModel.AppItem(appName, logo, appDesc, selects));
        }
        return new UiNameModel("", list);
    }

    private String getToPlayMsg(String billName, Map<String, Object> commandParams) {
        try (EntityTraceSpan span = EntityTracer.create((String)"OpenBillServicePlugin", (String)"getToPlayMsg");){
            DynamicObject pluginDO = this.getVoiceTextPluginClassName(billName);
            if (pluginDO == null) {
                span.addTag(ResManager.loadKDString((String)"\u62a5\u8868\u672a\u5b9e\u73b0\u8bed\u97f3\u64ad\u62a5\u63d2\u4ef6\uff0c\u4f7f\u7528\u9ed8\u8ba4\u64ad\u62a5\u5185\u5bb9\u3002", (String)"OpenBillServicePlugin_15", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), billName);
                String string = billName + String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u60a8\u5448\u73b0", (String)"OpenBillServicePlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), new Object[0]);
                return string;
            }
            String className = pluginDO.getString("pluginclassname");
            String voiceTextTemplete = pluginDO.getString("voicetext");
            IUIVoiceText plugin = this.createVoiceTextPlugin(className);
            String string = this.fillValue(plugin, voiceTextTemplete, commandParams);
            return string;
        }
    }

    private DynamicObject getVoiceTextPluginClassName(String billName) {
        String entityName = "open_uivoiceconfig";
        QFilter[] filters = new QFilter[]{new QFilter("name", "=", (Object)billName)};
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)entityName, (String)"name,pluginclassname,voicetext", (QFilter[])filters);
        if (queryResult.isEmpty()) {
            return null;
        }
        return (DynamicObject)queryResult.get(0);
    }

    private IUIVoiceText createVoiceTextPlugin(String className) {
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                Class<?> pluginClass = Class.forName(className);
                Object pluginObj = pluginClass.newInstance();
                if (pluginObj instanceof IUIVoiceText) {
                    return (IUIVoiceText)pluginObj;
                }
                throw new KDException(new ErrorCode("###", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6%s\u7684class\u4e0d\u5b58\u5728\u3002", (String)OPENBILLSERVICEPLUGIN_6, (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), className)), new Object[0]);
            }
            catch (ClassNotFoundException e1) {
                throw new KDException((Throwable)e1, new ErrorCode("###", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6%s\u7684class\u4e0d\u5b58\u5728\u3002", (String)OPENBILLSERVICEPLUGIN_6, (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), className)), new Object[0]);
            }
            catch (InstantiationException e1) {
                throw new KDException((Throwable)e1, new ErrorCode("###", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6%s\u5b9e\u4f8b\u5316\u5931\u8d25\u3002", (String)"OpenBillServicePlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), className)), new Object[0]);
            }
            catch (IllegalAccessException e1) {
                throw new KDException((Throwable)e1, new ErrorCode("###", String.format(ResManager.loadKDString((String)"\u63d2\u4ef6%s\u7684\u5b9e\u4f8b\u65e0\u6cd5\u8bbf\u95ee\u3002", (String)"OpenBillServicePlugin_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), className)), new Object[0]);
            }
        }
        throw new KDException(new ErrorCode("###", ResManager.loadKDString((String)"\u63d2\u4ef6\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"OpenBillServicePlugin_10", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), new Object[0]);
    }

    private String fillValue(IUIVoiceText plugin, String voiceTextTemplete, Map<String, Object> commandParams) {
        if (voiceTextTemplete == null || voiceTextTemplete.isEmpty()) {
            throw new KDException(new ErrorCode("###", String.format(ResManager.loadKDString((String)"\u8bed\u97f3\u64ad\u62a5\u63d2\u4ef6\u6ca1\u6709\u914d\u7f6e\u201c\u8bed\u97f3\u64ad\u62a5\u6a21\u677f\u201d\u3002\u63d2\u4ef6\u540d\u79f0\uff1a%s\u3002", (String)"OpenBillServicePlugin_11", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), plugin.getClass().getName())), new Object[0]);
        }
        Map<String, String> voiceValue = plugin.getVoiceValue(commandParams);
        for (Map.Entry<String, String> entry : voiceValue.entrySet()) {
            voiceTextTemplete = voiceTextTemplete.replace("[" + entry.getKey() + "]", entry.getValue());
        }
        return voiceTextTemplete;
    }

    private Map<String, Object> fetchParams(Map<String, Object> commandParams) {
        if (commandParams.size() == 1) {
            return null;
        }
        HashMap<String, Object> para = new HashMap<String, Object>(commandParams.size() - 1);
        for (Map.Entry<String, Object> entry : commandParams.entrySet()) {
            if (PARAM_BILL_NAME.equals(entry.getKey())) continue;
            para.put(entry.getKey(), entry.getValue());
        }
        return para;
    }

    private String getNotFoundMsg(String billName) {
        if (billName == null) {
            return billName;
        }
        return String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u62a5\u8868\u6216\u5e94\u7528, \u540d\u79f0\u662f\u5426\u4e0d\u5bf9\uff1f", (String)"OpenBillServicePlugin_12", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), billName.replaceAll(SEPARATOR, ""));
    }

    private String getCannotOpenMsg(String billName) {
        if (billName == null) {
            return billName;
        }
        return String.format(ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u201c%s\u201d\u4e0d\u662f\u4e00\u4e2a\u53ef\u6253\u5f00\u7684\u83dc\u5355\u3002", (String)"OpenBillServicePlugin_13", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), billName.replaceAll(SEPARATOR, ""));
    }

    private String getAiTokenFromCache(String openId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String key = "aitoken_" + openId;
        return (String)cache.get(this.getType4Command(), key);
    }

    private String getType4Command() {
        return "ai_command";
    }

    public List<Map<String, Object>> getTargetFormInfos(String formName, String formId) {
        try (EntityTraceSpan span = EntityTracer.create((String)"OpenBillServicePlugin", (String)"getTargetFormInfos");){
            ArrayList<Map<String, Object>> formInfos = new ArrayList<Map<String, Object>>();
            QFilter[] filters = new QFilter[]{StringUtils.isBlank((CharSequence)formId) ? new QFilter("name", "like", (Object)("%" + formName + "%")) : new QFilter("number", "=", (Object)formId)};
            long dbStart = System.currentTimeMillis();
            Map bizObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,bizappid,name", (QFilter[])filters);
            long dbEnd = System.currentTimeMillis();
            span.addLocaleTag("load bos_formmeta", (Object)(dbEnd - dbStart));
            Object[] bizAppIds = bizObjMap.values().stream().map(dyn -> dyn.get("bizappid")).distinct().toArray();
            long dbStart1 = System.currentTimeMillis();
            Map bizappMap = BusinessDataServiceHelper.loadFromCache((Object[])bizAppIds, (String)"bos_devportal_bizapp");
            long dbEnd1 = System.currentTimeMillis();
            span.addLocaleTag("load bizAppIds:", (Object)(dbEnd1 - dbStart1));
            boolean isPerfectMatchName = false;
            long menuInfoCost = 0L;
            for (Map.Entry fid2FormEntry : bizObjMap.entrySet()) {
                HashMap<String, Object> targetFormInfos = new HashMap<String, Object>();
                DynamicObject formObj = (DynamicObject)fid2FormEntry.getValue();
                DynamicObject bizAppObj = (DynamicObject)bizappMap.get(formObj.get("bizappid"));
                if (bizAppObj == null) continue;
                targetFormInfos.put("bizappId", bizAppObj.getPkValue());
                targetFormInfos.put(APPDESC, bizAppObj.getLocaleString("description").getLocaleValue());
                targetFormInfos.put("logo", bizAppObj.get("image"));
                targetFormInfos.put(APPNAME, bizAppObj.getLocaleString("name").getLocaleValue());
                if (formName.equals(bizAppObj.getLocaleString("name").getLocaleValue())) {
                    formInfos.clear();
                    formInfos.add(targetFormInfos);
                    break;
                }
                targetFormInfos.put("id", fid2FormEntry.getKey());
                targetFormInfos.put(FORM_ID, formObj.get("number"));
                targetFormInfos.put("name", formObj.get("name").toString());
                if (formName.equals(formObj.get("name").toString())) {
                    isPerfectMatchName = true;
                }
                long mStart = System.currentTimeMillis();
                MenuInfo menuInfo = this.getMenuInfoByFormFId(fid2FormEntry.getKey().toString());
                long mEnd = System.currentTimeMillis();
                menuInfoCost += mEnd - mStart;
                if (menuInfo != null) {
                    targetFormInfos.put("menuId", menuInfo.getMenu().getId());
                    targetFormInfos.put("bizappId", menuInfo.getAppFid());
                }
                formInfos.add(targetFormInfos);
            }
            span.addLocaleTag("getMenuInfo size", (Object)bizObjMap.size());
            span.addLocaleTag("getMenuInfo", (Object)menuInfoCost);
            span.addLocaleTag(ResManager.loadKDString((String)"\u6253\u5f00\u5355\u636e\u5982\u4e0b\uff1a", (String)"OpenBillServicePlugin_17", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), (Object)SerializationUtils.toJsonString(formInfos));
            if (isPerfectMatchName) {
                this.removeNoPerfectMatchItem(formName, formInfos);
            }
            ArrayList<Map<String, Object>> arrayList = formInfos;
            return arrayList;
        }
    }

    protected void removeNoPerfectMatchItem(String formName, List<Map<String, Object>> formInfos) {
        boolean containMenuId = false;
        Iterator<Map<String, Object>> it = formInfos.iterator();
        ArrayList<String> message = new ArrayList<String>(formInfos.size());
        while (it.hasNext()) {
            Map<String, Object> formObj = it.next();
            if (!formName.equals(formObj.get("name"))) {
                message.add(SerializationUtils.toJsonString(formObj));
                it.remove();
                continue;
            }
            if (formObj.get("menuId") == null) continue;
            containMenuId = true;
        }
        if (!message.isEmpty()) {
            logger.info("\u5728\u51c6\u786e\u5339\u914d\u540d\u79f0\u4e2d\u56e0\u540d\u5b57\u4e0d\u80fd\u5b8c\u5168\u5339\u914d\uff0c\u5220\u9664 " + message);
        }
        if (containMenuId) {
            ArrayList<String> message1 = new ArrayList<String>(formInfos.size());
            it = formInfos.iterator();
            while (it.hasNext()) {
                Map<String, Object> formObj = it.next();
                if (!StringUtils.isBlank((Object)formObj.get("menuId"))) continue;
                message1.add(SerializationUtils.toJsonString(formObj));
                it.remove();
            }
            if (!message1.isEmpty()) {
                logger.info("\u5728\u51c6\u786e\u5339\u914d\u540d\u79f0\u4e2d\u56e0\u540d\u5b57\u4e0d\u80fd\u5b8c\u5168\u5339\u914d\uff0c\u5220\u9664 " + message1);
            }
        }
    }

    private MenuInfo getMenuInfoByFormFId(String fid) {
        try (EntityTraceSpan span = EntityTracer.create((String)"OpenBillServicePlugin", (String)"getMenuInfoByFormFId");){
            long start = System.currentTimeMillis();
            List<AppMetadata> appMetas = this.getAllAppMetadatas();
            long end = System.currentTimeMillis();
            span.addLocaleTag("getAllAppMetadatas", (Object)(end - start));
            MenuInfo menuInfo = null;
            for (AppMetadata appMetadata : appMetas) {
                List appMenus = appMetadata.getAppMenus();
                for (AppMenuElement appMenuElement : appMenus) {
                    if (!Objects.equals(appMenuElement.getFormId(), fid)) continue;
                    menuInfo = new MenuInfo(appMenuElement, appMetadata.getId());
                    if (!"ListShowParameter".equals(appMenuElement.getParameterType())) continue;
                    MenuInfo menuInfo2 = menuInfo;
                    return menuInfo2;
                }
            }
            Iterator<AppMetadata> iterator = menuInfo;
            return iterator;
        }
    }

    private class MenuInfo {
        AppMenuElement menu;
        String appFid;

        MenuInfo(AppMenuElement menu, String appFid) {
            this.menu = menu;
            this.appFid = appFid;
        }

        public AppMenuElement getMenu() {
            return this.menu;
        }

        public String getAppFid() {
            return this.appFid;
        }
    }
}

