/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.plugin;

import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.util.AICommandUtil;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LogoutPlugin
extends AbstractBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(LogoutPlugin.class);

    public void doAICommand(AICommandEvent e) {
        RequestContext rc = RequestContext.get();
        String sessionId = this.getAiSessionFromCache(rc.getUserOpenId());
        if (sessionId == null || sessionId.isEmpty()) {
            sessionId = rc.getGlobalSessionId();
        }
        AICommandUtil.sendLogoffCommand(sessionId);
        ApiResult ret = new ApiResult();
        ret.setSuccess(true);
        ResponseModel data = ResponseModel.createTextResponse(ResManager.loadKDString((String)"\u597d\u7684\uff0c\u90a3\u6211\u9000\u4e0b\u4e86!", (String)"LogoutPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        ret.setData((Object)data);
        e.setResult(ret);
        this.removeAiTokenCache(rc.getUserOpenId());
    }

    private String getAiSessionFromCache(String openId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String key = "aitoken_" + openId;
        return (String)cache.get(this.getType4Command(), key);
    }

    private void removeAiTokenCache(String openId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String key = "aitoken_" + openId;
        cache.remove(this.getType4Command(), key);
        logger.info("removeAiTokenCache, openId=" + openId);
    }

    private String getType4Command() {
        return "ai_command";
    }
}

