/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.plugin;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.SelectsModel;
import kd.bos.ai.model.UrlModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.AICommand;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.qing.util.QingFormUtil;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class QingCardPlugin
extends AbstractBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(QingCardPlugin.class);
    private static String CARD_URL = "/qing/cardEntrance.do?isMobile=true";

    public void doAICommand(AICommandEvent e) {
        AICommand command = e.getCommand();
        Map commandParams = command.getParameter();
        String cardName = (String)commandParams.get("filter");
        String cardId = (String)commandParams.get("cardId");
        StringBuilder info = new StringBuilder();
        try {
            if (StringUtils.isNotEmpty((CharSequence)cardId)) {
                info.append("commandParams from chatbot,cardId=").append(cardId);
                byte[] rs = this.loadCardInfo(cardId);
                this.setUrlModelResult(rs, e, info);
            } else {
                info.append("commandParams from chatbot,cardName=").append(cardName);
                byte[] rs = this.getCardInfoByName(cardName);
                this.setSelectModelResult(rs, e, cardName, info);
            }
        }
        catch (Throwable ex) {
            logger.error(ex);
        }
        logger.info(info.toString());
    }

    private byte[] loadCardInfo(String publishId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("publishId", publishId);
        byte[] result = (byte[])DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"loadCardInfo", (Object[])new Object[]{params});
        return result;
    }

    private byte[] getCardInfoByName(String cardName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cardName", cardName);
        byte[] result = (byte[])DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"loadCardInfoByName", (Object[])new Object[]{params});
        return result;
    }

    private void setUrlModelResult(byte[] byteArrRs, AICommandEvent e, StringBuilder info) throws IOException {
        String stringRs = new String(byteArrRs, Charset.forName("utf-8"));
        Map rsData = (Map)JSONUtils.cast((String)stringRs, Map.class);
        Map rsMap = (Map)rsData.get("data");
        String cardName = (String)rsMap.get("name");
        String cardId = (String)rsMap.get("id");
        info.append(", get qing card url success cardName=").append(cardName).append(" cardId=").append(cardId);
        e.getResult().setData((Object)ResponseModel.createUrlResponse(this.getUrlModel(cardId, cardName)));
    }

    private void setSelectModelResult(byte[] byteArrRs, AICommandEvent e, String requestCardName, StringBuilder info) throws IOException {
        String stringRs = new String(byteArrRs, Charset.forName("utf-8"));
        Map rsData = (Map)JSONUtils.cast((String)stringRs, Map.class);
        Map rsMap = (Map)rsData.get("data");
        ResponseModel responseModel = null;
        if (rsMap.size() == 0) {
            info.append(", get qing card info empty, cardName=").append(requestCardName);
            responseModel = ResponseModel.createTextResponse(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u60a8\u8bf4\u7684%s", (String)"QingCardPlugin_0", (String)"bos-form-business", (Object[])new Object[0]), requestCardName));
        } else {
            info.append(", get qing card info success");
            ArrayList<SelectsModel.SelectItem> items = new ArrayList<SelectsModel.SelectItem>(10);
            for (Map.Entry entry : rsMap.entrySet()) {
                String key = (String)entry.getKey();
                SelectsModel.SelectItem item = new SelectsModel.SelectItem(key, (String)entry.getValue());
                items.add(item);
                info.append(", cardID=").append(key).append(" cardName=").append((String)rsMap.get(key));
            }
            SelectsModel selectModel = new SelectsModel("qingCard", items);
            responseModel = ResponseModel.createSelectsResponse(selectModel);
        }
        e.getResult().setData((Object)responseModel);
    }

    private UrlModel getUrlModel(String cardId, String cardName) {
        UrlModel urlModel = new UrlModel();
        urlModel.setTitle(cardName);
        urlModel.setUrl(this.getQingCardUrl(cardName, cardId));
        urlModel.setIframe(true);
        return urlModel;
    }

    private String getQingCardUrl(String cardName, String cardId) {
        String sUrl = CARD_URL;
        String cookieValue = RequestContext.get().getGlobalSessionId();
        try {
            sUrl = QingFormUtil.appendParamToUrl((String)sUrl, (String)"cardName", (String)cardName);
            sUrl = QingFormUtil.appendParamToUrl((String)sUrl, (String)"publishId", (String)cardId);
            sUrl = EncreptSessionUtils.encryptAcessToken((String)sUrl, (String)cookieValue);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
        }
        return sUrl;
    }
}

