/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.plugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.util.JsonUtil;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.util.StringUtils;

public class VoiceprintLoginPlugin
extends AbstractBillWebApiPlugin {
    private Log logger = LogFactory.getLog(VoiceprintLoginPlugin.class);
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private Map<Character, Character> arabic2CnNumMap = new HashMap<Character, Character>();

    public VoiceprintLoginPlugin() {
        this.init();
    }

    private void init() {
        this.arabic2CnNumMap.put(Character.valueOf('0'), Character.valueOf('\u96f6'));
        this.arabic2CnNumMap.put(Character.valueOf('1'), Character.valueOf('\u4e00'));
        this.arabic2CnNumMap.put(Character.valueOf('2'), Character.valueOf('\u4e8c'));
        this.arabic2CnNumMap.put(Character.valueOf('3'), Character.valueOf('\u4e09'));
        this.arabic2CnNumMap.put(Character.valueOf('4'), Character.valueOf('\u56db'));
        this.arabic2CnNumMap.put(Character.valueOf('5'), Character.valueOf('\u4e94'));
        this.arabic2CnNumMap.put(Character.valueOf('6'), Character.valueOf('\u516d'));
        this.arabic2CnNumMap.put(Character.valueOf('7'), Character.valueOf('\u4e03'));
        this.arabic2CnNumMap.put(Character.valueOf('8'), Character.valueOf('\u516b'));
        this.arabic2CnNumMap.put(Character.valueOf('9'), Character.valueOf('\u4e5d'));
    }

    public void doAICommand(AICommandEvent e) {
        AICommand cmd = e.getCommand();
        String openId = cmd.getOpenId();
        Map commandParams = cmd.getParameter();
        Object tokenObj = commandParams.get("token");
        String token = tokenObj.toString();
        AIResponseModel aiResponseModel = this.toVoiceLogin(openId, token);
        ApiResult ret = new ApiResult();
        ret.setSuccess(true);
        String msg = JsonUtil.encodeToString(aiResponseModel);
        ResponseModel data = ResponseModel.createTextResponse(msg);
        ret.setData((Object)data);
        e.setResult(ret);
        this.logger.info("parameter: " + commandParams + ", ApiResult: " + ret);
    }

    private AIResponseModel toVoiceLogin(String openId, String token) {
        AIResponseModel sessionResult = this.generateSessionId(openId, token);
        if (!sessionResult.isSuccess()) {
            return sessionResult;
        }
        String sSessionId = (String)sessionResult.getData();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("sessionid", sSessionId);
        result.put("userid", openId);
        result.put("username", this.getUser(openId));
        this.putAiTokenToCache(openId, sSessionId);
        return new AIResponseModel(true, result);
    }

    private String getTokenSessionId(String token) {
        String type = CacheLoginData.getType4AILoginSession((String)token);
        Map session = CacheLoginData.getCache((String)type);
        if (session != null) {
            return (String)session.get("sessionid");
        }
        return "";
    }

    private long getLoginTimeOut() {
        String key = "ai.voice.login.timeout";
        String value = System.getProperty(key);
        if (value == null || value.isEmpty()) {
            value = "3000";
            this.logger.info(String.format("\u58f0\u7eb9\u767b\u5f55\u7684\u8d85\u65f6\u65f6\u95f4\u6ca1\u6709\u914d\u7f6e\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c%s, key=%s", value, key));
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return 3000L;
        }
    }

    private AIResponseModel generateSessionId(String userId, String token) {
        AIResponseModel resultModel = this.AICallbackByDarwin(userId, token, "voice");
        if (!resultModel.isSuccess()) {
            return resultModel;
        }
        String sSessionId = "";
        long iLoginTimeOut = this.getLoginTimeOut();
        long waitTime = 200L;
        long timeStart = System.currentTimeMillis();
        while (true) {
            long timeEnd;
            if ((timeEnd = System.currentTimeMillis()) - timeStart > iLoginTimeOut) {
                this.logger.info(String.format("\u767b\u5f55\u8d85\u65f6, waiting time is %s ms", iLoginTimeOut));
                return new AIResponseModel(false, ResManager.loadKDString((String)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u8bfb\u51fa\u5c4f\u5e55\u53e3\u4ee4", (String)"VoiceprintLoginPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            sSessionId = this.getTokenSessionId(token);
            if (sSessionId != null && !sSessionId.isEmpty()) break;
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                this.logger.error("voiceprint login occur an InterruptedException!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return new AIResponseModel(true, sSessionId);
    }

    private static boolean isEffectiveToken(String token) {
        return CacheLoginData.isEffectiveToken((String)token);
    }

    public AIResponseModel AICallbackByDarwin(String userId, String token, String loginType) {
        boolean isSuccess;
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)token)) {
            String msg = StringUtils.isEmpty((String)userId) ? ResManager.loadKDString((String)"\u7528\u6237id\u4e3a\u7a7a", (String)"VoiceprintLoginPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u52a8\u6001\u53e3\u4ee4\u4e3a\u7a7a", (String)"VoiceprintLoginPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            this.logger.info(msg);
            return new AIResponseModel(false, msg);
        }
        this.logger.info(String.format("@AI....\u56de\u8c03\u6210\u529f:%s ", userId));
        if ("voice".equals(loginType) && !(isSuccess = VoiceprintLoginPlugin.isEffectiveToken(token))) {
            this.logger.info("\u52a8\u6001\u53e3\u4ee4\u65e0\u6548");
            if (token.length() > 8) {
                token = token.substring(0, 8);
            }
            return new AIResponseModel(isSuccess, String.format(ResManager.loadKDString((String)"\u52a8\u6001\u53e3\u4ee4%s\u65e0\u6548", (String)"VoiceprintLoginPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), this.digitString2ChineseNumberString(token)));
        }
        HashMap<String, String> mpVoiceCache = new HashMap<String, String>();
        mpVoiceCache.put("userId", userId);
        mpVoiceCache.put("accountId", RequestContext.get().getAccountId());
        mpVoiceCache.put("tenantId", RequestContext.get().getTenantId());
        String cacheType = CacheLoginData.getType4AILogin((String)token);
        CacheLoginData.setAttributes((String)cacheType, mpVoiceCache);
        this.logger.info(String.format("@AI....\u56de\u8c03\u540e\u7f13\u5b58\u6210\u529f:%s ", userId));
        return new AIResponseModel(true, null);
    }

    private String getUser(String openId) {
        if (openId == null || openId.isEmpty()) {
            return "";
        }
        RequestContext requestContext = RequestContext.get();
        return requestContext.getUserName();
    }

    private void putAiTokenToCache(String openId, String session) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String key = "aitoken_" + openId;
        cache.put(this.getType4Command(), key, session, 3600);
    }

    private String getType4Command() {
        return "ai_command";
    }

    public String digitString2ChineseNumberString(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        for (Map.Entry<Character, Character> e : this.arabic2CnNumMap.entrySet()) {
            text = text.replace(e.getKey().charValue(), e.getValue().charValue());
        }
        return text;
    }

    public static class AIResponseModel {
        private boolean success;
        private Object data;

        public AIResponseModel(boolean success, Object data) {
            this.success = success;
            this.data = data;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

