/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.ai.model.AICommandType;
import kd.bos.ai.model.CommandModel;
import kd.bos.ai.util.JsonUtil;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AICommandUtil {
    private static Log logger = LogFactory.getLog(AICommandUtil.class);
    private static final String COMMAND = "command";
    private static final String AITOKEN = "aitoken";

    public static boolean sendShowVoiceMsgCommand(String clientId, String msg) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        CommandModel command = new CommandModel();
        command.setType(AICommandType.SHOW_VOICE_MSG.getCommand());
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("msg", msg);
        command.setPara(para);
        data.put(COMMAND, command);
        data.put(AITOKEN, clientId);
        return AICommandUtil.sendAICommand(data);
    }

    public static boolean sendCloseVoiceMsgCommand(String clientId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        CommandModel command = new CommandModel();
        command.setType(AICommandType.CLOSE_VOICE_MSG.getCommand());
        data.put(COMMAND, command);
        data.put(AITOKEN, clientId);
        return AICommandUtil.sendAICommand(data);
    }

    public static boolean sendOpenMenuCommand(String clientId, CommandModel command) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(COMMAND, command);
        data.put(AITOKEN, clientId);
        return AICommandUtil.sendAICommand(data);
    }

    public static boolean sendCloseMenuCommand(String clientId, String cmdId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        CommandModel command = new CommandModel();
        command.setType(AICommandType.CLOSE_MENU.getCommand());
        command.setCmdId(cmdId);
        data.put(COMMAND, command);
        data.put(AITOKEN, clientId);
        return AICommandUtil.sendAICommand(data);
    }

    public static boolean sendLogoffCommand(String SessionId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        CommandModel command = new CommandModel();
        command.setType(AICommandType.LOGOFF.getCommand());
        command.setCmdId(SessionId);
        data.put(COMMAND, command);
        data.put(AITOKEN, SessionId);
        return AICommandUtil.sendAICommand(data);
    }

    public static boolean sendAICommand(Map<String, Object> data) {
        return AICommandUtil.sendAICommand(AICommandUtil.getAICommandFullUrl(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendAICommand(String url, Map<String, Object> data) {
        StringBuilder info = new StringBuilder();
        info.append("url:").append(url);
        ApiResult result = null;
        try (ApiClient client = ApiClientFactory.getInternal();){
            ApiRequest request = new ApiRequest("get", url);
            if (data != null) {
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    Object value = entry.getValue();
                    String valueString = value instanceof String ? (String)value : JsonUtil.encodeToString(entry.getValue());
                    request.addParameter(entry.getKey(), valueString);
                }
            }
            info.append(", sendAICommand(), url=").append(url);
            info.append(", parameters=").append(request.getParameters());
            long start = System.currentTimeMillis();
            result = client.execute(request);
            long end = System.currentTimeMillis();
            info.append(", take time:").append(end - start);
            logger.info(info.toString());
            if (result.isOk()) {
                String resultData = result.getData();
                boolean bl = "sucess".equals(resultData) || "success".equals(resultData);
                return bl;
            }
        }
        return false;
    }

    private static String getAICommandFullUrl() {
        String rootPath = AICommandUtil.getFullContextPath();
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        return rootPath + AICommandUtil.getAICommandUrl();
    }

    private static String getAICommandUrl() {
        return "form/pushAICommand.do";
    }

    private static String getFullContextPath() {
        return RequestContext.get().getClientFullContextPath();
    }
}

