/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.isvconfig.plugin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Hyperlink;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.attach.IAttachmentPanel;
import kd.bos.mvc.cache.PageCache;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.session.EncreptSessionUtils;

public class IsvImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log logger = LogFactory.getLog(IsvImportPlugin.class);
    private static String isvUpgradeUrl = "https://vip.kingdee.com/knowledge/specialDetail/218022218066869248?category=218025874795916544&id=419127002101266176&productLineId=29";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IAttachmentPanel attachmentPanel = (IAttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject obj = (DynamicObject)this.getModel().getDataEntityType().createInstance();
        obj.set("textfield", (Object)ResManager.loadKDString((String)"\u5f00\u53d1\u6388\u6743\u7801\u662f\u7528\u4ee5\u8bc6\u522b\u5f00\u53d1\u5546\u8eab\u4efd\u7684\u91cd\u8981\u51ed\u8bc1\uff0c\u662f\u5176\u6240\u5f00\u53d1\u4ea7\u54c1\u80fd\u5426\u901a\u8fc7\u91d1\u8776\u8ba4\u8bc1\u7684\u5fc5\u5907\u6761\u4ef6\uff0c\u5f00\u53d1\u8fc7\u7a0b\u4e2d\u9700\u8981\u7528\u5230\uff0c\u4e14\u540e\u7eed\u4e0d\u80fd\u4fee\u6539\u3002", (String)"IsvImportPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
        obj.set("textfield1", (Object)ResManager.loadKDString((String)"\u82e5\u5176\u6240\u5f00\u53d1\u7684\u4ea7\u54c1\u540e\u7eed\u9700\u8981\u901a\u8fc7\u91d1\u8776\u5e73\u53f0\u8fdb\u884c\u5546\u4e1a\u53d1\u5e03\u5219\u5fc5\u987b\u6b63\u786e\u521d\u59cb\u5316\u3002", (String)"IsvImportPlugin_2", (String)"bos-form-business", (Object[])new Object[0]));
        obj.set("textfield2", (Object)ResManager.loadKDString((String)"2.\u5f00\u53d1\u5546\u8d44\u8d28\u6587\u4ef6\u8bf7\u5230", (String)"IsvImportPlugin_3", (String)"bos-form-business", (Object[])new Object[0]));
        obj.set("textfield3", (Object)ResManager.loadKDString((String)"\u7533\u8bf7\u4e0b\u8f7d\uff0c\u5e2e\u52a9\u6587\u6863\u8bf7\u53c2\u9605", (String)"IsvImportPlugin_4", (String)"bos-form-business", (Object[])new Object[0]));
        obj.set("textfield4", (Object)ResManager.loadKDString((String)"\u901a\u8fc7\u6587\u4ef6\u9a8c\u8bc1\u5f00\u53d1\u5546\u8d44\u8d28", (String)"IsvImportPlugin_5", (String)"bos-form-business", (Object[])new Object[0]));
        obj.set("textfield5", (Object)ResManager.loadKDString((String)"\u901a\u8fc7\u6388\u6743\u7801\u9a8c\u8bc1\u5f00\u53d1\u5546\u8d44\u8d28", (String)"IsvImportPlugin_6", (String)"bos-form-business", (Object[])new Object[0]));
        String locale = "zh-CN";
        Lang lang = Lang.get();
        if (Lang.zh_CN != lang && Lang.zh_TW != lang) {
            locale = "en-US";
        }
        Hyperlink isvUpgradeHyperLink = (Hyperlink)this.getControl("hyperlinkap111");
        isvUpgradeHyperLink.setUrl(isvUpgradeUrl + "&lang=" + locale);
        obj.set("radiogroupfield", (Object)0);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"textareafield"});
        e.setDataEntity((Object)obj);
        ISVInfo isv = null;
        try {
            isv = ISVServiceHelper.getISVInfo();
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"textfieldisv1"});
        if (isv != null && StringUtils.isNotBlank((CharSequence)isv.getId())) {
            obj.set("textfieldisv1", (Object)isv.getId());
        }
    }

    public void afterBindData(EventObject e) {
        if (!PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok", "buttonreg", "attachmentpanelap"});
            this.getView().setStatus(OperationStatus.VIEW);
            Button btnok = (Button)this.getView().getControl("btnok");
            Tips tips = new Tips("text", null, new LocaleString("zh_CN", ResManager.loadKDString((String)"\u8bf7\u4f7f\u7528\u6709\u7ba1\u7406\u5458\u6743\u9650\u7684\u7528\u6237\u4e0a\u4f20\u6216\u8005\u7528administrator\u5728\u5f00\u53d1\u670d\u52a1\u4e91\u4e0a\u4f20\u3002", (String)"IsvImportPlugin_7", (String)"bos-form-business", (Object[])new Object[0])), false, null);
            tips.setPlace("right");
            btnok.addTips(tips);
        }
        this.setFlexPanelApVi("flexpanelapfile", "flexpanelapcode");
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            Map urlObj = (Map)urls[0];
            String url = (String)urlObj.get("url");
            String jsonStr = this.download(url);
            PageCache cache = (PageCache)this.getView().getPageCache();
            cache.put("isvLicense", jsonStr);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equals(btn.getKey())) {
            String type = (String)this.getModel().getValue("radiogroupfield");
            String isvLicense = "";
            if ("0".equals(type)) {
                PageCache cache = (PageCache)this.getView().getPageCache();
                isvLicense = cache.get("isvLicense");
                if (StringUtils.isBlank((CharSequence)isvLicense)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u5f00\u53d1\u5546\u8d44\u8d28\u6587\u4ef6\u3002", (String)"IsvImportPlugin_8", (String)"bos-form-business", (Object[])new Object[0]));
                    return;
                }
            } else {
                isvLicense = (String)this.getModel().getValue("textareafield");
                if (StringUtils.isBlank((CharSequence)isvLicense)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u53d1\u5546\u6388\u6743\u7801\u3002", (String)"IsvImportPlugin_9", (String)"bos-form-business", (Object[])new Object[0]));
                    return;
                }
            }
            this.save(isvLicense);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("radiogroupfield".equals(e.getProperty().getName())) {
            String type = (String)this.getModel().getValue("radiogroupfield");
            this.changeImportType(type);
            if ("0".equals(type)) {
                this.setFlexPanelApVi("flexpanelapfile", "flexpanelapcode");
            } else {
                this.setFlexPanelApVi("flexpanelapcode", "flexpanelapfile");
            }
        }
    }

    private void setFlexPanelApVi(String flexPanelAp1, String flexPanelAp2) {
        HashMap<String, Integer> flexPanelAp1Vi = new HashMap<String, Integer>(1);
        flexPanelAp1Vi.put("vi", 63);
        this.getView().updateControlMetadata(flexPanelAp1, flexPanelAp1Vi);
        HashMap<String, Integer> flexPanelAp2Vi = new HashMap<String, Integer>(1);
        flexPanelAp2Vi.put("vi", 0);
        this.getView().updateControlMetadata(flexPanelAp2, flexPanelAp2Vi);
    }

    public void confirmCallBack(MessageBoxClosedEvent ce) {
        if ("rebuildIsvCallBack".equals(ce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)ce.getResult())) {
            String isvInfoStr = this.getPageCache().get("isvInfo");
            if (StringUtils.isBlank((CharSequence)isvInfoStr)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"pageCache\u4f20\u9012\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\u5220\u9664\u91cd\u5efa", (String)"IsvImportPlugin_10", (String)"bos-form-business", (Object[])new Object[0])});
            }
            this.delIsv();
            ISVInfo isvInfo = (ISVInfo)SerializationUtils.fromJsonString((String)isvInfoStr, ISVInfo.class);
            this.doSave(isvInfo);
        }
    }

    private void save(String isvLicense) {
        Map isvObj = null;
        String type = (String)this.getModel().getValue("radiogroupfield");
        try {
            isvObj = ISVService.decode((String)isvLicense);
        }
        catch (Exception e) {
            if ("0".equals(type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u8d28\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"IsvImportPlugin_11", (String)"bos-form-business", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u6743\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"IsvImportPlugin_12", (String)"bos-form-business", (Object[])new Object[0]));
            }
            return;
        }
        String isv = (String)isvObj.get("isv");
        boolean hasUpper = Pattern.matches("^[a-z][a-z0-9]{0,3}$", isv);
        if (!("kingdee".equals(isv) || "kdtest".equals(isv) || hasUpper)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f00\u53d1\u5546\u6807\u8bc6\u5fc5\u987b\u4f7f\u7528\u5c0f\u5199\u5b57\u6bcd\u6216\u6570\u5b57\u5e76\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc74\u4f4d\u3002", (String)"IsvImportPlugin_13", (String)"bos-form-business", (Object[])new Object[0]));
            return;
        }
        String isvId = String.valueOf(isvObj.get("isVid"));
        String isvType = (String)isvObj.get("type");
        ISVInfo isvInfo = new ISVInfo();
        isvInfo.setId(isv);
        isvInfo.setName(isv);
        isvInfo.setType(isvType);
        isvInfo.setIsvId(isvId);
        isvInfo.setSign(isvLicense);
        if (this.existIsv()) {
            this.getPageCache().put("isvInfo", SerializationUtils.toJsonString((Object)isvInfo));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f00\u53d1\u5546\u6807\u8bc6\uff0c\u5220\u9664\u91cd\u5efa\u4f1a\u5bfc\u81f4\u539f\u5f00\u53d1\u5546\u6807\u8bc6\u7684\u6570\u636e\u4e0d\u80fd\u66f4\u6539\uff0c\u786e\u8ba4\u9700\u8981\u5220\u9664\u91cd\u5efa\u5f00\u53d1\u5546\u6807\u8bc6\u5417\uff1f", (String)"IsvImportPlugin_14", (String)"bos-form-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("rebuildIsvCallBack"));
        } else {
            this.doSave(isvInfo);
        }
    }

    private boolean existIsv() {
        String isvId = (String)DB.query((DBRoute)DBRoute.meta, (String)"select FISVID from T_BAS_ISV", (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String isv = null;
                if (rs.next()) {
                    isv = rs.getString(1);
                }
                return isv;
            }
        });
        return StringUtils.isNotBlank((CharSequence)isvId);
    }

    private void doSave(ISVInfo isvInfo) {
        if (ISVService.save((ISVInfo)isvInfo)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"IsvImportPlugin_15", (String)"bos-form-business", (Object[])new Object[0]));
            this.getView().getModel().setValue("textfieldisv1", (Object)isvInfo.getId());
            this.getPageCache().put("returndata", "1");
            this.writeLog();
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6709\u5f00\u53d1\u5546\u6807\u8bc6\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"IsvImportPlugin_16", (String)"bos-form-business", (Object[])new Object[0]));
        }
    }

    private void writeLog() {
        OpLogAppInfo logAppInfo = this.buildOpLogAppInfo();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logService.addLog((AppLogInfo)logAppInfo);
    }

    private OpLogAppInfo buildOpLogAppInfo() {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String formId = this.getView().getFormShowParameter().getFormId();
        String bizAppId = BizAppServiceHelp.getAppIdByAppNumber((String)"sys");
        logInfo.setBizAppID(bizAppId);
        logInfo.setBizObjID(formId);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        MultiLangEnumBridge bridge = new MultiLangEnumBridge("\u4fdd\u5b58", "IsvImportPlugin_19", "bos-form-business");
        logInfo.setOpName("save", bridge);
        logInfo.setStatus("1");
        logInfo.setKeyWord(formId);
        return logInfo;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String data = this.getPageCache().get("returndata");
        if (StringUtils.isNotBlank((CharSequence)data)) {
            this.getView().returnDataToParent((Object)data);
        }
    }

    private void delIsv() {
        DB.execute((DBRoute)DBRoute.meta, (String)"delete from T_BAS_ISV");
        DB.execute((DBRoute)DBRoute.basedata, (String)"delete from T_BAS_USERCONFIG where FKEY = 'bos_isv_register'");
    }

    private String download(String url) {
        String jsonStr = "";
        if (url != null) {
            url = EncreptSessionUtils.encryptSession((String)url);
            TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
            try (InputStream in = downLoad.getInputStream(url);
                 ByteArrayOutputStream os = new ByteArrayOutputStream();){
                byte[] buffer = new byte[512];
                int length = 0;
                while ((length = in.read(buffer)) != -1) {
                    os.write(buffer, 0, length);
                }
                jsonStr = new String(os.toByteArray(), "UTF-8");
            }
            catch (IOException e) {
                throw new KDException(BosErrorCode.bOS, ResManager.loadKDString((String)"\u8d44\u8d28\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", (String)"IsvImportPlugin_17", (String)"bos-form-business", (Object[])new Object[0]), e.getCause());
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.bOS, ResManager.loadKDString((String)"\u8d44\u8d28\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (String)"IsvImportPlugin_18", (String)"bos-form-business", (Object[])new Object[0]), e.getCause());
            }
        }
        return jsonStr;
    }

    private void changeImportType(String type) {
        if ("0".equals(type)) {
            this.getModel().setValue("radiogroupfield", (Object)0);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"textareafield"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"attachmentpanelap"});
        } else {
            this.getModel().setValue("radiogroupfield", (Object)1);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentpanelap"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"textareafield"});
        }
    }
}

