/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.isvconfig.plugin;

import java.sql.ResultSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class IsvRegisterPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_RADIOGROUPFIELD = "radiogroupfield";
    private static final String KEY_TEXTFIELDISV1 = "textfieldisv1";
    private static final String KEY_TEXTFIELDISV2 = "textfieldisv2";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String KEY_BUTTONREG = "buttonreg";

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void createNewData(BizDataEventArgs e) {
        ISVInfo isv = ISVServiceHelper.getISVInfo();
        if (isv != null && StringUtils.isNotBlank((CharSequence)isv.getId())) {
            DynamicObject obj = (DynamicObject)this.getModel().getDataEntityType().createInstance();
            String type = "1";
            if (StringUtils.isNotBlank((CharSequence)isv.getType())) {
                type = isv.getType();
            }
            obj.set(KEY_RADIOGROUPFIELD, (Object)type);
            if ("1".equals(type)) {
                obj.set(KEY_TEXTFIELDISV1, (Object)isv.getId());
            } else {
                obj.set(KEY_TEXTFIELDISV2, (Object)isv.getId());
            }
            e.setDataEntity((Object)obj);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject obj = this.getModel().getDataEntity();
        String s1 = String.format(ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u5f00\u53d1\u6388\u6743\u7801\u662f\u7528\u4ee5\u8bc6\u522b\u5f00\u53d1\u5546\u8eab\u4efd\u7684\u91cd\u8981\u51ed\u8bc1\uff0c\u662f\u5176\u6240\u5f00\u53d1\u4ea7\u54c1\u80fd\u5426\u901a\u8fc7\u91d1\u8776\u8ba4\u8bc1\u7684\u5fc5\u5907\u6761\u4ef6\uff0c\u5f00\u53d1\u8fc7\u7a0b\u4e2d\u9700\u8981\u7528\u5230\uff0c\u4e14\u540e\u7eed\u4e0d\u80fd\u4fee\u6539\u3002\u82e5\u5176\u6240\u5f00\u53d1\u7684\u4ea7\u54c1\u540e\u7eed\u9700\u8981\u901a\u8fc7\u91d1\u8776\u5e73\u53f0\u8fdb\u884c\u5546\u4e1a\u53d1\u5e03\u5219\u5fc5\u987b\u6b63\u786e\u521d\u59cb\u5316\uff0c\u5bf9\u4e8e\u5b66\u4e60\u7814\u7a76\u3001\u4f01\u4e1a\u5185\u90e8\u4f7f\u7528\u3001\u9879\u76ee\u4ea4\u4ed8\u7b49\u5f00\u53d1\u5219\u4e0d\u53d7\u6b64\u9650\u5236\u3002\u5f00\u53d1\u6388\u6743\u7801\u89c4\u5219\uff1a\u7531\u5c0f\u5199\u5b57\u6bcd\u6216\u6570\u5b57\u7ec4\u6210\u5e76\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u957f\u5ea6\u4e0d\u8d85\u8fc74\u4f4d\u3002", (String)"IsvRegisterPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), new Object[0]);
        obj.set("textareafield", (Object)s1);
        String s2 = String.format(ResManager.loadKDString((String)"\u624b\u5de5\u8f93\u5165\u9002\u7528\u573a\u666f\uff1a%1$s \t      1. \u6240\u5f00\u53d1\u7684\u4ea7\u54c1\u4ec5\u7528\u4e8e\u5b66\u4e60\u3001\u4f01\u4e1a\u5185\u90e8\u4f7f\u7528\u3001\u9879\u76ee\u4ea4\u4ed8\u7b49\u4e0d\u9700\u8981\u516c\u5f00\u53d1\u5e03\u7684\u751f\u4ea7\u573a\u666f%2$s \t     2. \u5f00\u53d1\u73af\u5883\u65e0\u6cd5\u63a5\u5165\u4e92\u8054\u7f51\uff0c\u4f46\u5df2\u5728\u91d1\u8776\u4e91\u534f\u540c\u5f00\u53d1\u4e91\u5e73\u53f0(open.kingdee.com)\u7533\u8bf7\u4e86\u6388\u6743\u7801", (String)"IsvRegisterPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), System.lineSeparator(), System.lineSeparator());
        obj.set("textareafield1", (Object)s2);
        String s3 = String.format(ResManager.loadKDString((String)"\u534f\u540c\u8d26\u53f7\u83b7\u53d6\u9002\u7528\u573a\u666f\uff1a%s \t      1. \u5f53\u524d\u4f01\u4e1a/\u5f00\u53d1\u5546\u5df2\u5728\u534f\u540c\u5f00\u53d1\u4e91\u5e73\u53f0\u6ce8\u518c\u6210\u4e3a\u91d1\u8776\u4e91\u4f19\u4f34,\u5e76\u901a\u8fc7\u8d44\u8d28\u8ba4\u8bc1,\u7528\u4ee5\u83b7\u53d6\u7684\u534f\u540c\u8d26\u53f7\u53ef\u4ee5\u662f\u6240\u5c5e\u4f01\u4e1a\u7684\u4efb\u610f\u6210\u5458\u3002", (String)"IsvRegisterPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), System.lineSeparator());
        obj.set("textareafield2", (Object)s3);
    }

    public void afterBindData(EventObject e) {
        Object textfieldisv1 = this.getModel().getValue(KEY_TEXTFIELDISV1);
        Object textfieldisv2 = this.getModel().getValue(KEY_TEXTFIELDISV2);
        if (textfieldisv1 == null && textfieldisv2 == null || StringUtils.isBlank((Object)textfieldisv1) && StringUtils.isBlank((Object)textfieldisv2)) {
            Object radiogroupVal = this.getModel().getValue(KEY_RADIOGROUPFIELD);
            this.setEnable(radiogroupVal);
        } else if (!PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_BTNOK, KEY_BUTTONREG});
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (KEY_BTNOK.equals(btn.getKey())) {
            String radiogroupVal = (String)this.getModel().getValue(KEY_RADIOGROUPFIELD);
            Object isv = null;
            if (radiogroupVal.equals("1")) {
                isv = this.getModel().getValue(KEY_TEXTFIELDISV1);
                if (isv == null || StringUtils.isBlank((CharSequence)isv.toString())) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u53d1\u5546\u6807\u8bc6", (String)"IsvRegisterPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
            } else {
                isv = this.getModel().getValue(KEY_TEXTFIELDISV2);
                if (isv == null || StringUtils.isBlank((CharSequence)isv.toString())) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u83b7\u53d6\u5f00\u53d1\u5546\u6807\u8bc6", (String)"IsvRegisterPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
            }
            this.save(isv.toString(), radiogroupVal);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals(KEY_RADIOGROUPFIELD)) {
            Object val = e.getChangeSet()[0].getNewValue();
            this.setEnable(val);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent ce) {
        if ("rebuildIsvCallBack".equals(ce.getCallBackId()) && MessageBoxResult.Yes.equals((Object)ce.getResult())) {
            String isv = this.getPageCache().get("isv");
            String type = this.getPageCache().get("type");
            if (StringUtils.isBlank((CharSequence)isv) || StringUtils.isBlank((CharSequence)type)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"pageCache\u4f20\u9012\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\u5220\u9664\u91cd\u5efa\uff01", (String)"IsvRegisterPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])});
            }
            this.delIsv();
            this.doSave(isv, type);
        }
    }

    private void setEnable(Object radiogroupVal) {
        if (radiogroupVal != null && radiogroupVal.toString().equals("1")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"textfielduser", "textfieldpwd", KEY_TEXTFIELDISV2, KEY_BUTTONREG});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_TEXTFIELDISV1});
        } else if (radiogroupVal != null && radiogroupVal.toString().equals("2")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_TEXTFIELDISV1});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"textfielduser", "textfieldpwd", KEY_TEXTFIELDISV2, KEY_BUTTONREG});
        }
    }

    private void save(String isv, String type) {
        boolean hasUpper = Pattern.matches("^[a-z][a-z0-9]{0,3}$", isv);
        if (!hasUpper) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f00\u53d1\u5546\u6807\u8bc6\u5fc5\u987b\u4f7f\u7528\u5c0f\u5199\u5b57\u6bcd\u6216\u6570\u5b57\u5e76\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc74\u4f4d\uff01", (String)"IsvRegisterPlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (this.existIsv()) {
            HashMap<String, String> isvMap = new HashMap<String, String>();
            isvMap.put("isv", isv);
            isvMap.put("type", type);
            this.getPageCache().put(isvMap);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f00\u53d1\u5546\u6807\u8bc6\uff0c\u5220\u9664\u91cd\u5efa\u4f1a\u5bfc\u81f4\u539f\u5f00\u53d1\u5546\u6807\u8bc6\u7684\u6570\u636e\u4e0d\u80fd\u66f4\u6539\uff0c\u786e\u8ba4\u9700\u8981\u5220\u9664\u91cd\u5efa\u5f00\u53d1\u5546\u6807\u8bc6\u5417\uff1f", (String)"IsvRegisterPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("rebuildIsvCallBack"));
        } else {
            this.doSave(isv, type);
        }
    }

    private boolean existIsv() {
        String isvId = (String)DB.query((DBRoute)DBRoute.meta, (String)"select FISVID from T_BAS_ISV", (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String isv = null;
                if (rs.next()) {
                    isv = rs.getString(1);
                }
                return isv;
            }
        });
        return StringUtils.isNotBlank((CharSequence)isvId);
    }

    private void doSave(String isv, String type) {
        ISVInfo isvInfo = new ISVInfo();
        isvInfo.setId(isv);
        isvInfo.setType(type);
        isvInfo.setName(isv);
        if (ISVService.save((ISVInfo)isvInfo)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"IsvRegisterPlugin_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_BTNOK});
            this.getView().setStatus(OperationStatus.VIEW);
            this.getPageCache().put("returndata", "1");
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u6709\u5f00\u53d1\u5546\u6807\u8bc6\uff0c\u4fdd\u5b58\u5931\u8d25\uff01", (String)"IsvRegisterPlugin_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String data = this.getPageCache().get("returndata");
        if (StringUtils.isNotBlank((CharSequence)data)) {
            this.getView().returnDataToParent((Object)data);
        }
    }

    private void delIsv() {
        DB.execute((DBRoute)DBRoute.meta, (String)"delete from T_BAS_ISV");
    }
}

