/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.IFormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.OperateUtil;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.list.ListController;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Copy
extends DefaultDynamicFormOperate
implements ICloseCallBack,
IFormOperate {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    protected String viewBillFormId;
    protected OperationResult operationResult = new OperationResult();
    CloseCallBack closeCallBack;
    List<Consumer<FormShowParameter>> beforeShowBillListeners = new ArrayList<Consumer<FormShowParameter>>();
    boolean isCancelShowBill;
    private String permissionEntityId;

    public String getViewBillFormId() {
        return this.viewBillFormId;
    }

    public void setViewBillFormId(String viewBillFormId) {
        this.viewBillFormId = viewBillFormId;
    }

    public CloseCallBack getCloseCallBack() {
        return this.closeCallBack;
    }

    public void setCloseCallBack(CloseCallBack closeCallBack) {
        this.closeCallBack = closeCallBack;
    }

    public void addBeforeShowBillListener(Consumer<FormShowParameter> beforeShowBillListener) {
        this.beforeShowBillListeners.add(beforeShowBillListener);
    }

    public boolean isCancelShowBill() {
        return this.isCancelShowBill;
    }

    public void setCancelShowBill(boolean isCancelShowBill) {
        this.isCancelShowBill = isCancelShowBill;
    }

    private OperationStatus getOperationStatus() {
        return OperationStatus.ADDNEW;
    }

    @Override
    public OperationResult invokeOperation() {
        if (this.getView() instanceof IListView) {
            this.invokeListOperation();
        } else {
            this.invokeBillOperation();
        }
        return this.operationResult;
    }

    private void invokeListOperation() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u6570\u636e\uff0c\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff01", (String)"Copy_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
        } else {
            Object[] pks = selectedRows.getPrimaryKeyValues();
            if (pks.length <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u6570\u636e\uff0c\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff01", (String)"Copy_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            if (pks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Copy_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            if (!QueryServiceHelper.exists((String)this.getEntityId(), (Object)pks[0])) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"Copy_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            FormShowParameter parameter = OperateUtil.getShowParameter(this.getEntityId(), this.getViewBillFormId(), this.getPermissionEntityId(), this.getOperationStatus(), this.getView());
            parameter.getCustomParams().put("iscopy", true);
            parameter.getCustomParams().put("isCopyRelateEntity", this.isCopyRelateEntity());
            parameter.getCustomParams().put("CopyEmptyRow", this.isCopyEmptyRow());
            if (parameter instanceof BillShowParameter && this.getOption().containsVariable("routeKey")) {
                BillShowParameter billShowParameter = (BillShowParameter)parameter;
                billShowParameter.setRouteKey(this.getOption().getVariableValue("routeKey"));
                billShowParameter.setArchiveKey(this.getOption().getVariableValue("ArchiveKey"));
            }
            ((BillShowParameter)parameter).setPkId(pks[0]);
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
            parameter.setCloseCallBack(closeCallBack);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            if (proxy instanceof ListViewPluginProxy) {
                BeforeShowBillFormEvent e = new BeforeShowBillFormEvent((Object)this.getView(), (BillShowParameter)parameter);
                ((ListViewPluginProxy)proxy).fireBeforeShowBill(e);
                if (e.isCancel()) {
                    return;
                }
            }
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        }
    }

    private void invokeBillOperation() {
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        if (!(model instanceof IBillModel)) {
            return;
        }
        IFormController formController = (IFormController)this.getView().getService(IFormController.class);
        if (formController == null) {
            return;
        }
        MutexHelper.release((IFormView)this.getView());
        Object pkId = ((IBillModel)this.getView().getModel()).getPKValue();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        IValidatorHanlder pkProp = (IValidatorHanlder)this.getView().getModel().getDataEntityType().getPrimaryKey();
        if (billShowParameter.getBillStatus() == BillOperationStatus.ADDNEW || pkProp.getValueComparator().compareValue(pkId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u65b0\u589e\u72b6\u6001\u4e0b\u6267\u884c\u590d\u5236\u64cd\u4f5c\u3002", (String)"Copy_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
            return;
        }
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        billShowParameter.setPkId(pkId);
        billShowParameter.getCustomParams().put("iscopy", true);
        billShowParameter.getCustomParams().put("isCopyRelateEntity", this.isCopyRelateEntity());
        billShowParameter.getCustomParams().put("CopyEmptyRow", this.isCopyEmptyRow());
        if (this.getOption().containsVariable("routeKey")) {
            billShowParameter.setRouteKey(this.getOption().getVariableValue("routeKey"));
            billShowParameter.setArchiveKey(this.getOption().getVariableValue("ArchiveKey"));
        }
        formController.loadData();
    }

    private boolean isCopyRelateEntity() {
        if (this.getParameter() == null || !this.getParameter().containsKey("isCopyRelateEntity")) {
            return false;
        }
        return (Boolean)this.getParameter().get("isCopyRelateEntity");
    }

    private boolean isCopyEmptyRow() {
        if (this.getParameter() == null || !this.getParameter().containsKey("CopyEmptyRow")) {
            return false;
        }
        return (Boolean)this.getParameter().get("CopyEmptyRow");
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        if (closedcallbackevent.getSource() instanceof ListController) {
            ((IListView)((ListController)closedcallbackevent.getSource()).getView()).refreshWithSelected();
        }
    }

    public String getPermissionEntityId() {
        return this.permissionEntityId;
    }

    public void setPermissionEntityId(String permissionEntityId) {
        this.permissionEntityId = permissionEntityId;
    }

    protected void updateAttachment() {
        Map propCollections = this.getView().getModel().getDataEntityType().getAllFields();
        for (Map.Entry propMap : propCollections.entrySet()) {
            if (!(propMap.getValue() instanceof IAttachmentProp)) continue;
            String attachmentKey = ((IDataEntityProperty)propMap.getValue()).getName();
            this.updateAttachmentProp(attachmentKey);
        }
    }

    private void updateAttachmentProp(String attachmentKey) {
        MainEntityType mainType = this.getView().getModel().getDataEntityType();
        IDataEntityProperty property = mainType.findProperty(attachmentKey);
        if (property.getParent() instanceof MainEntityType) {
            DynamicObjectCollection attEntryRows = (DynamicObjectCollection)this.getView().getModel().getValue(attachmentKey);
            ArrayList<Long> attPKIds = new ArrayList<Long>();
            for (DynamicObject row : attEntryRows) {
                Long attPKId = row.getLong("fbasedataid_id");
                if (attPKId == null || Long.compare(0L, attPKId) == 0) continue;
                attPKIds.add(attPKId);
            }
            this.getView().getModel().setValue(attachmentKey, (Object)attPKIds.toArray(new Long[attPKIds.size()]));
            this.getView().updateView(attachmentKey);
        } else if (property.getParent() instanceof EntryType) {
            int entryRowCount = this.getView().getModel().getEntryRowCount(property.getParent().getName());
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObjectCollection attEntryRows = (DynamicObjectCollection)this.getView().getModel().getValue(attachmentKey, i);
                ArrayList<Long> attPKIds = new ArrayList<Long>();
                for (DynamicObject row : attEntryRows) {
                    Long attPKId = row.getLong("fbasedataid_id");
                    if (attPKId == null || Long.compare(0L, attPKId) == 0) continue;
                    attPKIds.add(attPKId);
                }
                this.getView().getModel().setValue(attachmentKey, (Object)attPKIds.toArray(new Long[attPKIds.size()]), i);
                this.getView().updateView(attachmentKey, i);
            }
        }
    }
}

