/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.MutexValidateResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.FormRoot;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.View;
import kd.bos.list.IListView;
import kd.bos.mutex.DataMutex;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Modify
extends View
implements IConfirmCallBack {
    private static final String ACTID_LOCKEDCONFIRM = "lockedConfirm";
    private static final String ACTID_REENTRANTCONFIRM = "reentrantConfirm";
    private static final String CALLBACKVALUE_OPERATIONKEY = "operateKey";
    private static final String CALLBACKVALUE_ENTITYID = "entityId";
    private static final String CALLBACKVALUE_PKVALUE = "pkvalue";
    private static final String USERID = "userid";
    private static final String SESSIONID = "sessionid";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public Modify() {
        this.billStatus = BillOperationStatus.EDIT;
    }

    @Override
    public OperationStatus getOperationStatus() {
        return OperationStatus.EDIT;
    }

    @Override
    protected String getMutexOperateKey() {
        return this.getType();
    }

    @Override
    protected boolean checkDataMutex() {
        try (EntityTraceSpan span = EntityTracer.create((String)"Mutex", (String)"Modify.checkDataMutex", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            boolean requireMutexStatus = this.isRequireMutexStatus();
            if (!requireMutexStatus) {
                this.isMutexLocked = true;
                this.existMutexNetGroup = false;
                span.addLocaleTag("requireMutexStatus", (Object)requireMutexStatus);
                boolean bl = this.isMutexLocked;
                return bl;
            }
            boolean mutex = super.checkDataMutex();
            span.addLocaleTag("mutex", (Object)mutex);
            boolean bl = mutex;
            return bl;
        }
    }

    private boolean isRequireMutexStatus() {
        try (EntityTraceSpan span = EntityTracer.create((String)"Mutex", (String)"Modify.isRequireMutexStatus", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            span.addLocaleTag("billStatus", (Object)this.billStatus);
            if (this.billStatus != BillOperationStatus.AUDIT && this.billStatus != BillOperationStatus.SUBMIT) {
                boolean bl = true;
                return bl;
            }
            if (StringUtils.isBlank((CharSequence)this.getEntityId())) {
                boolean bl = false;
                return bl;
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            FormRoot rootControl = FormMetadataCache.getRootControl((String)this.getViewBillFormId());
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
            boolean allFieldLock = MutexHelper.allFieldWithRequiredLock((IClientViewProxy)clientViewProxy, (List)rootControl.getItems(), (BillOperationStatus)this.billStatus, (MainEntityType)mainType);
            span.addLocaleTag("allFieldLock", (Object)allFieldLock);
            boolean bl = !allFieldLock;
            return bl;
        }
    }

    protected void doFailCheckRight(OperationResult result) {
        if (StringUtils.isNotBlank((CharSequence)this.lockInfoStr) && !"MessageCallBackType".equals(this.getParameter().get("sourceName"))) {
            List errList = result.getValidateResult().getValidateErrors();
            StringBuilder sb = new StringBuilder();
            for (ValidateResult errResult : errList) {
                for (IOperateInfo errInfo : errResult.getAllErrorInfo()) {
                    sb.append(errInfo.getMessage());
                }
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTID_LOCKEDCONFIRM, (IConfirmCallBack)this);
            HashMap<String, String> callbackValue = new HashMap<String, String>();
            callbackValue.put(CALLBACKVALUE_OPERATIONKEY, this.getOperateKey());
            callbackValue.put(CALLBACKVALUE_ENTITYID, this.getEntityId());
            callbackValue.put(CALLBACKVALUE_PKVALUE, String.valueOf(this.getPKValue()));
            if (errList.size() == 1 && "dataMutex".equals(((ValidateResult)errList.get(0)).getValidatorKey()) && errList.get(0) instanceof MutexValidateResult && ((MutexValidateResult)errList.get(0)).isEnableReentrant()) {
                confirmCallBacks.setCallBackId(ACTID_REENTRANTCONFIRM);
                sb.delete(0, sb.length());
                sb.append(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9875\u9762\u88ab\u8be5\u8d26\u53f7\u5728\u5176\u5b83\u4f1a\u8bdd\u4e2d\u9501\u5b9a\uff0c\u662f\u5426\u5c06\u5176\u767b\u51fa\uff1f", (String)"Modify_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            HashMap<Integer, String> btnNameMaps = null;
            DataMutex dm = DataMutex.create();
            Map<String, String> info = this.getLockInfo(dm, String.valueOf(this.getPKValue()), this.getEntityId(), this.getOperateKey());
            if (info != null && !info.isEmpty()) {
                String userId = info.get(USERID);
                btnNameMaps = new HashMap<Integer, String>();
                if (StringUtils.equals((CharSequence)userId, (CharSequence)RequestContext.get().getUserId())) {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u518d\u8bd5", (String)"Modify_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f3a\u5236\u8e22\u51fa", (String)"Modify_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                } else {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"Modify_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e", (String)"Modify_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                }
            }
            this.getView().showConfirm(sb.toString(), null, MessageBoxOptions.YesNo, null, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(callbackValue));
        } else if (this.getView() instanceof IListView) {
            this.getView().invokeOperation("view");
        } else {
            super.doFailCheckRight(result);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        String callBackId = messageboxclosedevent.getCallBackId();
        if ((messageboxclosedevent.getResult() == MessageBoxResult.Yes || messageboxclosedevent.getResult() == MessageBoxResult.OK) && ACTID_LOCKEDCONFIRM.equalsIgnoreCase(callBackId)) {
            String callbackValue = messageboxclosedevent.getCustomVaule();
            if (StringUtils.isEmpty((CharSequence)callbackValue)) {
                this.getView().invokeOperation("view");
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)callbackValue, Map.class);
            String operationKey = map.get(CALLBACKVALUE_OPERATIONKEY).toString();
            String entityId = map.get(CALLBACKVALUE_ENTITYID).toString();
            Object pkValue = map.get(CALLBACKVALUE_PKVALUE);
            try (DataMutex dm = DataMutex.create();){
                Map<String, String> info = this.getLockInfo(dm, String.valueOf(pkValue), entityId, operationKey);
                if (info == null || info.isEmpty()) return;
                String lockUserId = info.get(USERID);
                if (RequestContext.get().getUserId().equals(lockUserId)) {
                    IFormMutexService service = (IFormMutexService)this.getView().getService(IFormMutexService.class);
                    if (service != null) {
                        service.destoryLockingPage(entityId, pkValue, operationKey, true, Collections.singletonList(this.getView().getPageId()));
                    } else {
                        MutexHelper.clearErrLockByWebSocket((String)entityId, pkValue, (String)operationKey);
                    }
                    this.getView().invokeOperation(operationKey);
                    return;
                }
                this.getView().invokeOperation("view");
                return;
            }
            catch (IOException e) {
                ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\u3002%s", (String)"Modify_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), e.getMessage()));
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        } else {
            if (messageboxclosedevent.getResult() != MessageBoxResult.Yes && messageboxclosedevent.getResult() != MessageBoxResult.OK || !ACTID_REENTRANTCONFIRM.equals(callBackId)) return;
            String callbackValue = messageboxclosedevent.getCustomVaule();
            if (StringUtils.isEmpty((CharSequence)callbackValue)) {
                this.getView().invokeOperation("view");
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)callbackValue, Map.class);
            String operationKey = map.get(CALLBACKVALUE_OPERATIONKEY).toString();
            String entityId = map.get(CALLBACKVALUE_ENTITYID).toString();
            Object pkValue = map.get(CALLBACKVALUE_PKVALUE);
            IFormMutexService service = (IFormMutexService)this.getView().getService(IFormMutexService.class);
            if (service != null) {
                service.destoryLockingPage(entityId, pkValue, operationKey, true, Collections.singletonList(this.getView().getPageId()));
            } else {
                MutexHelper.clearErrLockByWebSocket((String)entityId, pkValue, (String)operationKey);
            }
            this.getView().invokeOperation(operationKey);
        }
    }

    private Map<String, String> getLockInfo(DataMutex dataMutex, String objectId, String entityKey, String operationKey) {
        HashMap<String, String> lockInfo = new HashMap<String, String>();
        String groupId = MutexHelper.getMutexGroupId((String)entityKey, (String)operationKey);
        Map info = dataMutex.getLockInfo(String.valueOf(objectId), groupId, entityKey);
        if (info != null && !info.isEmpty()) {
            lockInfo.put(USERID, (String)info.get(USERID));
            lockInfo.put(SESSIONID, (String)info.get("GLOBALSESSION"));
            lockInfo.put("client", (String)info.get("client"));
        }
        return lockInfo;
    }

    @Override
    void doFailShowForm(FormShowParameter parameter) {
        try (EntityTraceSpan span = EntityTracer.create((String)"Modify", (String)"doFailShowForm");){
            super.doFailShowForm(parameter);
            span.addLocaleTag("isMutexLocked", (Object)this.isMutexLocked);
            span.addLocaleTag("existMutexNetGroup", (Object)this.existMutexNetGroup);
            if (this.isMutexLocked && this.existMutexNetGroup) {
                Map customParams = parameter.getCustomParams();
                if (customParams == null || customParams.isEmpty()) {
                    return;
                }
                String mutexEntityKey = (String)customParams.get("MUTEX_ENTITY_KEY");
                String mutexOperationKey = (String)customParams.get("MUTEX_OPER_KEY");
                String mutexObjId = (String)customParams.get("MUTEX_OBJ_ID");
                span.addTag("MUTEX_ENTITY_KEY", mutexEntityKey);
                span.addTag("MUTEX_OPER_KEY", mutexOperationKey);
                span.addTag("MUTEX_OBJ_ID", mutexObjId);
                if (StringUtils.isNotBlank((CharSequence)mutexEntityKey) && StringUtils.isNotBlank((CharSequence)mutexOperationKey) && StringUtils.isNotBlank((CharSequence)mutexObjId)) {
                    MutexHelper.release((String)mutexEntityKey, (String)mutexOperationKey, (String)mutexObjId);
                }
            }
        }
    }
}

