/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.base.BillLayoutScheme;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IDefValueProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ORMUtil;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.DuplicateSubmitHelper;
import kd.bos.form.operate.IFormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.OperateUtil;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mvc.bill.BillTypeDefValueProvider;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListController;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class New
extends DefaultDynamicFormOperate
implements ICloseCallBack,
IFormOperate {
    public static final String SERIES_NEW_TOTE = "seriesnewtote";
    private static final String FILTERSELECTEDVALUES = "filterSelectedValues";
    private static final IAttachmentService iAttachmentService = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
    protected String viewBillFormId;
    CloseCallBack closeCallBack;
    List<Consumer<FormShowParameter>> beforeShowBillListeners = new ArrayList<Consumer<FormShowParameter>>();
    boolean isCancelShowBill;
    private String permissionEntityId;

    public String getViewBillFormId() {
        return this.viewBillFormId;
    }

    public void setViewBillFormId(String viewBillFormId) {
        this.viewBillFormId = viewBillFormId;
    }

    public CloseCallBack getCloseCallBack() {
        return this.closeCallBack;
    }

    public void setCloseCallBack(CloseCallBack closeCallBack) {
        this.closeCallBack = closeCallBack;
    }

    public void addBeforeShowBillListener(Consumer<FormShowParameter> beforeShowBillListener) {
        this.beforeShowBillListeners.add(beforeShowBillListener);
    }

    public boolean isCancelShowBill() {
        return this.isCancelShowBill;
    }

    public void setCancelShowBill(boolean isCancelShowBill) {
        this.isCancelShowBill = isCancelShowBill;
    }

    public boolean needSelectData() {
        return false;
    }

    private OperationStatus getOperationStatus() {
        return OperationStatus.ADDNEW;
    }

    protected void createNewData(IFormView formView) {
        this.resetStatus();
        MutexHelper.release((IFormView)this.getView());
        IDataModel model = (IDataModel)formView.getService(IDataModel.class);
        if (!this.resolveLayout(model)) {
            this.setDefalutValue(model);
            if (LayoutControlInfo.isBillTypeLayout()) {
                this.handleBillType(model);
            }
            if (formView instanceof IBillView) {
                ((BillShowParameter)formView.getFormShowParameter()).setCachePageId(null);
            }
            model.beginInit();
            model.createNewData();
            model.endInit();
            if (model instanceof IBillModel) {
                this.updateBillLayout((IBillModel)model);
            }
            formView.updateView();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pageId", formView.getPageId());
            IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
            clientViewProxy.addAction("cleanFieldTips", map);
        }
    }

    private Long getSafeBillTypeId(String billType) {
        if (StringUtils.isBlank((CharSequence)billType)) {
            return 0L;
        }
        Long billTypeId = 0L;
        try {
            billTypeId = Long.valueOf(billType);
        }
        catch (Exception e) {
            billTypeId = 0L;
        }
        return billTypeId;
    }

    private void handleBillType(IDataModel model) {
        BillEntityType type = (BillEntityType)model.getDataEntityType();
        BillShowParameter showParam = (BillShowParameter)this.getView().getFormShowParameter();
        String billType = type.getBillType();
        if (billType != null) {
            BillTypeDefValueProvider pro = (BillTypeDefValueProvider)this.getView().getService(IDefValueProvider.class);
            BillTypeProp billTypeProp = (BillTypeProp)type.getProperty(billType);
            Long billTypeId = billTypeProp.queryDefaultBillType(type.getName());
            String showParamBillType = showParam.getBillTypeId();
            Long showParamBillTypeId = this.getSafeBillTypeId(showParamBillType);
            if (!billTypeProp.isSeriesNewTote() && billTypeId != null && StringUtils.isNotBlank((CharSequence)showParamBillType) && !billTypeId.equals(showParamBillTypeId)) {
                String defaultId = String.valueOf(billTypeId);
                showParam.setBillTypeId(defaultId);
                pro.setBilltypePk(billTypeId);
            }
            Object vBillTypeId = model.getContextVariable("DEFAULT_BILLTYPE_ID");
            if (billTypeProp.isSeriesNewTote() && vBillTypeId != null) {
                String vDefaultId = String.valueOf(vBillTypeId);
                Long lBillTypeId = Long.valueOf(vDefaultId);
                boolean billTypeValid = billTypeProp.queryBillTypeEnable(lBillTypeId);
                if (billTypeValid) {
                    showParam.setBillTypeId(vDefaultId);
                    pro = (BillTypeDefValueProvider)this.getView().getService(IDefValueProvider.class);
                    pro.setBilltypePk(lBillTypeId);
                } else if (billTypeId != null) {
                    showParam.setBillTypeId(String.valueOf(billTypeId));
                    pro = (BillTypeDefValueProvider)this.getView().getService(IDefValueProvider.class);
                    pro.setBilltypePk(billTypeId);
                    model.putContextVariable("DEFAULT_BILLTYPE_ID", null);
                } else {
                    showParam.setBillTypeId(null);
                    pro = (BillTypeDefValueProvider)this.getView().getService(IDefValueProvider.class);
                    pro.setBilltypePk(null);
                    model.putContextVariable("DEFAULT_BILLTYPE_ID", null);
                }
            }
        }
    }

    private boolean resolveLayout(IDataModel model) {
        if (!LayoutControlInfo.isBillTypeLayout()) {
            return false;
        }
        BillEntityType type = (BillEntityType)model.getDataEntityType();
        BillShowParameter showParam = (BillShowParameter)this.getView().getFormShowParameter();
        String billType = type.getBillType();
        if (billType != null) {
            BillTypeProp billTypeProp = (BillTypeProp)type.getProperty(billType);
            Long billTypeId = billTypeProp.queryDefaultBillType(type.getName());
            if (billTypeId == null) {
                return false;
            }
            String showParamBillType = showParam.getBillTypeId();
            Long showParamBillTypeId = this.getSafeBillTypeId(showParamBillType);
            if (!billTypeProp.isSeriesNewTote() && StringUtils.isNotBlank((CharSequence)showParamBillType) && !billTypeId.equals(showParamBillTypeId)) {
                this.doShowLayout(model, billTypeId);
                return true;
            }
        }
        return false;
    }

    private void doShowLayout(IDataModel model, Long billTypeId) {
        HashMap map = new HashMap();
        Map resultMap = ORMUtil.getFormIdByBillTypeId((long)billTypeId, (boolean)(this.getView() instanceof IMobileView));
        map.put("formId", resultMap.get("formId"));
        BillShowParameter showParam = (BillShowParameter)BillShowParameter.createFormShowParameter(map);
        showParam.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParam.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        Map<String, Object> value = this.getCarryValue(model);
        if (!value.isEmpty()) {
            showParam.setCustomParam("dataEntity", value);
        }
        showParam.setCustomParam("entityId", (Object)this.getEntityId());
        this.getView().showForm((FormShowParameter)showParam);
    }

    private Map<String, Object> getCarryValue(IDataModel model) {
        HashMap<String, Object> carryValue = new HashMap<String, Object>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        DynamicObject oldObject = model.getDataEntity();
        DynamicProperty proterty = null;
        Map headFields = entityType.getFields();
        for (Map.Entry item : headFields.entrySet()) {
            DynamicObject fldValue;
            proterty = (DynamicProperty)item.getValue();
            if (!(proterty instanceof IFieldHandle) || !((IFieldHandle)proterty).isSeriesNewTote()) continue;
            if (proterty instanceof FieldProp) {
                carryValue.put(proterty.getName(), proterty.getValue((Object)oldObject));
                continue;
            }
            if (proterty instanceof BasedataProp) {
                Object refId;
                fldValue = (DynamicObject)proterty.getValue((Object)oldObject);
                Object object = refId = fldValue == null ? null : fldValue.getPkValue();
                if (proterty instanceof BillTypeProp) continue;
                carryValue.put(((BasedataProp)proterty).getName(), refId);
                continue;
            }
            if (!(proterty instanceof MulBasedataProp)) continue;
            fldValue = (DynamicObjectCollection)proterty.getValue((Object)oldObject);
            ArrayList<String> pks = new ArrayList<String>();
            for (DynamicObject obj : fldValue) {
                Object o = ((MulBasedataProp)proterty).getRefBaseProp().getValue((Object)obj);
                Object pkId = ((DynamicObject)o).getPkValue();
                if (pkId instanceof Long) {
                    pks.add(String.valueOf(pkId));
                    continue;
                }
                pks.add((String)pkId);
            }
            carryValue.put(proterty.getName(), String.join((CharSequence)",", pks));
        }
        return carryValue;
    }

    private void updateBillLayout(IBillModel model) {
        if (LayoutControlInfo.isBillTypeLayout()) {
            return;
        }
        BillLayoutScheme bls = this.getLayoutScheme(model);
        BillLayoutSchemeAssignEntity blsa = bls.getLayoutScheme();
        if (blsa != null) {
            bls.updateBillLayout(this.getView());
        }
    }

    private BillLayoutScheme getLayoutScheme(IBillModel model) {
        BillLayoutParameter blp = new BillLayoutParameter();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Long newOrgValue = billShowParameter.getLayoutMainOrgId();
        long orgId = 0L;
        if (newOrgValue != null) {
            orgId = newOrgValue;
        }
        blp.setOrgId(orgId);
        String billType = billShowParameter.getBillTypeId();
        long billTypeId = this.getSafeBillTypeId(billType);
        blp.setBillTypeId(billTypeId);
        return new BillLayoutScheme(model, billShowParameter, blp);
    }

    private void setDefalutValue(IDataModel model) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        DynamicObject oldObject = model.getDataEntity();
        DynamicProperty proterty = null;
        Map headFields = entityType.getFields();
        for (Map.Entry item : headFields.entrySet()) {
            DynamicObject fldValue;
            proterty = (DynamicProperty)item.getValue();
            if (!(proterty instanceof IFieldHandle) || !((IFieldHandle)proterty).isSeriesNewTote()) continue;
            if (proterty instanceof FieldProp) {
                model.putContextVariable(proterty.getName(), proterty.getValue((Object)oldObject));
                continue;
            }
            if (proterty instanceof BasedataProp) {
                Object refId;
                fldValue = (DynamicObject)proterty.getValue((Object)oldObject);
                Object object = refId = fldValue == null ? null : fldValue.getPkValue();
                if (proterty instanceof BillTypeProp) {
                    model.putContextVariable("DEFAULT_BILLTYPE_ID", refId);
                    continue;
                }
                model.putContextVariable(((BasedataProp)proterty).getName(), refId);
                continue;
            }
            if (!(proterty instanceof MulBasedataProp)) continue;
            if (proterty instanceof AttachmentProp) {
                List ids = iAttachmentService.newAndCarryAttachmentField(oldObject, proterty, this.getPageId());
                model.putContextVariable(proterty.getName(), (Object)ids);
                continue;
            }
            fldValue = (DynamicObjectCollection)proterty.getValue((Object)oldObject);
            ArrayList<Object> pks = new ArrayList<Object>();
            for (DynamicObject obj : fldValue) {
                Object o = ((MulBasedataProp)proterty).getRefBaseProp().getValue((Object)obj);
                pks.add(((DynamicObject)o).getPkValue());
            }
            model.putContextVariable(proterty.getName(), pks);
        }
    }

    @Override
    public OperationResult invokeOperation() {
        if (this.getView() instanceof IListView) {
            FormShowParameter parameter = OperateUtil.getShowParameter(this.getEntityId(), this.getViewBillFormId(), this.getPermissionEntityId(), this.getOperationStatus(), this.getView());
            if (parameter instanceof BillShowParameter && this.getOption().containsVariable("routeKey")) {
                BillShowParameter billShowParameter = (BillShowParameter)parameter;
                billShowParameter.setRouteKey(this.getOption().getVariableValue("routeKey"));
                billShowParameter.setArchiveKey(this.getOption().getVariableValue("ArchiveKey"));
            }
            this.initListShowParameter(parameter);
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            if (proxy instanceof ListViewPluginProxy) {
                BeforeShowBillFormEvent e = new BeforeShowBillFormEvent((Object)this.getView(), (BillShowParameter)parameter);
                ((ListViewPluginProxy)proxy).fireBeforeShowBill(e);
                if (e.isCancel()) {
                    return null;
                }
            }
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
            return null;
        }
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        boolean isConfirm = "MessageCallBackType".equals(this.getOption().getVariableValue("sourceName", ""));
        if (!isConfirm && this.getView() instanceof IBillView && model.getDataEntity().getDataEntityState().getFromDatabase() && model.getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (AbstractOperate)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"New_0", (String)"bos-form-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.getView().setStatus(OperationStatus.ADDNEW);
            this.createNewData(this.getView());
        }
        return null;
    }

    protected void initListShowParameter(FormShowParameter parameter) {
        OperateOption operateOption;
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (selectedMainOrgIds != null && selectedMainOrgIds.size() == 1) {
            parameter.setCustomParam("SELECT_ORG_ID", (Object)((Long)selectedMainOrgIds.get(0)).toString());
        }
        if ((operateOption = this.getOption()).containsVariable(FILTERSELECTEDVALUES)) {
            parameter.setCustomParam(FILTERSELECTEDVALUES, (Object)operateOption.getVariableValue(FILTERSELECTEDVALUES));
        }
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
        parameter.setCloseCallBack(closeCallBack);
    }

    protected int hasRight(OperationResult result) {
        return super.hasRight(result);
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        if (closedcallbackevent.getSource() instanceof ListController) {
            ((IListView)((ListController)closedcallbackevent.getSource()).getView()).refreshWithSelected();
        }
    }

    private void resetStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        if (this.getView() instanceof BillView) {
            BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            billShowParameter.setPkId(null);
        }
        this.getView().cacheFormShowParameter();
    }

    public String getPermissionEntityId() {
        return this.permissionEntityId;
    }

    public void setPermissionEntityId(String permissionEntityId) {
        this.permissionEntityId = permissionEntityId;
    }

    public OperationResult execute() {
        DuplicateSubmitHelper.clean((IFormView)this.getView());
        return super.execute();
    }
}

