/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.mvc.SessionManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

class OperateUtil {
    private static final Log log = LogFactory.getLog(OperateUtil.class);
    private static SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);

    OperateUtil() {
    }

    static FormShowParameter getShowParameter(String entityId, String viewBillFormId, String permissionEntityId, OperationStatus operationStatus, IFormView view) {
        ShowType showType;
        Object parameter = null;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        parameter = mainEntityType instanceof BasedataEntityType ? (view instanceof IMobileListView ? new MobileBillShowParameter() : new BaseShowParameter()) : (mainEntityType instanceof BillEntityType ? (view instanceof IMobileListView ? new MobileBillShowParameter() : new BillShowParameter()) : new FormShowParameter());
        if (parameter instanceof BillShowParameter) {
            ((BillShowParameter)parameter).setPermissionEntityId(permissionEntityId);
        }
        parameter.setFormId(viewBillFormId);
        if (view instanceof IMobileListView) {
            showType = ShowType.Floating;
        } else if (view instanceof IListView) {
            if (OperateUtil.checkWindowOfModel((FormShowParameter)parameter)) {
                showType = ShowType.NewBrowserPage;
            } else if (OperateUtil.parentIsModel(view)) {
                showType = ShowType.Modal;
            } else {
                showType = view.getFormShowParameter().getFormConfig().getShowType();
                parameter.getOpenStyle().setTargetKey("tabap");
            }
        } else {
            showType = ShowType.Modal;
            Object isOpenNewTab = view.getFormShowParameter().getCustomParam("isOpenNewTab");
            if (isOpenNewTab != null && ((Boolean)isOpenNewTab).booleanValue()) {
                showType = ShowType.MainNewTabPage;
                parameter.getOpenStyle().setTargetKey("tabap");
            }
        }
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        ((BillShowParameter)parameter).setStatus(operationStatus);
        parameter.getOpenStyle().setShowType(showType);
        return parameter;
    }

    private static boolean checkWindowOfModel(FormShowParameter showParameter) {
        boolean isNewTab = false;
        try {
            boolean open;
            Object isOpenObj = systemParamService.loadPublicParameterFromCache("newtabwithbrowser");
            boolean bl = open = Objects.nonNull(isOpenObj) && Boolean.parseBoolean(isOpenObj.toString());
            if (open) {
                String appId = showParameter.getAppId();
                Map map = (Map)DispatchServiceHelper.invokeBOSService((String)(appId == null ? "bos" : appId), (String)"FormService", (String)"createConfig", (Object[])new Object[]{showParameter});
                isNewTab = map != null && (ObjectUtils.isEmpty(map.get("width")) || "100%".equals(map.get("width")));
            }
        }
        catch (Exception e) {
            log.info("checkWindowOfModel error:" + e.getMessage());
        }
        return isNewTab;
    }

    private static boolean parentIsModel(IFormView view) {
        FormShowParameter parentParameter;
        boolean isModel = false;
        int count = 0;
        HashSet<String> pageIds = new HashSet<String>(16);
        FormShowParameter formShowParameter = parentParameter = view == null ? null : view.getFormShowParameter();
        while (parentParameter != null) {
            if (parentParameter.getOpenStyle().getShowType().compareTo((Enum)ShowType.Modal) == 0) {
                isModel = true;
                break;
            }
            String parentPageId = parentParameter.getParentPageId();
            if (pageIds.contains(parentPageId)) {
                log.info("OperateUtil.parentIsModel Endless Loop. parentParameter.FormId='" + parentParameter.getFormId() + "', view.FormId='" + view.getFormShowParameter().getFormId() + "'");
            }
            pageIds.add(parentPageId);
            FormShowParameter formShowParameter2 = parentParameter = parentPageId == null ? null : SessionManager.getCurrent().getFormShowParameter(parentPageId);
            if (++count <= 50) continue;
            break;
        }
        return isModel;
    }
}

