/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.BillViewPluginProxy;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BillTypeEdit;
import kd.bos.form.field.ORMUtil;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.DefaultBillFormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.OperateUtil;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.IListView;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillView;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class View
extends DefaultBillFormOperate
implements IConfirmCallBack {
    private static final Log log = LogFactory.getLog(View.class);
    private static final String SPAN_TYPE_OPERATE = "operate";
    private static final String ACTID_CONTENTCHANGE = "contentChange";
    private static final String BILL_STATUS = "billstatus";
    protected BillOperationStatus billStatus = BillOperationStatus.VIEW;

    protected OperationStatus getOperationStatus() {
        return OperationStatus.VIEW;
    }

    @Override
    protected void initPkValue() {
        if (this.getView() instanceof IListView) {
            ListSelectedRowCollection selectedRows;
            super.initPkValue();
            ListSelectedRow row = this.getListFocusRow();
            if (row != null && this.getOperationStatus() != OperationStatus.VIEW) {
                String value = this.getBillStatus(row);
                if ("B".equals(value)) {
                    this.billStatus = BillOperationStatus.SUBMIT;
                } else if ("C".equals(value)) {
                    this.billStatus = BillOperationStatus.AUDIT;
                }
                if (EntityTracer.isRealtime()) {
                    try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"View.initPkValue", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                        span.addLocaleTag("statusField.value", (Object)value);
                        span.addLocaleTag("billStatus", (Object)this.billStatus);
                    }
                }
            } else if (row == null && (selectedRows = this.getListSelectedData()) != null && selectedRows.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"View_1", (String)"bos-form-business", (Object[])new Object[0]));
                this.getOption().setVariableValue("tip.continue", "false");
                return;
            }
        } else {
            DynamicObject orgObject;
            IDataModel model = this.getView().getModel();
            DynamicObject entityData = model.getDataEntity();
            String orgKey = this.getView().getModel().getDataEntityType().getMainOrg();
            this.mainOrgId = StringUtils.isNotBlank((CharSequence)orgKey) ? ((orgObject = (DynamicObject)entityData.get(orgKey)) == null ? Long.valueOf(0L) : (Long)orgObject.getPkValue()) : Long.valueOf(0L);
            this.pkValue = entityData.getPkValue();
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"View.initPkValue", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                    span.addLocaleTag("mainOrgId", (Object)this.mainOrgId);
                    span.addLocaleTag("pkValue", this.pkValue);
                }
            }
        }
    }

    @Override
    public OperationResult invokeOperation() {
        if (this.getView() instanceof IListView) {
            this.invokeListOperation();
        } else if (this.getView() instanceof IBillView) {
            this.invokeBillOperation();
        }
        return new OperationResult();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)ACTID_CONTENTCHANGE)) {
            this.initPkValue();
            if (e.getResult() == MessageBoxResult.Yes) {
                this.setFormStatus();
                this.reloadBill();
            }
        }
    }

    private void invokeListOperation() {
        FormShowParameter parameter = OperateUtil.getShowParameter(this.getEntityId(), this.getViewBillFormId(), this.getPermissionEntityId(), this.getOperationStatus(), this.getView());
        String objId = String.valueOf(this.pkValue);
        parameter.setCloseCallBack(this.closeCallBack);
        ((BillShowParameter)parameter).setPkId(this.pkValue);
        ((BillShowParameter)parameter).setBillStatus(this.billStatus);
        for (Consumer consumer : this.beforeShowBillListeners) {
            consumer.accept(parameter);
        }
        if (this.isCancelShowBill()) {
            if (this.isMutexLocked && this.existMutexNetGroup) {
                MutexHelper.release((String)this.getEntityId(), (String)this.getMutexOperateKey(), (String)objId);
            }
            return;
        }
        if (parameter.getOpenStyle().getShowType() == ShowType.NewBrowserPage) {
            MutexHelper.release((String)this.getEntityId(), (String)this.getMutexOperateKey(), (String)objId);
        }
        if (this.isMutexLocked && this.existMutexNetGroup) {
            if (this.checkParameterChange((BillShowParameter)parameter)) {
                parameter.setCustomParam("MUTEX_ENTITY_KEY", (Object)this.getEntityId());
                parameter.setCustomParam("MUTEX_OBJ_ID", (Object)objId);
                parameter.setCustomParam("MUTEX_OPER_KEY", (Object)this.getMutexOperateKey());
            } else {
                MutexHelper.release((String)this.getEntityId(), (String)this.getMutexOperateKey(), (String)objId);
            }
        }
        if (parameter instanceof BillShowParameter && this.getOption().containsVariable("routeKey")) {
            BillShowParameter billShowParameter = (BillShowParameter)parameter;
            billShowParameter.setRouteKey(this.getOption().getVariableValue("routeKey"));
            billShowParameter.setArchiveKey(this.getOption().getVariableValue("ArchiveKey"));
        }
        this.changeFormIdByBillType((BillShowParameter)parameter);
        if (parameter.getOpenStyle().getShowType() == null) {
            this.getView().openUrl("?formId=" + parameter.getFormId());
        } else {
            this.showForm(parameter);
        }
    }

    private void changeFormIdByBillType(BillShowParameter parameter) {
        DynamicObject billTypeId;
        DynamicObject dynamicObject;
        boolean disableBillType;
        String formId = parameter.getFormId();
        if (!LayoutControlInfo.isBillTypeLayout()) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        if (!(entityType instanceof BillEntityType)) {
            return;
        }
        String billTypeKey = ((BillEntityType)entityType).getBillType();
        if (StringUtils.isBlank((CharSequence)billTypeKey)) {
            return;
        }
        if (parameter.isDisableLayoutScheme()) {
            return;
        }
        boolean bl = disableBillType = parameter.getCustomParam("disableBillType") == null ? false : (Boolean)parameter.getCustomParam("disableBillType");
        if (disableBillType) {
            return;
        }
        FormRoot root = FormMetadataCache.getRootControl((String)formId);
        if (this.findBillType(billTypeKey, root.getItems()) == null) {
            return;
        }
        if (this.pkValue != null && (dynamicObject = BusinessDataReader.loadSingle((Object)this.pkValue, (String)entityType.getName(), (String)billTypeKey)) != null && dynamicObject.get(billTypeKey) instanceof DynamicObject && (billTypeId = (DynamicObject)dynamicObject.get(billTypeKey)) != null && billTypeId.getPkValue() instanceof Long) {
            boolean isMob = this.getView() instanceof IMobileView;
            Map resultMap = ORMUtil.getFormIdByBillTypeId((long)((Long)billTypeId.getPkValue()), (boolean)isMob);
            String billTypeFormId = (String)resultMap.get("formId");
            if (StringUtils.isNotBlank((CharSequence)billTypeFormId) && !formId.equals(billTypeFormId) && (!isMob || Boolean.parseBoolean((String)resultMap.get("isMobFormId")))) {
                parameter.setFormId(billTypeFormId);
            }
        }
    }

    private Control findBillType(String billTypeKey, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (ctl instanceof BillTypeEdit && StringUtils.equals((CharSequence)billTypeKey, (CharSequence)((BillTypeEdit)ctl).getFieldKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findBillType(billTypeKey, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    private boolean checkParameterChange(BillShowParameter parameter) {
        return Objects.equals(parameter.getPkId(), this.pkValue) && Objects.equals(parameter.getFormId(), this.getViewBillFormId());
    }

    private void invokeBillOperation() {
        PKFieldProp pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
        if (this.pkValue == null || pkProp.getValueComparator().compareValue(this.pkValue)) {
            return;
        }
        if (this.getView().getFormShowParameter().getStatus() == this.getOperationStatus()) {
            return;
        }
        IBillModel model = (IBillModel)this.getView().getModel();
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT && model.getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACTID_CONTENTCHANGE, (AbstractOperate)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"View_0", (String)"bos-form-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.setFormStatus();
            this.reloadBill();
        }
    }

    protected void showForm(FormShowParameter parameter) {
        Object currPKValue;
        String pageId = this.generatePage4ListOp(this.getView(), parameter.getFormId(), this.getPKValue());
        IFormView formView = this.getView().getViewNoPlugin(pageId);
        if (formView != null && formView.getModel().isDataLoaded() && !(currPKValue = formView.getModel().getDataEntity().getPkValue()).equals(this.getPKValue())) {
            pageId = StringUtils.isEmpty((CharSequence)currPKValue.toString()) || currPKValue instanceof Long && Long.parseLong(currPKValue.toString()) == 0L ? this.generatePage4ListOp(this.getView(), parameter.getFormId(), ((Object)((Object)this)).getClass().getSimpleName()) : this.generatePage4ListOp(this.getView(), parameter.getFormId(), currPKValue);
        }
        parameter.setPageId(pageId);
        parameter.setHasRight(true);
        this.getView().showForm(parameter);
        if (!SessionManager.getCurrent().existView(pageId)) {
            this.doFailShowForm(parameter);
        }
    }

    private void setFormStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setStatus(this.getOperationStatus());
        if (this.getView() instanceof BillView) {
            BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
            billShowParameter.setBillStatus(this.billStatus);
        }
        this.getView().cacheFormShowParameter();
    }

    private void reloadBill() {
        IBillModel billModel = (IBillModel)this.getView().getModel();
        billModel.beginInit();
        billModel.setPKValue(this.getPKValue());
        billModel.load(this.getPKValue());
        ((BillViewPluginProxy)this.getView().getService(FormViewPluginProxy.class)).fireAfterLoadData(new EventObject(this.getView()));
        billModel.endInit();
        this.getView().updateView();
    }

    protected String getLogOperateName() {
        return ResManager.loadKDString((String)"\u6253\u5f00\u9875\u9762", (String)"View_2", (String)"bos-form-business", (Object[])new Object[0]);
    }

    protected OpLogAppInfo buildOpLogInfo(Long orgId, String msg) {
        OpLogAppInfo logInfo = super.buildOpLogInfo(orgId, msg);
        logInfo.setOpName(this.getOperateKey(), new MultiLangEnumBridge("\u6253\u5f00\u9875\u9762", "View_2", "bos-form-business"));
        return logInfo;
    }

    private String getBillStatus(ListSelectedRow row) {
        String statusFieldValue = row.getBillStatus();
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_OPERATE, (String)"View.getBillStatus", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            MainEntityType type;
            String entityId = this.getEntityId();
            span.addLocaleTag("entityId", (Object)this.getEntityId());
            if (StringUtils.isNotBlank((CharSequence)entityId) && (type = EntityMetadataCache.getDataEntityType((String)entityId)) instanceof BillEntityType) {
                String statusField = ((BillEntityType)type).getBillStatus();
                DynamicProperty statusProp = type.getProperty(statusField);
                span.addLocaleTag("statusField", (Object)statusField);
                span.addLocaleTag("statusProp", (Object)statusProp);
                if (StringUtils.isNotBlank((CharSequence)statusField) && statusProp != null) {
                    DynamicObject data = BusinessDataReader.loadSingle((Object)row.getPrimaryKeyValue(), (String)entityId, (String)statusField);
                    statusFieldValue = data.getString(statusField);
                    span.addLocaleTag("statusFieldValue", (Object)statusFieldValue);
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5355\u636e\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
        return statusFieldValue;
    }

    void doFailShowForm(FormShowParameter parameter) {
    }
}

