/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.FlexGridConfigRow;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.flex.FlexSplitColsCache;
import kd.bos.form.flex.FlexSplitColumn;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldContainerAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.OperationColumnAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.userconfig.GridConfigDAO;

public class ConfigureGrid
extends EntryGridOperate
implements ICloseCallBack {
    private static final String ACTION_SET_ENTRYFIELD = "configuregrid";
    private static final String CHILDREN = "children";
    private static final String FLEX_CHILDREN_LIST = "rep_flex_children_list";
    private static final String FLEX_GRID_CONFIG = "flexGridConfig";

    @Override
    protected OperationResult invokeOperation() {
        List<AbstractGrid> relatedGrid = this.getRelatedGrid();
        String entryId = relatedGrid.size() > 0 ? relatedGrid.get(0).getKey() : this.getEntryKey();
        String formId = this.getEntityId();
        String paramFormId = this.getView().getFormShowParameter().getFormId();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)paramFormId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (!StringUtils.equals((CharSequence)formMetadata.getEntityId(), (CharSequence)formMetadata.getId())) {
            formId = paramFormId;
        }
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        List<GridConfigurationRow> gridConfigByMeta = this.getFieldApInfo(formId, entryId);
        if (!CollectionUtils.isEmpty(relatedGrid)) {
            List freezeList = relatedGrid.get(0).getFreezeList();
            GridConfigRenderUtils.setListColumnFixed(gridConfigByMeta, (List)freezeList);
            GridConfigRenderUtils.setInitField(gridConfigByMeta, (List)relatedGrid.get(0).getInitField());
        }
        List<GridConfigurationRow> gridConfigByDB = gridConfigDAO.getGridConfig(formId, entryId);
        ArrayList<GridConfigurationRow> flexGridConfig = new ArrayList<GridConfigurationRow>();
        gridConfigByDB = this.combineRuntimeMeta(gridConfigByMeta, gridConfigByDB, flexGridConfig);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), ACTION_SET_ENTRYFIELD);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_gridconfig");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam("gridConfig", (Object)SerializationUtils.toJsonString(gridConfigByDB));
        parameter.setCustomParam("gridConfigKey", (Object)entryId);
        parameter.setCustomParam("entityNum", (Object)this.getEntityId());
        parameter.setCustomParam("sourceType", (Object)"entry");
        parameter.setCustomParam("resetGridConfig", (Object)SerializationUtils.toJsonString(gridConfigByMeta));
        if (!flexGridConfig.isEmpty()) {
            String flexGridConfigStr = SerializationUtils.toJsonString(flexGridConfig);
            parameter.setCustomParam(FLEX_GRID_CONFIG, (Object)flexGridConfigStr);
            this.getView().getPageCache().put(FLEX_GRID_CONFIG, flexGridConfigStr);
        }
        this.getView().showForm(parameter);
        return new OperationResult();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (ACTION_SET_ENTRYFIELD.equalsIgnoreCase(evt.getActionId()) && evt.getSource() instanceof IFormController) {
            EntryGrid entryGrid = new EntryGrid();
            entryGrid.closedCallBackHandle(evt.getView(), (Map)evt.getReturnData());
        }
    }

    private List<GridConfigurationRow> getFieldApInfo(String formId, String entryId) {
        Objects.requireNonNull(entryId);
        Objects.requireNonNull(formId);
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        String entryApId = null;
        for (ControlAp ctlAp : formMeta.getItems()) {
            if (!(ctlAp instanceof EntryAp) || !Objects.equals(entryId, ctlAp.getKey())) continue;
            entryApId = ctlAp.getId();
            break;
        }
        return this.buildGridConfiguration(formMeta.getItems(), entryApId);
    }

    private List<GridConfigurationRow> buildGridConfiguration(List<ControlAp<?>> items, String entryApId) {
        ArrayList<GridConfigurationRow> currentFields = new ArrayList<GridConfigurationRow>(items.size());
        for (ControlAp<?> ctlAp : items) {
            int statusVal;
            if (!(ctlAp instanceof EntryFieldAp) && !(ctlAp instanceof EntryFieldGroupAp) && !(ctlAp instanceof EntryFieldContainerAp) && !(ctlAp instanceof OperationColumnAp) || !Objects.equals(entryApId, ctlAp.getParentId()) || ctlAp.isHidden() || ctlAp.isInvisible() || !ctlAp.getVisible().contains("init")) continue;
            int visibleValue = ctlAp.getVisibleValue();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            int n = statusVal = this.getView() instanceof BillView ? ((BillShowParameter)formShowParameter).getBillStatus().getValue() : formShowParameter.getStatus().getValue();
            if (statusVal == 0 && (visibleValue & 1) != 1 || statusVal == 1 && (visibleValue & 2) != 2 || statusVal == 2 && (visibleValue & 4) != 4 || statusVal == 4 && (visibleValue & 0x10) != 16 || statusVal == 5 && (visibleValue & 0x20) != 32) continue;
            LocaleString name = ctlAp.getName();
            String textAlign = ctlAp.getTextAlign();
            String key = ctlAp.getKey();
            int width = 0;
            if (ctlAp.getWidth() != null) {
                for (Map.Entry entry : ctlAp.getWidth().entrySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue())) || ((String)entry.getValue()).contains("%")) continue;
                    width = Integer.parseInt(((String)entry.getValue()).replace("px", "").split("\\.")[0]);
                    break;
                }
            }
            GridConfigurationRow bean = new GridConfigurationRow(name, width, textAlign, key);
            if (ctlAp instanceof EntryFieldGroupAp) {
                EntryFieldGroupAp fieldGroupAp = (EntryFieldGroupAp)ctlAp;
                bean.setChildren(this.buildGridConfiguration(fieldGroupAp.getItems(), ctlAp.getId()));
            }
            bean = this.buildGridConfigFlex(ctlAp, bean);
            currentFields.add(bean);
        }
        return currentFields;
    }

    private GridConfigurationRow buildGridConfigFlex(ControlAp<?> ctlAp, GridConfigurationRow bean) {
        String flexSplitCols;
        if (ctlAp instanceof EntryFieldAp && ((EntryFieldAp)ctlAp).isNeedSplit() && StringUtils.isNotBlank((CharSequence)(flexSplitCols = this.getView().getPageCache().get(ctlAp.getKey() + ".splitCols")))) {
            FlexSplitColsCache flexSplitColsCache = (FlexSplitColsCache)SerializationUtils.fromJsonString((String)flexSplitCols, FlexSplitColsCache.class);
            ArrayList<GridConfigurationRow> flexChildren = new ArrayList<GridConfigurationRow>(8);
            for (FlexSplitColumn splitColumn : flexSplitColsCache.getAllSplitColumnSet()) {
                LocaleString columnName = splitColumn.getColumnName();
                String dataIndex = (String)splitColumn.getDataIndex();
                flexChildren.add(new GridConfigurationRow(columnName, 0, "default", dataIndex));
            }
            if (!flexChildren.isEmpty()) {
                FlexGridConfigRow row = new FlexGridConfigRow();
                row.copy(bean);
                row.setDefaultSplit(((EntryFieldAp)ctlAp).isDefaultSplit());
                row.setChildren(flexChildren);
                return row;
            }
        }
        return bean;
    }

    private List<GridConfigurationRow> combineRuntimeMeta(List<GridConfigurationRow> metaGridConfig, List<GridConfigurationRow> userGridConfig, List<GridConfigurationRow> flexGridConfig) {
        if (CollectionUtils.isEmpty(metaGridConfig)) {
            return metaGridConfig;
        }
        Map colsMetaMap = metaGridConfig.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, Function.identity(), (o, o2) -> o, LinkedHashMap::new));
        if (CollectionUtils.isEmpty(userGridConfig)) {
            for (GridConfigurationRow row : colsMetaMap.values()) {
                this.visitFlexGridConfig(row, flexGridConfig);
            }
            return metaGridConfig;
        }
        ArrayList<GridConfigurationRow> newMeta = new ArrayList<GridConfigurationRow>(metaGridConfig.size());
        for (GridConfigurationRow userConfig : userGridConfig) {
            String fieldKey = userConfig.getFieldKey();
            GridConfigurationRow colMeta = (GridConfigurationRow)colsMetaMap.get(fieldKey);
            if (colMeta == null) continue;
            this.visitFlexGridConfig(colMeta, userConfig, flexGridConfig);
            userConfig.setFieldName(colMeta.getFieldName());
            newMeta.add(userConfig);
            List children = colMeta.getChildren();
            userConfig.setChildren(this.combineRuntimeMeta(children, userConfig.getChildren(), flexGridConfig));
            colsMetaMap.remove(fieldKey);
        }
        for (GridConfigurationRow row : colsMetaMap.values()) {
            this.visitFlexGridConfig(row, flexGridConfig);
            newMeta.add(row);
        }
        return newMeta;
    }

    private void visitFlexGridConfig(GridConfigurationRow metaRow, List<GridConfigurationRow> flexGridConfig) {
        this.visitFlexGridConfig(metaRow, null, flexGridConfig);
    }

    private void visitFlexGridConfig(GridConfigurationRow metaRow, GridConfigurationRow userRow, List<GridConfigurationRow> flexGridConfig) {
        if (metaRow instanceof FlexGridConfigRow) {
            if (userRow != null) {
                metaRow.setFlexSplit(userRow.getFlexSplit());
            }
            flexGridConfig.add(metaRow);
        }
    }
}

