/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.form.IFormView;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.form.IFormController;
import kd.bos.report.IReportView;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Refresh
extends DefaultDynamicFormOperate {
    private static final String REPORT_LIST_AP = "reportlistap";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String BILL_STATUS = "billstatus";
    private static final String AUDIT = "C";

    public boolean needSelectData() {
        return false;
    }

    @Override
    public OperationResult invokeOperation() {
        IFormView view = this.getView();
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            ITreeListView treeListView = listView.getTreeListView();
            if (treeListView != null) {
                treeListView.getTreeView().setRootVisible(true);
                treeListView.refresh();
            } else {
                listView.clearSelection();
                listView.refresh();
            }
        } else if (view instanceof IReportView) {
            ((IReportView)view).refresh();
        } else {
            IFormController formController = (IFormController)this.getView().getService(IFormController.class);
            if (formController != null) {
                BillShowParameter billShowParameter;
                if (view instanceof IBillView && !this.isCopyNew(billShowParameter = (BillShowParameter)view.getFormShowParameter())) {
                    if (this.isAddNew(billShowParameter)) {
                        billShowParameter.setPkId(null);
                    } else {
                        BillModel model = (BillModel)view.getService(IDataModel.class);
                        Object pkValue = model.getPKValue();
                        ISimpleProperty pkProp = model.getDataEntityType().getPrimaryKey();
                        if (pkProp instanceof IValidatorHanlder && !((IValidatorHanlder)pkProp).getValueComparator().compareValue(pkValue)) {
                            billShowParameter.setPkId(pkValue);
                        }
                    }
                }
                formController.loadData();
            }
        }
        return null;
    }

    private boolean isAddNew(BillShowParameter billShowParameter) {
        return billShowParameter.getBillStatus() == BillOperationStatus.ADDNEW;
    }

    private boolean isCopyNew(BillShowParameter billShowParameter) {
        if (billShowParameter.getBillStatus() != BillOperationStatus.ADDNEW) {
            return false;
        }
        if (!billShowParameter.getCustomParams().containsKey("iscopy")) {
            return false;
        }
        return billShowParameter.getCustomParams().containsKey("iscopy");
    }
}

