/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.listop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.DefaultBillFormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.NavigationCache;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.IListView;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.form.IFormController;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListController;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.beanutils.ConvertUtils;

public class Navigation
extends DefaultBillFormOperate
implements IConfirmCallBack {
    protected List<Object> currentListPagePKValues;
    private Integer currentPageIndex;
    private static final String CALLBACKVALUE_OPERATIONKEY = "operateKey";
    private static final String CALLBACKVALUE_ENTITYID = "entityId";
    public static final String BOS_FORM_BUSINESS = "bos-form-business";

    @Override
    protected boolean beforeInvokeOperation(OperationResult result) {
        boolean hasChecked = Boolean.parseBoolean(this.getOption().getVariableValue("hasChecked", String.valueOf(false)));
        if (!hasChecked && this.checkDataChanged()) {
            this.doConfirm();
            result.setSuccess(false);
            return false;
        }
        int currListPage = this.getCurrentListPage();
        if (currListPage == 0) {
            return false;
        }
        if (this.doNavigation()) {
            return super.beforeInvokeOperation(result);
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes) {
            String callbackValue = evt.getCustomVaule();
            Map map = (Map)SerializationUtils.fromJsonString((String)callbackValue, Map.class);
            String operationKey = map.get(CALLBACKVALUE_OPERATIONKEY).toString();
            OperateOption option = OperateOption.create();
            option.setVariableValue("hasChecked", String.valueOf(true));
            this.getView().invokeOperation(operationKey, option);
        }
    }

    private void doConfirm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IConfirmCallBack)this);
        confirmCallBacks.setOperationKey(this.getOperateKey());
        HashMap<String, String> callbackValue = new HashMap<String, String>();
        callbackValue.put(CALLBACKVALUE_OPERATIONKEY, this.getOperateKey());
        callbackValue.put(CALLBACKVALUE_ENTITYID, this.getEntityId());
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"Navigation_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c", (String)"Navigation_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"Navigation_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        this.getView().showConfirm(msg, this.getView().getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(callbackValue));
    }

    @Override
    protected void initPkValue() {
    }

    public final boolean callNavigation() {
        return this.doNavigation();
    }

    protected boolean doNavigation() {
        return true;
    }

    @Override
    protected String getMutexOperateKey() {
        return "modify";
    }

    private BillOperationStatus getFormStatus() {
        BillOperationStatus formStatus = BillOperationStatus.EDIT;
        if (this.getPKValue() == null) {
            return formStatus;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        if (!(mainType instanceof BillEntityType)) {
            return formStatus;
        }
        if (StringUtils.isBlank((CharSequence)((BillEntityType)mainType).getBillStatus())) {
            return formStatus;
        }
        ORM orm = ORM.create();
        String statusKey = ((BillEntityType)mainType).getBillStatus();
        QFilter qFilter = new QFilter("id", "=", this.getPKValue());
        try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getSimpleName(), this.getEntityId(), statusKey, new QFilter[]{qFilter});){
            if (ds.hasNext()) {
                Row row = ds.next();
                String statusValue = row.getString(statusKey);
                if (StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)statusValue)) {
                    formStatus = BillOperationStatus.SUBMIT;
                } else if (StringUtils.equalsIgnoreCase((CharSequence)"C", (CharSequence)statusValue)) {
                    formStatus = BillOperationStatus.AUDIT;
                }
            }
        }
        return formStatus;
    }

    @Override
    protected boolean checkDataMutex() {
        MutexHelper.release((IFormView)this.getView());
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        FormRoot rootControl = (FormRoot)this.getView().getRootControl();
        BillOperationStatus formStatus = this.getFormStatus();
        if ((formStatus == BillOperationStatus.AUDIT || formStatus == BillOperationStatus.SUBMIT) && MutexHelper.allFieldWithRequiredLock((IClientViewProxy)service, (List)rootControl.getItems(), (BillOperationStatus)formStatus, (MainEntityType)this.getView().getModel().getDataEntityType())) {
            this.isMutexLocked = true;
            this.existMutexNetGroup = false;
            return this.isMutexLocked;
        }
        if (this.getOption().containsVariable("isStrict")) {
            this.getOption().removeVariable("isStrict");
        }
        if (!super.checkDataMutex()) {
            if (StringUtils.isNotBlank((CharSequence)this.lockInfoStr)) {
                this.getView().showTipNotification(this.lockInfoStr);
            }
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        return true;
    }

    protected void doFailCheckRight(OperationResult result) {
        this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        super.doFailCheckRight(result);
    }

    @Override
    public OperationResult invokeOperation() {
        if (this.isMutexLocked) {
            String objId = String.valueOf(this.pkValue);
            AutoReleaseLock.create().register(objId, this.getEntityId(), this.getMutexOperateKey());
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put("MUTEX_ENTITY_KEY", this.getEntityId());
            pageCache.put("MUTEX_OPER_KEY", this.getMutexOperateKey());
            pageCache.put("MUTEX_OBJ_ID", objId);
        }
        this.releaseControl();
        this.modelLoadPk();
        this.setMainOrg();
        return super.invokeOperation();
    }

    protected boolean loadNextPageData(Integer pageIndex) {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("navigation_billids")) {
            return false;
        }
        int currPageIndex = this.getCurrentListPage();
        if (currPageIndex == pageIndex) {
            return true;
        }
        List<Object> currPagePKValues = this.getCurrentListPagePKValues();
        HashSet<String> sets = new HashSet<String>(currPagePKValues.size());
        for (Object pkValue : currPagePKValues) {
            sets.add(pkValue.toString());
        }
        ArrayList<Object> nextPagePKValues = NavigationCache.getPKValuesByPage((IFormView)this.getView(), (int)pageIndex);
        if (nextPagePKValues == null) {
            IFormView parentView = this.getView().getView(this.getView().getFormShowParameter().getParentPageId());
            if (parentView == null) {
                return false;
            }
            AbstractListView abstractListView = (AbstractListView)parentView;
            AbstractGrid.GridState state = abstractListView.getGridState();
            ListController listController = (ListController)parentView.getService(IFormController.class);
            DynamicObjectCollection rowObjectCollection = listController.getData((pageIndex - 1) * state.getPageRows(), state.getPageRows().intValue());
            if (rowObjectCollection == null || rowObjectCollection.isEmpty()) {
                return false;
            }
            nextPagePKValues = new ArrayList<Object>(10);
            ISimpleProperty pkProperty = abstractListView.getListModel().getDataEntityType().getPrimaryKey();
            for (DynamicObject rowObject : rowObjectCollection) {
                Object pkValue = pkProperty.getValue((Object)rowObject);
                if (sets.contains(pkValue.toString())) continue;
                sets.add(pkValue.toString());
                nextPagePKValues.add(pkValue);
            }
        }
        if (!nextPagePKValues.isEmpty()) {
            NavigationCache.putPKValuesByPage((IFormView)this.getView(), (int)currPageIndex, this.currentListPagePKValues);
            this.currentPageIndex = pageIndex;
            this.currentListPagePKValues = nextPagePKValues;
            NavigationCache.putCachePKValues((IFormView)this.getView(), this.currentListPagePKValues);
            NavigationCache.putCachePageIndex((IFormView)this.getView(), (int)this.currentPageIndex);
            return true;
        }
        return false;
    }

    protected List<Object> getCurrentListPagePKValues() {
        if (this.currentListPagePKValues == null) {
            this.currentListPagePKValues = NavigationCache.getPKValuesFromCache((IFormView)this.getView());
        }
        if (this.currentListPagePKValues == null) {
            this.currentListPagePKValues = NavigationCache.getPKValuesFromListPage((IFormView)this.getView());
            NavigationCache.putCachePKValues((IFormView)this.getView(), this.currentListPagePKValues);
        }
        return this.currentListPagePKValues;
    }

    public int getCurrentListPage() {
        if (this.currentPageIndex == null) {
            this.currentPageIndex = NavigationCache.getCachePageIndex((IFormView)this.getView());
        }
        if (this.currentPageIndex == null && this.getView().getFormShowParameter().getCustomParams().containsKey("navigation_billids")) {
            this.currentPageIndex = 1;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (this.currentPageIndex == null && parentView instanceof AbstractListView && StringUtil.equalsIgnoreCase((String)this.getEntityId(), (String)((IListView)parentView).getListModel().getEntityId())) {
            AbstractListView abstractListView = (AbstractListView)parentView;
            AbstractGrid.GridState state = abstractListView.getGridState();
            this.currentPageIndex = state.getCurrentPageIndex();
            if (this.currentPageIndex != null) {
                NavigationCache.putCachePageIndex((IFormView)this.getView(), (int)this.currentPageIndex);
            }
        }
        if (this.currentPageIndex == null) {
            return 0;
        }
        return this.currentPageIndex;
    }

    protected Object getPKByRowKey(int rowKey) {
        if (rowKey < 0 || rowKey > this.getCurrentListPagePKValues().size() - 1) {
            return null;
        }
        return this.getCurrentListPagePKValues().get(rowKey);
    }

    protected int getCurrentRowIndex() {
        int index;
        Object cachePKValue;
        List<Object> pkValues = this.getCurrentListPagePKValues();
        if (pkValues.isEmpty()) {
            return -1;
        }
        Object modelPKValue = ((IBillModel)this.getView().getModel()).getPKValue();
        if (modelPKValue != null) {
            for (int index2 = 0; index2 < pkValues.size(); ++index2) {
                Object pkValue = pkValues.get(index2);
                if (!StringUtils.equals((CharSequence)modelPKValue.toString(), (CharSequence)pkValue.toString())) continue;
                return index2;
            }
        }
        if ((cachePKValue = NavigationCache.getCachePKValue((IFormView)this.getView())) != null && (index = pkValues.indexOf(cachePKValue)) >= 0) {
            return index;
        }
        return 0;
    }

    protected boolean isExists(Object pkValue) {
        return QueryServiceHelper.exists((String)this.getEntityId(), (Object)pkValue);
    }

    private void modelLoadPk() {
        if (this.pkValue.getClass() != this.getView().getModel().getDataEntityType().getPrimaryKey().getPropertyType()) {
            this.pkValue = ConvertUtils.convert((Object)this.pkValue, (Class)this.getView().getModel().getDataEntityType().getPrimaryKey().getPropertyType());
        }
        ((IBillView)this.getView()).load(this.pkValue);
        NavigationCache.putCachePKValue((IFormView)this.getView(), (Object)this.pkValue);
    }

    private void setMainOrg() {
        DynamicObject obj;
        String mianOrg = this.getView().getModel().getDataEntityType().getMainOrg();
        if (mianOrg != null && (obj = (DynamicObject)this.getView().getModel().getValue(mianOrg)) != null) {
            this.mainOrgId = (Long)obj.getPkValue();
        }
    }

    private void releaseControl() {
        this.releaseControls(((FormView)this.getView()).getRootControl().getItems());
    }

    private void releaseControls(List<Control> list) {
        for (Control ctl : list) {
            ctl.release();
            if (!(ctl instanceof Container)) continue;
            this.releaseControls(((Container)ctl).getItems());
        }
    }

    private boolean checkDataChanged() {
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.VIEW || showParameter.getBillStatus() == BillOperationStatus.VIEW) {
            return false;
        }
        if (showParameter.getBillStatus() == BillOperationStatus.AUDIT && !(this.getView().getModel().getDataEntityType() instanceof BasedataEntityType)) {
            return false;
        }
        this.getView().getModel().removeContextVariable("bos_datachanged_skipnofield");
        return this.getView().getModel().getDataChanged() && StringUtils.isNotBlank((CharSequence)this.getView().getModel().getChangeDesc());
    }

    @Override
    protected boolean checkSpecialDataPerm(StringBuilder errorInfo) {
        String operateType = this.getType();
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            this.setType("modify");
        } else {
            this.setType("view");
        }
        this.getView().getPageCache().put(FormShowParameter.class.getSimpleName(), FormShowParameter.toJsonString((FormShowParameter)this.getView().getFormShowParameter()));
        boolean hasSpecialDataPerm = super.checkSpecialDataPerm(errorInfo);
        this.setType(operateType);
        return hasSpecialDataPerm;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        if (opResult != null && opResult.isSuccess() && this.getView() instanceof IBillView && MutexHelper.isOpenIntentLocks()) {
            MutexHelper.releaseAndApplyIntent((IFormView)this.getView(), (StringBuilder)new StringBuilder());
        }
    }
}

