/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.mobileop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileSearch;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

public class MobToolBarCancel
extends DefaultDynamicFormOperate {
    private static final String CANCEL = "cancel";

    public boolean needSelectData() {
        return false;
    }

    @Override
    public OperationResult invokeOperation() {
        if (this.getView() instanceof IMobileView) {
            this.updateMobileSearch();
            this.updateBillList();
            this.updateBarItem();
        }
        return null;
    }

    private void updateMobileSearch() {
        IFormView view = this.getView();
        if (view instanceof MobileListView) {
            MobileSearch mobileSearch = (MobileSearch)view.getControl("mobilesearchap");
            if (mobileSearch == null) {
                return;
            }
            HashMap<String, Integer> mobileSearchMeta = new HashMap<String, Integer>(1);
            mobileSearchMeta.put("showModel", mobileSearch.getMobileShowModel());
            view.updateControlMetadata("mobilesearchap", mobileSearchMeta);
        }
    }

    private void updateBillList() {
        IFormView view = this.getView();
        if (view instanceof MobileListView) {
            MobileListView mobileListView = (MobileListView)view;
            BillList billList = (BillList)this.getView().getControl("billlistap");
            if (billList == null) {
                return;
            }
            HashMap<String, Boolean> billListMeta = new HashMap<String, Boolean>(1);
            if (mobileListView.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter listShowParameter = (ListShowParameter)mobileListView.getFormShowParameter();
                billListMeta.put("ismul", listShowParameter.isMultiSelect() && billList.isMulti());
                this.getView().updateControlMetadata("billlistap", billListMeta);
            }
            mobileListView.getClientProxy().invokeControlMethod(billList.getKey(), "setCardSelectStatus", new Object[]{false});
            mobileListView.clearSelection();
        }
    }

    private void updateBarItem() {
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String str = metadataService.loadFormRuntimeMeta(this.getEntityId(), RuntimeMetaType.MobList.getValue(), "mtoolbarap");
        Map meta = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        if (CollectionUtils.isEmpty((Map)meta)) {
            return;
        }
        Object items = meta.get("items");
        if (items == null) {
            return;
        }
        List itemList = (List)items;
        ArrayList<String> hideKeys = new ArrayList<String>(itemList.size());
        ArrayList<String> showKeys = new ArrayList<String>(itemList.size());
        for (Map item : itemList) {
            Object interactionType = item.get("it");
            if (CANCEL.equals(item.get("opk")) || interactionType != null && (Integer)interactionType == 1) {
                hideKeys.add(item.get("id").toString());
                continue;
            }
            showKeys.add(item.get("id").toString());
        }
        this.getView().setVisible(Boolean.valueOf(true), showKeys.toArray(new String[showKeys.size()]));
        this.getView().setVisible(Boolean.valueOf(false), hideKeys.toArray(new String[hideKeys.size()]));
    }
}

