/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AutoGenerateAIServicePlugin
extends AbstractFormPlugin {
    private static final String KEY_BIZ_OBJ = "bizObj";
    private static final String KEY_BIZ_OBJS = "bizobjs";
    private static final String KEY_BTN_GENERATE = "generate";
    private static final String FORMID_AISERVICE = "open_apiservice";
    private static Map<String, String> EMBED_OPERATION = new HashMap<String, String>();
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_GENERATE});
    }

    private void generateAIService(String formId, String formName, String appId) {
        BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)FORMID_AISERVICE);
        ArrayList<DynamicObject> data = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, String> opInfo : EMBED_OPERATION.entrySet()) {
            DynamicObject dymObj = (DynamicObject)dt.createInstance();
            dymObj.set("number", (Object)(formId + "_" + opInfo.getKey()));
            dymObj.set("name", (Object)(formName + "_" + opInfo.getValue()));
            dymObj.set("discription", (Object)String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u7684API\u670d\u52a1", (String)"AutoGenerateAIServicePlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), formName, opInfo.getValue()));
            dymObj.set("bizobject", (Object)formId);
            dymObj.set("appid", (Object)appId);
            dymObj.set("operation", (Object)opInfo.getKey());
            dymObj.set("apiservicetype", (Object)"operation");
            dymObj.set("httpmethod", (Object)"GET");
            dymObj.set("contenttype", (Object)"application/json");
            dymObj.set("enable", (Object)"1");
            dymObj.set("status", (Object)"B");
            data.add(dymObj);
        }
        SaveServiceHelper.save((DynamicObject[])data.toArray(new DynamicObject[data.size()]));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f", (String)"AutoGenerateAIServicePlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        if (KEY_BTN_GENERATE.equals(button.getKey())) {
            DynamicObjectCollection bizObjs = (DynamicObjectCollection)this.getModel().getValue(KEY_BIZ_OBJS);
            for (DynamicObject dynamicObject : bizObjs) {
                DynamicObject bizObj = (DynamicObject)dynamicObject.get(1);
                String formId = bizObj.getPkValue().toString();
                DynamicObject bizApp = (DynamicObject)bizObj.get("bizappid");
                String appId = bizApp.getPkValue().toString();
                String formName = bizObj.getString("name");
                this.generateAIService(formId, formName, appId);
            }
        }
    }

    static {
        EMBED_OPERATION.put("load", ResManager.loadKDString((String)"\u52a0\u8f7d", (String)"AutoGenerateAIServicePlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        EMBED_OPERATION.put("query", ResManager.loadKDString((String)"\u67e5\u8be2", (String)"AutoGenerateAIServicePlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        EMBED_OPERATION.put("delete", ResManager.loadKDString((String)"\u5220\u9664", (String)"AutoGenerateAIServicePlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        EMBED_OPERATION.put("save", ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AutoGenerateAIServicePlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        EMBED_OPERATION.put("batchsave", ResManager.loadKDString((String)"\u6279\u91cf\u4fdd\u5b58", (String)"AutoGenerateAIServicePlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
    }
}

