/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mservice.svc.picture.IImage;

public class BillCommentPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String SENDCOMMENT = "sendcomment";
    private static final String TEXTAREAFIELD = "textareafield";

    public void initialize() {
        this.addClickListeners(new String[]{SENDCOMMENT, "send"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TEXTAREAFIELD, "send"});
    }

    public void afterBindData(EventObject e) {
        String userId = RequestContext.get().getUserId();
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)userId)};
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("select t1.FAvatar \n");
        sbSQL.append("from t_sec_User t1 \n");
        sbSQL.append("where t1.fid=? \n");
        String sql = sbSQL.toString();
        Object objUser = DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>();
                try {
                    if (rs.next()) {
                        HashMap<String, String> mpUser = new HashMap<String, String>();
                        mpUser.put("ImgUrl", rs.getString(1));
                        list.add(mpUser);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return list;
            }
        });
        if (StringUtils.isBlank((Object)objUser)) {
            objUser = "";
        }
        String imgURL = "";
        if (objUser instanceof Map) {
            Map mpUser = (Map)objUser;
            imgURL = (String)mpUser.get("ImgUrl");
        }
        IImage icon = (IImage)this.getView().getControl("btnaccount");
        icon.setUrl(imgURL);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (SENDCOMMENT.equalsIgnoreCase(key)) {
            this.setSendCommentVisible();
        } else if ("send".equalsIgnoreCase(key)) {
            this.send();
        }
    }

    private void setSendCommentVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{SENDCOMMENT});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"send", TEXTAREAFIELD});
    }

    private void send() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{SENDCOMMENT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"send", TEXTAREAFIELD});
    }
}

