/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.flex.FlexService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.CoreBusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.JSONUtils;

public class FlexBatchInputPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(FlexBatchInputPlugin.class);
    private String parentFormId;
    private int flexTypeId;
    private String parentPageId;
    private String flexEditKey;
    private String appId;
    private String flexEditDisplayName;
    private List<Long> flexPropertyIds;
    private List<Map<String, Object>> flexPropertyMapList;
    private String flexEditValue;
    private FlexEntityType flexEntityType;
    private static final String FLEXDIM_PANNEL_KEY = "flexdimpannel";
    private static final String ASSISTANT_VALUE_TYPE = "2";
    private static final String FORMID_ASSISTANTDATAGROUP = "bos_assistantdatagroup";
    private static final String ASSISTANT_VALUE_SOURCE = "bos_assistantdata_detail";
    private static final String SIMPLE_VALUE_TYPE = "3";
    private static final String SIMPLE_VALUE_SPLIT = ",|;|\uff1b";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final int MAX_ROW_COUNT = 100;
    private static final Map<Integer, String> viMap = new HashMap<Integer, String>(6);
    private static final Map<Integer, String> lockMap = new HashMap<Integer, String>(5);

    private void initParams(FormShowParameter parameter) {
        this.parentFormId = parameter.getParentFormId();
        Map map = parameter.getCustomParams();
        this.appId = map.get("appId").toString();
        this.flexTypeId = (Integer)map.get("flexTypeId");
        this.parentPageId = map.get("pageId").toString();
        this.flexEditKey = map.get("flexEditKey").toString();
        this.flexEditDisplayName = map.get("flexEditDisplayName").toString();
        this.flexPropertyIds = (List)map.get("flexPropertyIds");
        this.flexPropertyMapList = (List)map.get("flexPropertyMapList");
        this.flexEditValue = map.get("flexEditValue").toString();
    }

    private FlexEntityType getFlexEntityType() {
        if (this.flexEntityType == null) {
            this.flexEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)this.parentFormId, (String)this.flexEditKey, (int)this.flexTypeId, this.flexPropertyIds);
        }
        return this.flexEntityType;
    }

    private FlexPanelAp createDynamicPanel() {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        FlexEntityType flexEntityType = this.getFlexEntityType();
        List flexProperties = flexEntityType.getFlexProperties();
        for (FlexProperty property : flexProperties) {
            String vi;
            String valueType = property.getValueType();
            FieldAp fieldAp = new FieldAp();
            fieldAp.setName(property.getName());
            fieldAp.setQuickAddNew(false);
            fieldAp.setFireUpdEvt(true);
            String lock = this.getClientMetaValue(lockMap, "l", property.getFlexField());
            if (StringUtils.isNotBlank((CharSequence)lock)) {
                fieldAp.setLock(lock);
            }
            if (StringUtils.isNotBlank((CharSequence)(vi = this.getClientMetaValue(viMap, "vi", property.getFlexField())))) {
                fieldAp.setVisible(vi);
            }
            if (valueType.equals(SIMPLE_VALUE_TYPE)) {
                fieldAp.setId(property.getFlexField());
                fieldAp.setKey(property.getFlexField());
                TextField field = new TextField();
                field.setName(property.getName());
                field.setId(property.getFlexField());
                field.setKey(property.getFlexField());
                field.setMustInput(this.getMustInput(property.getFlexField()));
                Tips tips = new Tips();
                tips.setContent(new LocaleString(String.format(ResManager.loadKDString((String)"\u591a\u4e2a\u503c\u8bf7\u4ee5\u201c%s\u201d\u5206\u9694", (String)"FlexBatchInputPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), SIMPLE_VALUE_SPLIT)));
                tips.setTriggerType("hover");
                tips.setType("text");
                fieldAp.setCtlTips(tips);
                fieldAp.setField((Field)field);
            } else {
                String valueSource = valueType.equals(ASSISTANT_VALUE_TYPE) ? ASSISTANT_VALUE_SOURCE : property.getValueSource();
                fieldAp.setId(property.getFlexField());
                fieldAp.setKey(property.getFlexField());
                fieldAp.setF7MultipleSelect(true);
                MulBasedataField field = new MulBasedataField();
                field.setId(property.getFlexField());
                field.setKey(property.getFlexField());
                field.setName(property.getName());
                field.setDisplayProp(property.getDisplayStyle().getDisplayProperty().toString());
                BasedataEntityType sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)valueSource);
                field.setBaseEntityId(sourceType.getEntityTypeId());
                field.setMustInput(this.getMustInput(property.getFlexField()));
                fieldAp.setField((Field)field);
            }
            headPanelAp.getItems().add(fieldAp);
        }
        return headPanelAp;
    }

    private void registerProps(MainEntityType mainEntityType) {
        FlexEntityType flexEntityType = this.getFlexEntityType();
        List flexProperties = flexEntityType.getFlexProperties();
        for (FlexProperty property : flexProperties) {
            String valueType = property.getValueType();
            if (valueType.equals(SIMPLE_VALUE_TYPE)) {
                TextProp prop = new TextProp();
                prop.setAlias(property.getFlexField());
                prop.setName(property.getFlexField());
                prop.setDisplayName(property.getName());
                prop.setDbIgnore(true);
                mainEntityType.addProperty((DynamicProperty)prop);
                continue;
            }
            String valueSource = valueType.equals(ASSISTANT_VALUE_TYPE) ? ASSISTANT_VALUE_SOURCE : property.getValueSource();
            BasedataEntityType sourceType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)valueSource);
            DynamicObjectType dynamicObjectType = new DynamicObjectType(property.getFlexField());
            dynamicObjectType.setAlias(property.getFlexField());
            dynamicObjectType.setDbIgnore(true);
            BasedataProp baseProp = new BasedataProp();
            baseProp.setBaseEntityId(sourceType.getName());
            baseProp.setAlias("FBasedataId");
            baseProp.setName("fbasedataid");
            baseProp.setDbIgnore(true);
            baseProp.setComplexType((IDataEntityType)sourceType);
            dynamicObjectType.addProperty((DynamicProperty)baseProp);
            LongProp baseIdProp = new LongProp();
            baseIdProp.setAlias("FBasedataId_Id");
            baseIdProp.setName("fbasedataid_id");
            baseIdProp.setDbIgnore(true);
            dynamicObjectType.addProperty((DynamicProperty)baseIdProp);
            MulBasedataProp prop = new MulBasedataProp();
            prop.setAlias(property.getFlexField());
            prop.setName(property.getFlexField());
            prop.setDisplayName(property.getName());
            prop.setBaseEntityId(sourceType.getName());
            prop.setItemType((IDataEntityType)dynamicObjectType);
            if (property.getOrgFunc() != 0L) {
                prop.setOrgFunc(property.getOrgFuncNumber());
            }
            mainEntityType.addProperty((DynamicProperty)prop);
        }
    }

    private List<Map<String, Object>> getCartesianValues(List<Tuple2<String, Object[]>> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        int rows = 1;
        for (Tuple2<String, Object[]> data : values) {
            rows *= ((Object[])data.t2).length;
        }
        int[] record = new int[values.size()];
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(rows);
        for (int i = 0; i < rows; ++i) {
            HashMap<Object, Object> row = new HashMap<Object, Object>(record.length);
            for (int index = 0; index < record.length; ++index) {
                Tuple2<String, Object[]> tupleValue = values.get(index);
                row.put(tupleValue.t1, ((Object[])tupleValue.t2)[record[index]]);
            }
            results.add(row);
            this.cartesianBacktracking(values, record, values.size() - 1);
        }
        return results;
    }

    private void cartesianBacktracking(List<Tuple2<String, Object[]>> values, int[] record, int level) {
        record[level] = record[level] + 1;
        if (record[level] >= ((Object[])values.get((int)level).t2).length && level > 0) {
            record[level] = 0;
            this.cartesianBacktracking(values, record, level - 1);
        }
    }

    private void checkDimValues(FlexProperty property, Object[] dataValues) {
        Object[] invalidValues = null;
        Object dataTypeObject = property.getDataTypeObject();
        if (dataTypeObject instanceof FlexProperty.FlexVarchar) {
            FlexProperty.FlexVarchar flexVarchar = (FlexProperty.FlexVarchar)dataTypeObject;
            if (flexVarchar.getLength() > 0) {
                invalidValues = Arrays.stream(dataValues).filter(x -> x.toString().length() > flexVarchar.getLength()).toArray();
            }
            if (invalidValues != null && invalidValues.length > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%3$s\u3002", (String)"FlexBatchInputPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{property.getName().getLocaleValue(), invalidValues[0], flexVarchar.getLength()}));
            }
        } else {
            FlexProperty.FlexDecimal flexDecimal = (FlexProperty.FlexDecimal)dataTypeObject;
            invalidValues = Arrays.stream(dataValues).filter(x -> {
                try {
                    BigDecimal decimal = new BigDecimal(x.toString());
                    String intStr = x.toString().split("\\.")[0];
                    return decimal.compareTo(flexDecimal.getMax()) > 0 || decimal.compareTo(flexDecimal.getMin()) < 0 || decimal.scale() != flexDecimal.getScale() || decimal.precision() > flexDecimal.getPrecision() || intStr.length() > 1 && intStr.startsWith("0");
                }
                catch (Exception ex) {
                    throw new KDBizException(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0d\u662f\u6570\u503c\u683c\u5f0f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FlexBatchInputPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{property.getName().getLocaleValue(), x.toString()}));
                }
            }).toArray();
            if (invalidValues.length > 0) {
                BigDecimal decimal = new BigDecimal(invalidValues[0].toString());
                String intStr = invalidValues[0].toString().split("\\.")[0];
                if (decimal.compareTo(flexDecimal.getMax()) > 0 || decimal.compareTo(flexDecimal.getMin()) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0d\u5f97\u8d85\u51fa\u6570\u503c\u8303\u56f4[%3$s,%4$s]\u3002", (String)"FlexBatchInputPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{property.getName().getLocaleValue(), invalidValues[0], flexDecimal.getMin().setScale(flexDecimal.getScale()).toString(), flexDecimal.getMax().setScale(flexDecimal.getScale()).toString()}));
                }
                if (intStr.length() > 1 && intStr.startsWith("0")) {
                    throw new KDBizException(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0d\u80fd\u4ee50\u5f00\u5934\u3002", (String)"FlexBatchInputPlugin_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{property.getName().getLocaleValue(), invalidValues[0]}));
                }
                if (decimal.precision() > flexDecimal.getPrecision()) {
                    throw new KDBizException(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u7684\u6574\u4f53\u7cbe\u5ea6\u4e0d\u5f97\u8d85\u8fc7%3$s\u3002", (String)"FlexBatchInputPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{property.getName().getLocaleValue(), invalidValues[0], flexDecimal.getPrecision()}));
                }
                if (decimal.scale() != flexDecimal.getScale()) {
                    throw new KDBizException(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u7684\u5c0f\u6570\u7cbe\u5ea6\u5fc5\u987b\u8f93\u5165%3$s\u4f4d\u3002", (String)"FlexBatchInputPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{property.getName().getLocaleValue(), invalidValues[0], flexDecimal.getScale()}));
                }
            }
        }
    }

    private List<Map<String, Object>> getCombinationData() {
        ArrayList<Tuple2<String, Object[]>> values = new ArrayList<Tuple2<String, Object[]>>();
        FlexEntityType flexEntityType = this.getFlexEntityType();
        for (FlexProperty property : flexEntityType.getFlexProperties()) {
            Object dataObj;
            String key = String.format("$$%s__%s", this.flexEditKey, property.getFlexField());
            if (property.getValueType().equals(SIMPLE_VALUE_TYPE)) {
                Object[] dataValues;
                dataObj = this.getModel().getValue(property.getFlexField());
                if (dataObj == null || (dataValues = Arrays.stream(dataObj.toString().split(SIMPLE_VALUE_SPLIT)).map(String::trim).filter(StringUtils::isNotBlank).toArray()).length <= 0) continue;
                this.checkDimValues(property, dataValues);
                values.add((Tuple2<String, Object[]>)new Tuple2((Object)key, (Object)dataValues));
                continue;
            }
            dataObj = (DynamicObjectCollection)this.getModel().getValue(property.getFlexField());
            if (dataObj == null || dataObj.size() <= 0) continue;
            values.add((Tuple2<String, Object[]>)new Tuple2((Object)key, (Object)dataObj.stream().map(DataEntityBase::getPkValue).toArray()));
        }
        return this.getCartesianValues(values);
    }

    private void updateEntryData() {
        List<Map<String, Object>> values = this.getCombinationData();
        if (values == null || values.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u503c\u3002", (String)"FlexBatchInputPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        if (values.size() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u6b21\u6279\u91cf\u5f55\u5165\u4e0d\u5f97\u8d85\u8fc7%s\u6761\u6570\u636e\uff0c\u8bf7\u51cf\u5c11\u9009\u9879\u540e\u518d\u8bd5\u3002", (String)"FlexBatchInputPlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{100}));
        }
        FlexEntityType flexEntityType = this.getFlexEntityType();
        List<Long> dataIds = this.batchSaveFlexData((MainEntityType)flexEntityType, values);
        this.getView().returnDataToParent(dataIds);
        this.getView().close();
    }

    private List<Long> batchSaveFlexData(MainEntityType flexEntityType, List<Map<String, Object>> values) {
        ArrayList<FlexEntireData> flexEntireDataList = new ArrayList<FlexEntireData>(values.size());
        for (Map<String, Object> value : values) {
            DynamicObject flexObject = new DynamicObject((DynamicObjectType)flexEntityType);
            DataEntityPropertyCollection properties = flexEntityType.getProperties();
            for (Map.Entry<String, Object> entry : value.entrySet()) {
                IDataEntityProperty newPproperty;
                String originKey = entry.getKey();
                IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)originKey);
                if (property == null) continue;
                Object dataValue = entry.getValue();
                if (property instanceof LongProp || property instanceof TextProp) {
                    property.setValue((Object)flexObject, dataValue);
                    continue;
                }
                String newKey = originKey;
                if (!newKey.contains("__id")) {
                    newKey = originKey + "_id";
                }
                if ((newPproperty = (IDataEntityProperty)properties.get((Object)newKey)) == null) continue;
                newPproperty.setValue((Object)flexObject, dataValue);
            }
            FlexEntireData flexEntireData = new FlexEntireData();
            flexEntireData.setFlexData(flexEntityType, flexObject);
            flexEntireDataList.add(flexEntireData);
        }
        FlexService.batchSaveFlexData((MainEntityType)flexEntityType, flexEntireDataList);
        return flexEntireDataList.stream().map(FlexEntireData::getId).collect(Collectors.toList());
    }

    private String getClientMetaValue(Map<Integer, String> map, String key, String id) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map<String, Object> item : this.flexPropertyMapList) {
            Object value;
            if (!item.get("id").toString().endsWith(id) || (value = item.get(key)) == null) continue;
            if (value instanceof Boolean) {
                value = (Boolean)value != false ? 1 : 0;
            }
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                if (((Integer)value & entry.getKey()) != entry.getKey()) continue;
                list.add(entry.getValue());
            }
        }
        return String.join((CharSequence)",", list);
    }

    private boolean getMustInput(String id) {
        for (Map<String, Object> item : this.flexPropertyMapList) {
            if (!item.get("id").toString().endsWith(id)) continue;
            Map map = (Map)item.get("item");
            return (Boolean)map.get("mi");
        }
        return false;
    }

    public void initialize() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.initParams(parameter);
        Label label = (Label)this.getControl("labelap");
        label.setText(String.format(ResManager.loadKDString((String)"%s\u6279\u91cf\u5f55\u5165", (String)"FlexBatchInputPlugin_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), this.flexEditDisplayName));
        Button btn = (Button)this.getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            this.updateEntryData();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String value = this.flexEditValue;
        FlexEntityType flexEntityType = this.getFlexEntityType();
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Map flexFieldValues = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
        for (FlexProperty property : flexEntityType.getFlexProperties()) {
            String flexField = property.getFlexField();
            if (!flexFieldValues.containsKey(flexField)) continue;
            if (property.getValueType().equals(SIMPLE_VALUE_TYPE)) {
                this.getView().getModel().setValue(property.getFlexField(), flexFieldValues.get(flexField));
                this.getView().updateView(property.getFlexField());
                continue;
            }
            Object flexValue = flexFieldValues.get(flexField);
            String valueSource = property.getValueType().equals(ASSISTANT_VALUE_TYPE) ? ASSISTANT_VALUE_SOURCE : property.getValueSource();
            MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)valueSource);
            DynamicObjectCollection flexFieldData = new DynamicObjectCollection();
            Map cacheValues = BusinessDataReader.loadFromCache((Object[])new Object[]{flexValue}, (DynamicObjectType)sourceType);
            if (cacheValues.size() <= 0) continue;
            Map.Entry entry = cacheValues.entrySet().iterator().next();
            Object key = entry.getKey();
            DynamicObject refObj = (DynamicObject)entry.getValue();
            if (!key.toString().equals(flexValue.toString())) {
                log.info(String.format("key not equal,type=%s,entryKey='%s',flexValue='%s'", sourceType.getName(), key, flexValue));
            }
            if (refObj == null) continue;
            flexFieldData.add((Object)refObj);
            this.getView().getModel().setValue(property.getFlexField(), (Object)flexFieldData);
            this.getView().updateView(property.getFlexField());
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        this.initParams(parameter);
        FlexPanelAp dynamicPanel = this.createDynamicPanel();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", FLEXDIM_PANNEL_KEY);
        map.put("items", (String)dynamicPanel.createControl().get("items"));
        e.getItems().add(map);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newEntityType;
        MainEntityType mainEntityType = e.getOriginalEntityType();
        try {
            newEntityType = (MainEntityType)mainEntityType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        this.registerProps(newEntityType);
        e.setNewEntityType(newEntityType);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        FlexEntityType flexEntityType = this.getFlexEntityType();
        for (FlexProperty property : flexEntityType.getFlexProperties()) {
            TextEdit edit;
            String valueType = property.getValueType();
            String propertyKey = property.getFlexField();
            if (!key.equals(propertyKey)) continue;
            if (valueType.equals(SIMPLE_VALUE_TYPE)) {
                edit = new TextEdit();
            } else {
                edit = new MulBasedataEdit();
                ((MulBasedataEdit)edit).setF7MultipleSelect(true);
                ((MulBasedataEdit)edit).addBeforeF7SelectListener(e -> {
                    List<QFilter> qFilters = this.getFlexItemFilter(propertyKey);
                    if (qFilters.size() > 0) {
                        e.setCustomQFilters(qFilters);
                    }
                    if (valueType.equals(ASSISTANT_VALUE_TYPE)) {
                        FormShowParameter parameter = e.getFormShowParameter();
                        parameter.setCaption(this.getGroupName(property.getName().getLocaleValue(), Long.parseLong(property.getAssistantType())));
                    }
                });
                ((MulBasedataEdit)edit).addAfterF7SelectListener(e -> ((MulBasedataEdit)e.getSource()).getView().updateView(propertyKey));
            }
            edit.setKey(propertyKey);
            edit.setEntryKey(propertyKey);
            edit.setView(this.getView());
            args.setControl((Control)edit);
            break;
        }
    }

    private List<QFilter> getFlexItemFilter(String controlKey) {
        try (EntityTraceSpan span = EntityTracer.create((String)"FlexBatchInput", (String)"getFlexItemFilter", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            ArrayList<QFilter> qFilters;
            block16: {
                String actionKey = String.format("getFlexItemFilter_%s", controlKey);
                String requestParams = String.format("[{\"key\":\"%s\",\"methodName\":\"getFlexItemFilter\",\"args\":[\"%s\",\"%s\"],\"postData\":[{},[]]}]", this.flexEditKey, controlKey, actionKey);
                String resultObject = (String)DispatchServiceHelper.invokeBOSService((String)(StringUtils.isBlank((CharSequence)this.appId) ? "bos" : this.appId), (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{this.parentPageId, requestParams});
                if (span.isRealtime()) {
                    span.addTag("controlKey", controlKey);
                    span.addTag("requestParams", requestParams);
                    span.addTag("actionResult", resultObject);
                }
                qFilters = new ArrayList<QFilter>();
                try {
                    List list = (List)JSONUtils.cast((String)resultObject, List.class);
                    if (list == null || list.size() <= 0) break block16;
                    for (Object obj : list) {
                        LinkedHashMap map = (LinkedHashMap)obj;
                        if (!map.get("a").equals(actionKey)) continue;
                        ArrayList filters = (ArrayList)map.get("p");
                        List value = (List)JSONUtils.cast((String)filters.get(0).toString(), List.class);
                        value.forEach(x -> qFilters.add(QFilter.fromSerializedString((String)x)));
                        break;
                    }
                }
                catch (Exception e) {
                    log.error(String.format("getFlexItemFilter error,flexEditKey:%s,controlKey:%s,filterValue:%s", this.flexEditKey, controlKey, resultObject), (Throwable)e);
                }
            }
            ArrayList<QFilter> arrayList = qFilters;
            return arrayList;
        }
    }

    private String getGroupName(String name, Long groupId) {
        DynamicObject groupObj;
        if (groupId != null && (groupObj = CoreBusinessDataServiceHelper.loadSingleFromCache((Object)groupId, (String)FORMID_ASSISTANTDATAGROUP, (String)"id, name")) != null) {
            ILocaleString localeName = groupObj.getLocaleString("name");
            name = localeName != null ? localeName.getLocaleValue() : name;
        }
        return name;
    }

    static {
        viMap.put(1, "new");
        viMap.put(2, "edit");
        viMap.put(4, "view");
        viMap.put(8, "init");
        viMap.put(16, "submit");
        viMap.put(32, "audit");
        lockMap.put(1, "new");
        lockMap.put(2, "edit");
        lockMap.put(4, "view");
        lockMap.put(16, "submit");
        lockMap.put(32, "audit");
    }
}

