/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.commonfield.Field;

public class MobileFormConfigPlugin
extends AbstractBasePlugIn {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ISHEADFIELD = "isheadfield";
    private static final String FIELDKEY = "fieldkey";
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDTYPE = "fieldtype";
    private static final String ENTRYLOCATION = "entrylocation";
    private static final String BILLTYPE_ID = "billtype_id";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockHeadField();
    }

    private void lockHeadField() {
        int index = 0;
        DynamicObjectCollection entryCollections = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject dynamicObject : entryCollections) {
            if (dynamicObject.getBoolean(ISHEADFIELD)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"fieldpercent", "fontcolor", "fontsize"});
            }
            ++index;
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FIELDKEY});
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"billtyperefesh"});
    }

    public void click(EventObject evt) {
        if (FIELDKEY.equals(((Control)evt.getSource()).getKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId("ide_addprop");
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "selectCallBack");
            showParameter.setCloseCallBack(callBack);
            showParameter.setCustomParam("fields", this.getFieldsLeft());
            this.getView().showForm(showParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("preview".equals(evt.getItemKey())) {
            Long mobileConfigId = (Long)this.getModel().getDataEntityType().getPrimaryKey().getValueFast((Object)this.getModel().getDataEntity());
            if (mobileConfigId <= 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u9884\u89c8\uff01", (String)"MobileFormConfigPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            if (!"C".equals(this.getView().getModel().getValue("status"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u9884\u89c8\uff01", (String)"MobileFormConfigPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("formId", "bos_mobilepreview");
            para.put("mobileConfigId", mobileConfigId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.setCustomParam("number", (Object)"bos_mobileform");
            showParameter.setCustomParam("modelType", (Object)"MobileBillFormModel");
            showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            showParameter.setClientParam("preview", (Object)"true");
            this.getView().showForm(showParameter);
        } else if ("billtyperefesh".equals(evt.getItemKey())) {
            this.listHeadFields();
            this.listEntryFields();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map field;
        if ("selectCallBack".equals(evt.getActionId()) && (field = (Map)evt.getReturnData()) != null) {
            IDataModel model = this.getModel();
            model.setValue(FIELDKEY, field.get(FIELDKEY));
            model.setValue(FIELDNAME, field.get(FIELDNAME));
            model.setValue(ISHEADFIELD, field.get(ISHEADFIELD));
            model.setValue(FIELDTYPE, field.get(FIELDTYPE));
            model.setValue(ENTRYLOCATION, field.get(ENTRYLOCATION));
            this.getView().updateView();
            this.lockHeadField();
        }
    }

    private Object getFieldsLeft() {
        IDataModel model = this.getModel();
        String number = (String)model.getValue(BILLTYPE_ID);
        if (StringUtils.isNotBlank((CharSequence)number)) {
            MetadataReader reader = new MetadataReader();
            String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
            List entities = entityMetadata.getRootEntity().getItems();
            ArrayList<String> currFields = new ArrayList<String>(10);
            for (int row = model.getEntryRowCount(ENTRYENTITY) - 1; row >= 0; --row) {
                currFields.add((String)model.getValue(FIELDKEY, row));
            }
            ArrayList leftFields = new ArrayList();
            for (EntityItem entity : entities) {
                if (entity instanceof Field && !currFields.contains(entity.getKey())) {
                    HashMap<String, Object> field = new HashMap<String, Object>();
                    field.put(FIELDKEY, entity.getKey());
                    field.put(FIELDNAME, entity.getName());
                    field.put(ISHEADFIELD, true);
                    field.put(FIELDTYPE, entity.getClass().getName().substring(entity.getClass().getName().lastIndexOf(".") + 1));
                    leftFields.add(field);
                    continue;
                }
                if (!(entity instanceof EntryEntity)) continue;
                EntryEntity entry = (EntryEntity)entity;
                for (EntityItem item : entry.getItems()) {
                    if (currFields.contains(item.getKey()) || item instanceof SubEntryEntity) continue;
                    HashMap<String, Object> field = new HashMap<String, Object>();
                    field.put(FIELDKEY, item.getKey());
                    field.put(FIELDNAME, item.getName());
                    field.put(ISHEADFIELD, false);
                    field.put(FIELDTYPE, item.getClass().getName().substring(item.getClass().getName().lastIndexOf(".") + 1));
                    field.put(ENTRYLOCATION, entry.getKey());
                    leftFields.add(field);
                }
            }
            return leftFields;
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldId = e.getProperty().getName();
        if ("billtype".equals(fieldId)) {
            this.listHeadFields();
            this.listEntryFields();
        }
    }

    private void listEntryFields() {
        IDataModel model = this.getModel();
        String number = (String)model.getValue(BILLTYPE_ID);
        if (StringUtils.isNotBlank((CharSequence)number)) {
            MetadataReader reader = new MetadataReader();
            String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
            for (EntityItem entity : entityMetadata.getRootEntity().getItems()) {
                if (!(entity instanceof EntryEntity)) continue;
                EntryEntity entry = (EntryEntity)entity;
                for (EntityItem item : entry.getItems()) {
                    if (item instanceof SubEntryEntity) continue;
                    int row = model.createNewEntryRow(ENTRYENTITY);
                    model.setValue(FIELDKEY, (Object)item.getKey(), row);
                    model.setValue(FIELDNAME, (Object)item.getName(), row);
                    model.setValue(ISHEADFIELD, (Object)false, row);
                    model.setValue(FIELDTYPE, (Object)item.getClass().getName().substring(item.getClass().getName().lastIndexOf(".") + 1), row);
                    model.setValue(ENTRYLOCATION, (Object)entry.getKey(), row);
                }
            }
        }
    }

    private void listHeadFields() {
        String number = (String)this.getModel().getValue(BILLTYPE_ID);
        if (StringUtils.isNotBlank((CharSequence)number)) {
            MetadataReader reader = new MetadataReader();
            String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
            ArrayList<ComboItem> entries = new ArrayList<ComboItem>();
            List entities = entityMetadata.getRootEntity().getItems();
            IDataModel model = this.getModel();
            model.deleteEntryData(ENTRYENTITY);
            for (EntityItem entity : entities) {
                if (entity instanceof Field) {
                    int row = model.createNewEntryRow(ENTRYENTITY);
                    model.setValue(FIELDKEY, (Object)entity.getKey(), row);
                    model.setValue(FIELDNAME, (Object)entity.getName(), row);
                    model.setValue(ISHEADFIELD, (Object)true, row);
                    model.setValue(FIELDTYPE, (Object)entity.getClass().getName().substring(entity.getClass().getName().lastIndexOf(".") + 1), row);
                    this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"fieldpercent", "fontcolor", "fontsize"});
                    continue;
                }
                if (!(entity instanceof EntryEntity)) continue;
                EntryEntity entry = (EntryEntity)entity;
                entries.add(new ComboItem(entry.getName(), entry.getKey()));
            }
            ComboEdit entrySelect = (ComboEdit)this.getControl("entrymarkid");
            entrySelect.setComboItems(entries);
            if (!entries.isEmpty()) {
                this.getModel().setValue("entrymarkid", (Object)((ComboItem)entries.get(0)).getValue());
            }
        }
    }
}

