/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.ListSysPublicParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MultiTextDialogPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String CONTENT = "content_tag";
    private static final Log log = LogFactory.getLog(MultiTextDialogPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getView().getControl(KEY_BTNOK);
        btnok.addClickListener((ClickListener)this);
        Button btncancel = (Button)this.getView().getControl(KEY_BTNCANCEL);
        btncancel.addClickListener((ClickListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object operationType = this.getView().getFormShowParameter().getCustomParam("operateType");
        if (operationType == null) {
            Object value = this.getView().getFormShowParameter().getCustomParam("params");
            value = this.convertArrayToMultiValue(value);
            this.getView().returnDataToParent(value);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (btn.getKey().equalsIgnoreCase(KEY_BTNOK)) {
            Object value = this.getModel().getValue(CONTENT);
            if (StringUtils.isNotBlank((Object)value)) {
                String[] split = value.toString().split("\\n");
                Map maxcountforfiltertextfieldMap = (Map)ListSysPublicParameter.loadCustom((String)"maxcountforfiltertextfield");
                int maxcountforfiltertextfield = 10000;
                try {
                    maxcountforfiltertextfield = Integer.parseInt(maxcountforfiltertextfieldMap.getOrDefault("maxcountforfiltertextfield", "10000"));
                }
                catch (Exception ex) {
                    log.info(ex.getCause() != null ? ex.getCause().toString() : ex.getMessage());
                }
                if (split.length > maxcountforfiltertextfield) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8d85\u8fc7%s\u6761\u7684\u6570\u636e\u67e5\u8be2\uff0c\u8bf7\u5220\u9664\u90e8\u5206\u6570\u636e\u3002", (String)"MultiTextDialogPlugin_0", (String)"bos-form-business", (Object[])new Object[0]), maxcountforfiltertextfield));
                    return;
                }
            }
            this.getView().returnDataToParent(value);
            this.getView().getFormShowParameter().setCustomParam("operateType", (Object)KEY_BTNOK);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParam("params");
        value = this.convertArrayToMultiValue(value);
        this.getModel().setValue(CONTENT, value);
    }

    private Object convertArrayToMultiValue(Object value) {
        if (value == null || "".equals(value.toString().trim())) {
            return null;
        }
        List list = (List)value;
        StringBuilder sb = new StringBuilder();
        list.parallelStream().forEachOrdered(object -> sb.append(object).append("\n"));
        return sb.toString().trim();
    }
}

