/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;

public class ReportConfigPlugin
extends AbstractFormPlugin {
    private static final String KEY_HIDE = "hide";
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_FIELDNAME = "fieldname";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_BUTTON_ALL_SHOW = "btnallshow";
    private static final String KEY_BUTTON_ALL_HIDE = "btnallhide";
    private static final String KEY_BUTTON_CANCEL = "btncancel";
    private static final String KEY_BUTTON_OK = "btnok";
    private static final String KEY_ADVCON_TOOLBARAP = "advcontoolbarap";
    private static final String ENTITYID = "entityId";

    public void afterCreateNewData(EventObject e) {
        List columns = (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("reportcolumns")));
        this.convertToModel(columns);
    }

    private void convertToModel(List<AbstractReportColumn> columns) {
        int i;
        if (columns == null) {
            return;
        }
        if (this.getModel().getEntryRowCount(KEY_ENTRYENTITY) > 0) {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        }
        ArrayList<AbstractReportColumn> allColumns = new ArrayList<AbstractReportColumn>();
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYID);
        ArrayList<String> blackFields = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            ProductSettingService pService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
            blackFields.addAll(pService.getFormDisVisitField(entityId));
        }
        for (i = 0; i < columns.size(); ++i) {
            this.addColumn(columns.get(i), allColumns, blackFields);
        }
        if (!allColumns.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, allColumns.size());
            for (i = 0; i < allColumns.size(); ++i) {
                if (!(allColumns.get(i) instanceof ReportColumn)) continue;
                ReportColumn bean = (ReportColumn)allColumns.get(i);
                this.getModel().setValue(KEY_FIELDNAME, (Object)bean.getCaption(), i);
                this.getModel().setValue(KEY_FIELDKEY, (Object)bean.getFieldKey(), i);
                this.getModel().setValue(KEY_HIDE, (Object)bean.isHide(), i);
            }
        }
    }

    private void addColumn(AbstractReportColumn column, List<AbstractReportColumn> columns, List<String> blackFields) {
        if (column instanceof ReportColumn) {
            String fieldKey = ((ReportColumn)column).getFieldKey();
            if (StringUtils.isNotBlank((CharSequence)fieldKey) && blackFields.contains(fieldKey)) {
                return;
            }
            columns.add(column);
        } else if (column instanceof ReportColumnGroup) {
            ReportColumnGroup group = (ReportColumnGroup)column;
            List children = group.getChildren();
            for (AbstractReportColumn child : children) {
                this.addColumn(child, columns, blackFields);
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BUTTON_CANCEL, KEY_BUTTON_OK});
        this.addItemClickListeners(new String[]{KEY_ADVCON_TOOLBARAP});
    }

    public void afterBindData(EventObject e) {
        this.showItemBar();
    }

    private void showItemBar() {
        if (this.isExistValueInCol(KEY_HIDE, Boolean.TRUE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_SHOW});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_HIDE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_SHOW});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_HIDE});
        }
    }

    private boolean isExistValueInCol(String key, Object value) {
        int curRows = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        for (int i = 0; i < curRows; ++i) {
            if (!Objects.equals(value, this.getModel().getValue(key, i))) continue;
            return true;
        }
        return false;
    }

    private void toggleButton(String fieldName, boolean isOpen) {
        int rowCount = this.getModel().getEntryRowCount("entryEntity");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(fieldName, (Object)isOpen, i);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnallhide": {
                this.toggleButton(KEY_HIDE, true);
                break;
            }
            case "btnallshow": {
                this.toggleButton(KEY_HIDE, false);
                break;
            }
        }
        super.itemClick(evt);
        this.showItemBar();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                if (this.getModel().getDataChanged()) {
                    this.returnDataToParent();
                }
                this.getView().close();
                break;
            }
        }
    }

    private void returnDataToParent() {
        Map<String, Boolean> columns = this.covertToColumnMap();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("action", "configurereport");
        result.put("controlKey", this.getView().getFormShowParameter().getCustomParam("controlKey"));
        result.put(ENTITYID, this.getView().getFormShowParameter().getCustomParam(ENTITYID));
        result.put("reportcolumnsmap", SerializationUtils.serializeToBase64(columns));
        this.getView().returnDataToParent(result);
    }

    private Map<String, Boolean> covertToColumnMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        int size = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        for (int i = 0; i < size; ++i) {
            String fieldKey = (String)this.getModel().getValue(KEY_FIELDKEY, i);
            boolean hide = (Boolean)this.getModel().getValue(KEY_HIDE, i);
            map.put(fieldKey, hide);
        }
        return map;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_HIDE.equals(e.getProperty().getName())) {
            this.showItemBar();
        }
    }
}

