/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.script.annotations.KSMethod;

public class TemplateAuditedBillEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        Label label = (Label)this.getControl("title");
        if (label != null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String title = formShowParameter.getCaption();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                title = formShowParameter.getFormConfig().getCaption().toString();
            }
            label.setText(formShowParameter.getCaption());
        }
        this.setBillStatus();
    }

    @KSMethod
    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                BillStatusProp billStatusProp = (BillStatusProp)property;
                String defValue = (String)billStatusProp.getDefValue();
                String value = (String)this.getModel().getValue("billstatus");
                if ("A".equals(value) || "C".equals(defValue)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if ("B".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if ("C".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                }
            }
        }
    }
}

