/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BasedataHelper;
import kd.bos.base.IBasedataController;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.field.events.BasedataControllerSourceEnum;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.list.query.QueryFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TemplateTreePlugin
extends StandardTreeListPlugin
implements IDataModelChangeListener {
    private static final String ENABLE = "enable";

    public void initialize() {
        ITreeModel treeModel;
        super.initialize();
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            if (treeModel.getGroupProp() instanceof ParentBasedataProp) {
                this.hideToolBar();
            }
            TreeListModel treeListModel = (TreeListModel)treeModel;
            BasedataEntityType entityType = treeListModel.getGroupProp().getEntityType();
            IDataEntityProperty enableProp = entityType.findProperty(ENABLE);
            List qFilters = treeListModel.getTreeFilter();
            if (enableProp instanceof BillStatusProp) {
                BillList billList = (BillList)this.getControl("billlistap");
                qFilters = qFilters.stream().filter(f -> f != null && !ENABLE.equals(f.getProperty())).collect(Collectors.toList());
                if (!billList.isShowDisabledData()) {
                    QFilter qFilter = new QFilter(ENABLE, "=", (Object)"1");
                    qFilters.add(qFilter);
                }
            }
            ListShowParameter param = null;
            FormShowParameter parameter = this.getView().getFormShowParameter();
            param = parameter instanceof ListShowParameter ? (ListShowParameter)parameter : new ListShowParameter();
            BaseDataCustomControllerEvent event = new BaseDataCustomControllerEvent((Object)this, param, BasedataControllerSourceEnum.TREE);
            List controllers = BasedataHelper.createPlugin((List)entityType.getBasedataControllersProp());
            for (IBasedataController controller : controllers) {
                controller.buildBaseDataCoreFilter(event);
            }
            if (!event.getQfilters().isEmpty()) {
                qFilters.addAll(event.getQfilters());
            }
            treeListModel.setTreeFilter(qFilters);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null) {
            ITreeModel treeModel = treeView.getTreeModel();
            e.getFilters().addAll(treeModel.getTreeListFilter());
        }
    }

    private void hideToolBar() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("iscontainnow") && e.getChangeSet().length == 1) {
            boolean isContainNow = (Boolean)e.getChangeSet()[0].getNewValue();
            if (this.getTreeListView().getTreeModel() != null) {
                Object nodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
                TreeNode rootNode = this.getTreeListView().getTreeModel().getRoot();
                if (nodeId != null && rootNode != null) {
                    GroupProp groupProp = this.getTreeListView().getTreeModel().getGroupProp();
                    TreeNode currentNode = rootNode.getTreeNode(nodeId.toString());
                    BillList billList = (BillList)this.getControl("billlistap");
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    if (groupProp != null) {
                        String groupName = groupProp.getName();
                        if (currentNode != null) {
                            if (StringUtils.isNotBlank((CharSequence)currentNode.getLongNumber())) {
                                int dbType = groupProp.getDbType();
                                String longNumber = currentNode.getLongNumber();
                                IQuery query = QueryFactory.createQuery();
                                List idArrays = query.getChildsId(groupProp, longNumber);
                                ArrayList<Object> idList = new ArrayList<Object>(idArrays.size() + 1);
                                idList.add(DbTypeConverter.safeConvert((int)dbType, (Object)currentNode.getId()));
                                for (String id : idArrays) {
                                    idList.add(DbTypeConverter.safeConvert((int)dbType, (Object)id));
                                }
                                QFilter qFiter = new QFilter(groupName, "in", idList);
                                qFiter.or(new QFilter(groupName, "in", idList));
                                if (isContainNow) {
                                    qFiter.or(new QFilter("id", "=", DbTypeConverter.safeConvert((int)dbType, (Object)currentNode.getId())));
                                }
                                filters.add(qFiter);
                            }
                            FieldEdit showDisabledDataEdit = (FieldEdit)this.getControl("isshowdisabled");
                            boolean showDisabledData = false;
                            if (showDisabledDataEdit != null) {
                                showDisabledData = (Boolean)showDisabledDataEdit.getModel().getValue("isshowdisabled");
                            }
                            billList.setShowDisabledData(showDisabledData);
                            billList.setQueryFilterParameter(new FilterParameter(filters, null));
                            boolean isF7 = false;
                            if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
                                isF7 = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
                            }
                            if (!isF7) {
                                billList.clearEntryState();
                                billList.clearSelection();
                            }
                            billList.refresh();
                        }
                    }
                }
            }
        }
    }
}

