/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.aduitlog;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class AduitLogListPlugin
extends StandardTreeListPlugin {
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DELETE = "btndel";
    private static final String PREFIX_APP = "app_";
    private static final String PREFIX_CLOUD = "cloud_";
    private static final String KEY_MODIFYBILLID = "modifybillid";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String _ADUIT_RULE_ = "_aduitRule_";
    private static final String BIZ_OBJ = "bizobj";
    private static final String MODIFY_FIELDS = "modifyfields";
    private static final String BIZ_OBJ_NUMBER = "bizobjnumber";
    private static final String BOS_ADUIT_LOG = "bos_aduit_log_view";
    private static final String BOS_ADUIT_LOG_NEW = "bos_aduit_log_new";
    private boolean isFromEs = false;

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = param.getBillFormId();
        if (!BOS_ADUIT_LOG.equals(billFormId)) {
            this.isFromEs = true;
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(String parentId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(parentId, 20);
        if (parent == null || parent.getChildren() == null || parent.getChildren().isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        return parent.getChildren();
    }

    public void initializeTree(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        List<TreeNode> cloudNodes = this.getCloudNodes();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AduitLogListPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        root.setChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    private List<TreeNode> getCloudNodes() {
        List clouds = null;
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"app");
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        Map<String, String> originExtendAppRelMap = this.getOriginExtendAppRelMap();
        Map<String, List<TreeNode>> billNodesMap = this.getBillNodesMap(originExtendAppRelMap);
        Iterator cloudIterator = clouds.iterator();
        while (cloudIterator.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIterator.next();
            String cloudNodeId = PREFIX_CLOUD + cloud.getId();
            cloud.setId(cloudNodeId);
            cloud.setData((Object)"cloud");
            List apps = cloud.getChildren();
            if (apps == null) {
                cloudIterator.remove();
                continue;
            }
            Iterator appIterator = apps.iterator();
            while (appIterator.hasNext()) {
                TreeNode app = (TreeNode)appIterator.next();
                String appNodeId = PREFIX_APP + app.getId();
                app.setId(appNodeId);
                app.setParentid(cloudNodeId);
                app.setData((Object)"app");
                String masterId = originExtendAppRelMap.get(appNodeId);
                List<TreeNode> billNodes = billNodesMap.get(masterId);
                if (billNodes == null || billNodes.isEmpty()) {
                    appIterator.remove();
                    continue;
                }
                app.setChildren(billNodes);
            }
            if (!apps.isEmpty()) continue;
            cloudIterator.remove();
        }
        return clouds;
    }

    private Map<Object, DynamicObject> getAduitLogRule(Object billNodeId) {
        Map rulesMap = BusinessDataServiceHelper.loadFromCache((String)"al_rule_setting", (String)"number,name,modifyfields", (QFilter[])new QFilter[]{new QFilter(BIZ_OBJ, "=", billNodeId), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        return rulesMap;
    }

    private Map<Object, DynamicObject> getAduitLog(Object billNodeId) {
        HashMap<Object, DynamicObject> logsMap = new HashMap(16);
        if (this.isFromEs) {
            LogORM logOrm = LogORM.create();
            String selectFields = "id,username,opname,opdate,modifybillno,bizobjname,modifybillid,modifycontent,modifycontent_tag,modifyfields,bizobjnumber";
            QFilter[] filters = new QFilter[]{new QFilter(BIZ_OBJ_NUMBER, "=", billNodeId), new QFilter(MODIFY_FIELDS, "!=", (Object)"")};
            DynamicObjectCollection col = logOrm.query(BOS_ADUIT_LOG_NEW, selectFields, filters, 1, 0);
            for (DynamicObject obj : col) {
                logsMap.put(obj.getPkValue(), obj);
            }
        } else {
            logsMap = BusinessDataServiceHelper.loadFromCache((String)BOS_ADUIT_LOG, (String)"id,modifyfields", (QFilter[])new QFilter[]{new QFilter(BIZ_OBJ, "=", billNodeId), new QFilter(MODIFY_FIELDS, "!=", (Object)"")});
        }
        return logsMap;
    }

    private String[] getAduitLogRuleModifyfields(Object number) {
        List ruleFields = this.getAduitLogRule(number).values().stream().map(v -> v.get(MODIFY_FIELDS).toString()).collect(Collectors.toList());
        HashSet<String> set = new HashSet<String>(16);
        for (String ruleField : ruleFields) {
            String[] oldArr = ruleField.split(",");
            for (int i = 1; i < oldArr.length; ++i) {
                set.add(oldArr[i].substring(oldArr[i].indexOf("(") + 1, oldArr[i].length() - 1));
            }
        }
        String[] array = new String[set.size()];
        return set.toArray(array);
    }

    private Map<String, String> getOriginExtendAppRelMap() {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        HashMap<String, String> originExtendAppRelMap = new HashMap<String, String>();
        for (DynamicObject app : allApps) {
            String type = app.getString("type");
            String nodeId = PREFIX_APP + app.getString("id");
            if ("0".equals(type)) {
                originExtendAppRelMap.put(nodeId, nodeId);
                continue;
            }
            String masterId = PREFIX_APP + app.getString("masterid");
            originExtendAppRelMap.put(nodeId, masterId);
        }
        return originExtendAppRelMap;
    }

    private Map<String, List<TreeNode>> getBillNodesMap(Map<String, String> originExtendAppRelMap) {
        DynamicObject[] objects;
        HashMap<String, List<TreeNode>> billNodesMap = new HashMap<String, List<TreeNode>>();
        String fields = "id, number, name, bizappid.id ";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImport = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImport};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)fields, (QFilter[])filters)) {
            String nodeId = object.getString("id");
            String name = object.getLocaleString("name").toString();
            String parentId = PREFIX_APP + object.getString("bizappid.id");
            String data = object.getString("number");
            TreeNode node = this.createTreeNode(nodeId, name, parentId, data);
            String masterId = originExtendAppRelMap.get(parentId);
            if (StringUtils.isBlank((CharSequence)masterId)) continue;
            ArrayList<TreeNode> nodes = (ArrayList<TreeNode>)billNodesMap.get(masterId);
            if (nodes == null) {
                nodes = new ArrayList<TreeNode>();
                billNodesMap.put(masterId, nodes);
            }
            nodes.add(node);
        }
        return billNodesMap;
    }

    private TreeNode createTreeNode(String nodeId, String name, String parentId, String data) {
        TreeNode node = new TreeNode();
        node.setText(name);
        node.setParentid(parentId);
        node.setId(nodeId);
        node.setData((Object)data);
        return node;
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        super.treeNodeClick(treenodeevent);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter filter = null;
        String bizObj = BIZ_OBJ;
        if (this.isFromEs) {
            bizObj = BIZ_OBJ_NUMBER;
        }
        if (nodeId.contains(PREFIX_CLOUD)) {
            String cloudId = StringUtils.substringAfter((String)nodeId, (String)"_");
            filter = new QFilter(bizObj, "in", this.getBillIdInCloud(cloudId));
        } else if (nodeId.contains(PREFIX_APP)) {
            String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
            filter = new QFilter(bizObj, "in", this.getBillIdInApp(appId));
        } else if (!this.isTopNodeId(nodeId)) {
            if (nodeId.contains(_ADUIT_RULE_)) {
                String parentNodeId = nodeId.split(_ADUIT_RULE_)[0];
                ArrayList<Object> pkId = new ArrayList<Object>();
                Map<Object, DynamicObject> logsMap = this.getAduitLog(parentNodeId);
                Iterator<Map.Entry<Object, DynamicObject>> logsIterator = logsMap.entrySet().iterator();
                while (logsIterator.hasNext()) {
                    DynamicObject log = logsIterator.next().getValue();
                    String modifyfields = log.getString(MODIFY_FIELDS);
                    String[] modifyfieldsArr = modifyfields.split(",");
                    HashSet<String> set = new HashSet<String>(16);
                    for (int i = 1; i < modifyfieldsArr.length; ++i) {
                        String[] fieldSplit = modifyfieldsArr[i].split("\\.");
                        if (fieldSplit.length == 3) {
                            set.add(fieldSplit[1] + "." + fieldSplit[2]);
                            continue;
                        }
                        set.add(modifyfieldsArr[i]);
                    }
                    String[] array = new String[set.size()];
                    if (Collections.disjoint(Arrays.asList(set.toArray(array)), Arrays.asList(this.getAduitLogRuleModifyfields(parentNodeId)))) continue;
                    pkId.add(log.getPkValue());
                }
                BillList billlist = (BillList)this.getView().getControl("billlistap");
                billlist.setFilter(new QFilter("id", "in", pkId));
            } else {
                filter = new QFilter(bizObj, "=", (Object)nodeId);
            }
        }
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private List<String> getBillIdInApp(String appId) {
        Object[] param = new SqlParameter[]{new SqlParameter(":FBIZAPPID", 12, (Object)appId)};
        String strSQL = "SELECT FID FROM t_meta_mainentityinfo WHERE FBIZAPPID = ? AND\u3000(FMODELTYPE = 'BillFormModel' OR FMODELTYPE = 'BaseFormModel') ";
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)strSQL, (Object[])param, (ResultSetHandler)action);
    }

    private List<String> getBillIdInCloud(String cloudId) {
        Object[] param = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)cloudId)};
        String strSQL = "SELECT C.FID FROM t_meta_bizcloud A LEFT JOIN t_meta_bizapp B ON A.FID = B.FBIZCLOUDID LEFT JOIN t_meta_mainentityinfo C  ON C.FBIZAPPID = B.FID WHERE A.FID = ?";
        ResultSetHandler action = rs -> {
            ArrayList<String> tempIdList = new ArrayList<String>(10);
            while (rs.next()) {
                tempIdList.add(rs.getString("FID"));
            }
            return tempIdList;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)strSQL, (Object[])param, (ResultSetHandler)action);
    }

    private boolean isTopNodeId(String currNodeId) {
        return currNodeId.equals(this.getTreeModel().getRoot().getId());
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW, BTN_EDIT, BTN_DELETE});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{BTN_NEW});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{BTN_EDIT, BTN_DELETE});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
            TreeNode root = this.getTreeModel().getRoot();
            this.getTreeModel().setCurrentNodeId((Object)root.getId());
            this.getTreeListView().getTreeView().focusNode(root);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof FormOperate) {
            FormOperate operate = (FormOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            Object[] pks = args.getListSelectedData().getPrimaryKeyValues();
            List<Object> pkId = Arrays.asList(pks);
            switch (operateKey) {
                case "viewdetails": {
                    this.viewDetails(pkId);
                    args.setCancel(true);
                    break;
                }
                case "viewhistorylog": {
                    this.viewHistoryLog(pkId);
                    args.setCancel(true);
                    break;
                }
                case "synsdata": {
                    this.synsData();
                    args.setCancel(true);
                    break;
                }
                case "synsdatatoes": {
                    this.synsDataToEs();
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    private void synsData() {
        JobInfo jobInfo = this.getJobInfo();
        ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }

    private void synsDataToEs() {
        JobInfo jobInfo = this.getJobInfo2();
        ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }

    private JobInfo getJobInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("log");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("synsData");
        jobInfo.setNumber("synsdata");
        jobInfo.setTaskClassname("kd.bos.form.plugin.aduitlog.AduitLogTask");
        return jobInfo;
    }

    private JobInfo getJobInfo2() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("log");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("synsDataToES");
        jobInfo.setNumber("synsdatatoes");
        jobInfo.setTaskClassname("kd.bos.form.plugin.aduitlog.AduitLogTaskToEs");
        return jobInfo;
    }

    private void viewHistoryLog(List<Object> pkId) {
        String historyBillFormId = "bos_history_log_view";
        DynamicObject object = null;
        if (this.isFromEs) {
            historyBillFormId = "bos_history_log_new";
            LogORM logOrm = LogORM.create();
            String selectFields = "id,username,opname,opdate,modifybillno,bizobjname,modifybillid,modifycontent,modifycontent_tag,modifyfields,bizobjnumber";
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", pkId.get(0))};
            DynamicObjectCollection col = logOrm.query(BOS_ADUIT_LOG_NEW, selectFields, filters, 1, 0);
            object = (DynamicObject)col.get(0);
        } else {
            object = BusinessDataServiceHelper.loadSingle((Object)pkId.get(0), (String)BOS_ADUIT_LOG);
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId("bos_list");
        lsp.setBillFormId(historyBillFormId);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        String modifybillid = object.get(KEY_MODIFYBILLID).toString();
        if (modifybillid.endsWith("+") || modifybillid.endsWith("-")) {
            modifybillid = modifybillid.substring(0, object.get(KEY_MODIFYBILLID).toString().length() - 1);
        }
        listFilterParameter.setFilter(new QFilter(KEY_MODIFYBILLID, "in", (Object)new String[]{modifybillid, modifybillid + "+", modifybillid + "-"}));
        lsp.setListFilterParameter(listFilterParameter);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String pageId = this.getView().getPageId() + "_" + modifybillid;
        lsp.setPageId(pageId);
        if (this.isFromEs) {
            lsp.setCustomParam("aduitLog", (Object)"esAduitLog");
        }
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void viewDetails(List<Object> pkId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_aduit_log_detail");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("pkId", pkId.get(0));
        BillList billList = (BillList)this.getView().getControl("billlistap");
        QFilter qf = null;
        for (QFilter qFilter : billList.generalFilterParameter().getQFilters()) {
            if (!"opdate".equals(qFilter.getProperty())) continue;
            if (qf == null) {
                qf = qFilter.copy();
                continue;
            }
            qf.and(qFilter);
        }
        if (qf != null) {
            fsp.setCustomParam("qfilter_opdate", (Object)qf.toSerializedString());
        }
        if (this.isFromEs) {
            fsp.setCustomParam("aduitLog", (Object)"esAduitLog");
        }
        this.getView().showForm(fsp);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        args.addCustomQFilter(new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"}));
        super.filterContainerBeforeF7Select(args);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc = (ColumnDesc)e.getSource();
        if (KEY_MODIFYBILLID.equals(columnDesc.getKey())) {
            String v = (String)e.getFormatValue();
            if (v.endsWith("+")) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u65b0\u589e", (String)"AduitLogListPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else if (v.endsWith("-")) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u5220\u9664", (String)"AduitLogListPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u4fee\u6539", (String)"AduitLogListPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!this.check(qfilters)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u6708\u3002", (String)"AduitLogListPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), 3));
        }
    }

    private boolean check(List<QFilter> qfilters) {
        int intervalMonth = 3;
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        String operateTimeFieldName = "optime";
        if (this.isFromEs) {
            operateTimeFieldName = "opdate";
        }
        for (QFilter filter : qfilters) {
            if (!operateTimeFieldName.equals(filter.getProperty())) continue;
            String filterStr = filter.toString();
            List qfilterNests = filter.getNests(true);
            if (qfilterNests == null || qfilterNests.isEmpty()) continue;
            String startTime = null;
            String endTime = null;
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            startTime = filterStr.substring(0, filterStr.indexOf(39));
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
            endTime = filterStr.substring(0, filterStr.indexOf(39));
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime start = LocalDateTime.parse(startTime, dateTimeFormatter);
                LocalDateTime end = LocalDateTime.parse(endTime, dateTimeFormatter);
                long duration = ChronoUnit.DAYS.between(start, end);
                if (duration > (long)(intervalMonth * 31)) {
                    checkResult = false;
                    continue;
                }
                checkResult = true;
            }
            catch (Exception px) {
                return checkResult;
            }
        }
        return checkResult;
    }
}

