/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.aduitlog;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.RequestContextInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logorm.LogORM;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.utils.LogPrintUtil;

public class AduitLogTask
extends AbstractTask {
    private static final String OPNAME = "opname";
    private static final String MODIFYBILLID = "modifybillid";
    private static final String MODIFYCONTENT = "modifycontent";

    public void execute(RequestContext arg0, Map<String, Object> arg1) {
        try {
            ORM orm = ORM.create();
            String selectFields = "id,username,optime, opname,opdescriptione, modifybillid, modifybillno, modifyfields, modifycontent, modifycontent_tag, bizobjname, bizobj, clienttype";
            Object[] values = new Object[]{"", " "};
            QFilter f1 = QFilter.isNotNull((String)MODIFYBILLID);
            QFilter f2 = new QFilter(MODIFYBILLID, "not in", (Object)values);
            QFilter[] qfilters = new QFilter[]{f1, f2};
            DynamicObjectCollection cols = orm.query("bos_log_operation", selectFields, qfilters, null, 5000);
            LogORM logOrm = LogORM.create();
            DynamicObjectCollection logs = this.getAduitLogs(cols);
            logOrm.insert((List)logs);
            RequestContextInfo rc = RequestContextInfo.get();
            String tenantId = rc.getTenantId();
            String accountId = rc.getAccountId();
            if (MCApi.create().enableElastic(tenantId, accountId)) {
                orm.insert((List)logs);
            }
            orm.delete((List)cols);
        }
        catch (Exception e) {
            LogPrintUtil.printExceptionMessage((Exception)e, (String)"syns data fail");
        }
    }

    private DynamicObjectCollection getAduitLogs(DynamicObjectCollection cols) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_aduit_log_new");
        DynamicObjectCollection list = new DynamicObjectCollection((DynamicObjectType)type, null);
        for (DynamicObject col : cols) {
            if (StringUtils.isBlank((Object)col.get(MODIFYBILLID)) || StringUtils.isBlank((Object)col.get(MODIFYCONTENT))) continue;
            DynamicObject obj = new DynamicObject((DynamicObjectType)type);
            obj.set("username", col.get("username"));
            obj.set(OPNAME, col.get(OPNAME));
            obj.set("opdesc", col.get("opdescriptione"));
            obj.set("opdate", col.get("optime"));
            obj.set(MODIFYBILLID, col.get(MODIFYBILLID));
            obj.set("modifybillno", col.get("modifybillno"));
            obj.set("modifyfields", col.get("modifyfields"));
            obj.set(MODIFYCONTENT, col.get(MODIFYCONTENT));
            obj.set("modifycontent_tag", col.get("modifycontent_tag"));
            obj.set("bizobjname", (Object)col.getString("bizobjname"));
            obj.set("bizobjnumber", (Object)col.getString("bizobj"));
            obj.set("clienttype", (Object)col.getString("clienttype"));
            list.add((Object)obj);
        }
        return list;
    }
}

