/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.aduitlog;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.RequestContextInfo;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.utils.AduitLogParameterUtil;
import kd.bos.logorm.datasource.dc.MCApi;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.orm.query.QFilter;

public class AduitRulesSettingEdit
extends AbstractFormPlugin {
    private static final String MODIFYFIELDS = "modifyfields";
    private static final String BIZOBJ = "bizobj";

    public void propertyChanged(PropertyChangedArgs e) {
        if (BIZOBJ.equalsIgnoreCase(e.getProperty().getName())) {
            DynamicObject bizObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (bizObj != null) {
                String entityId = bizObj.getString(((BasedataEntityType)bizObj.getDataEntityType()).getNumberProperty());
                this.setComboItems(entityId);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{MODIFYFIELDS});
            } else {
                this.getModel().setValue(MODIFYFIELDS, null);
            }
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject monitoringobject;
        Object nodeId = this.getView().getFormShowParameter().getShowParameter().getCustomParam("nodeId");
        if (nodeId != null) {
            this.getModel().setValue(BIZOBJ, nodeId);
        }
        if ((monitoringobject = (DynamicObject)this.getModel().getValue(BIZOBJ)) != null) {
            String entityId = monitoringobject.getString(((BasedataEntityType)monitoringobject.getDataEntityType()).getNumberProperty());
            this.setComboItems(entityId);
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(false);
        }
    }

    private void setComboItems(String entityId) {
        int fieldMaxLength = AduitLogParameterUtil.getMonitoringFieldMaxLength();
        ComboEdit monitoringfields = (ComboEdit)this.getControl(MODIFYFIELDS);
        ArrayList<String> modifyFieldsList = new ArrayList<String>(10);
        String modifyFields = (String)this.getModel().getValue(MODIFYFIELDS);
        if (modifyFields != null) {
            String[] modifyFieldsArr = modifyFields.split(",");
            for (int i = 1; i < modifyFieldsArr.length; ++i) {
                modifyFieldsList.add(modifyFieldsArr[i].substring(modifyFieldsArr[i].lastIndexOf("(") + 1, modifyFieldsArr[i].length() - 1));
            }
        }
        Map allFields = EntityMetadataCache.getDataEntityType((String)entityId).getAllFields();
        Iterator it = allFields.entrySet().iterator();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        StringBuilder s = new StringBuilder();
        s.append(",");
        while (it.hasNext()) {
            Map.Entry<String, IDataEntityProperty> data = it.next();
            String key = (String)data.getKey();
            this.setComboItemsValue(key, data, list, fieldMaxLength);
            if (!modifyFieldsList.contains(this.getModifyFieldsKey(key, data, fieldMaxLength))) continue;
            String modifyFieldsValue = this.getModifyFieldsValue(key, data, fieldMaxLength);
            s.append(modifyFieldsValue);
            s.append(",");
        }
        monitoringfields.setComboItems(list);
        if (",".equals(s.toString())) {
            this.getModel().setValue(MODIFYFIELDS, null);
            return;
        }
        this.getModel().setValue(MODIFYFIELDS, (Object)s);
    }

    public void registerListener(EventObject e) {
        BasedataEdit monitoringobjectF7 = (BasedataEdit)this.getControl(BIZOBJ);
        monitoringobjectF7.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.addCustomQFilter(new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"})));
        super.registerListener(e);
    }

    private void setComboItemsValue(String key, Map.Entry<String, IDataEntityProperty> data, List<ComboItem> list, int fieldMaxLength) {
        IDataEntityProperty value = data.getValue();
        IDataEntityType parent = value.getParent();
        String parentKey = parent.getName();
        String parentName = parent.getDisplayName().toString();
        if (StringUtils.isBlank((CharSequence)parentName)) {
            parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"AduitRulesSettingEdit_1", (String)"bos-form-business", (Object[])new Object[0]);
        }
        LocaleString name = value.getDisplayName();
        if (!(value instanceof IPictureProp || value instanceof IAttachmentProp || value instanceof LargeTextProp || parent instanceof LinkEntryType)) {
            if (StringUtils.isEmpty((CharSequence)value.getAlias())) {
                return;
            }
            if (value instanceof ISimpleProperty && (((ISimpleProperty)value).getPrivacyType() != 0L || ((ISimpleProperty)value).isEncrypt())) {
                return;
            }
            if (parent instanceof EntryType) {
                if (value instanceof TextProp) {
                    int maxLength = ((TextProp)value).getMaxLenth();
                    if (maxLength <= fieldMaxLength) {
                        ComboItem item = new ComboItem(new LocaleString(parentName + "." + name), parentName + "." + name + "(" + parentKey + "." + key + ")");
                        list.add(item);
                    }
                } else if (name != null) {
                    ComboItem item = new ComboItem(new LocaleString(parentName + "." + name.toString()), parentName + "." + name + "(" + parentKey + "." + key + ")");
                    list.add(item);
                }
            } else if (value instanceof TextProp) {
                int maxLength = ((TextProp)value).getMaxLenth();
                if (maxLength <= fieldMaxLength) {
                    ComboItem item = new ComboItem(name, name + "(" + key + ")");
                    list.add(item);
                }
            } else {
                ComboItem item = new ComboItem(name, name + "(" + key + ")");
                list.add(item);
            }
        }
    }

    private String getModifyFieldsValue(String key, Map.Entry<String, IDataEntityProperty> data, int fieldMaxLength) {
        String v = "";
        IDataEntityProperty value = data.getValue();
        IDataEntityType parent = value.getParent();
        String parentKey = parent.getName();
        String parentName = parent.getDisplayName().toString();
        if (StringUtils.isBlank((CharSequence)parentName)) {
            parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"AduitRulesSettingEdit_1", (String)"bos-form-business", (Object[])new Object[0]);
        }
        String name = value.getDisplayName().toString();
        if (!(value instanceof IPictureProp || value instanceof IAttachmentProp || value instanceof LargeTextProp || parent instanceof LinkEntryType || StringUtils.isEmpty((CharSequence)value.getAlias()))) {
            if (parent instanceof EntryType) {
                if (value instanceof TextProp) {
                    int maxLength = ((TextProp)value).getMaxLenth();
                    if (maxLength <= fieldMaxLength) {
                        v = parentName + "." + name + "(" + parentKey + "." + key + ")";
                    }
                } else {
                    v = parentName + "." + name + "(" + parentKey + "." + key + ")";
                }
            } else if (value instanceof TextProp) {
                int maxLength = ((TextProp)value).getMaxLenth();
                if (maxLength <= fieldMaxLength) {
                    v = name + "(" + key + ")";
                }
            } else {
                v = name + "(" + key + ")";
            }
        }
        return v;
    }

    private String getModifyFieldsKey(String key, Map.Entry<String, IDataEntityProperty> data, int fieldMaxLength) {
        String v = "";
        IDataEntityProperty value = data.getValue();
        IDataEntityType parent = value.getParent();
        String parentKey = parent.getName();
        if (!(value instanceof IPictureProp || value instanceof IAttachmentProp || value instanceof LargeTextProp || parent instanceof LinkEntryType)) {
            if (parent instanceof EntryType) {
                if (value instanceof TextProp) {
                    int maxLength = ((TextProp)value).getMaxLenth();
                    if (maxLength <= fieldMaxLength) {
                        v = parentKey + "." + key;
                    }
                } else {
                    v = parentKey + "." + key;
                }
            } else if (value instanceof TextProp) {
                int maxLength = ((TextProp)value).getMaxLenth();
                if (maxLength <= fieldMaxLength) {
                    v = key;
                }
            } else {
                v = key;
            }
        }
        return v;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String value;
        super.beforeDoOperation(args);
        RequestContextInfo rc = RequestContextInfo.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        if (!MCApi.create().enableElastic(tenantId, accountId) && !StringUtils.isBlank((CharSequence)(value = (String)this.getModel().getValue(MODIFYFIELDS)))) {
            int maxAmount = AduitLogParameterUtil.getAuditFieldMaxAmount();
            String[] arr = value.replaceFirst(",", "").split(",");
            if (arr.length > maxAmount) {
                args.setCancel(true);
                String msg = String.format(ResManager.loadKDString((String)"\u76d1\u63a7\u5b57\u6bb5\u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u3002", (String)"AduitRulesSettingEdit_0", (String)"bos-form-business", (Object[])new Object[0]), maxAmount);
                this.getView().showTipNotification(msg);
            }
        }
    }
}

