/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.billtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillTypeParameterPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.billtype.BillTypeControlEntryMobWidget;
import kd.bos.form.plugin.billtype.BillTypeEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BillTypeDifferentialHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import org.apache.commons.beanutils.MethodUtils;

public class BillTypeEdit_new
extends AbstractBillPlugIn
implements ICloseCallBack,
BeforeF7SelectListener {
    private static final String KEY_ISDEFAULT = "isdefault";
    private static final Log log = LogFactory.getLog(BillTypeEdit.class);
    private static final String KEY_DEFAULTVALUE = "defaultvalue_d";
    private static final String MOB_KEY_DEFAULTVALUE = "mob_defaultvalue_d";
    private static final String KEY_DEFAULTFUNCPARAM = "defaultfuncparam_d";
    private static final String FORMID_BOS_BILLTYPE = "bos_billtype";
    private static final String KEY_FIELDKEY = "fieldkey_d";
    private static final String KEY_ENTITYFIELDKEY = "entityfieldkey_d";
    private static final String KEY_FIELD_NAME = "fieldname_d";
    private static final String KEY_BILLFORMID = "billformid";
    private static final String KEY_LAYOUT_SCHEME = "layoutsolution";
    private static final String KEY_FIELD_CONTROL_ENTRY_DISPLAY = "fieldcontrolentry_d";
    private static final String KEY_FIELD_CONTROL_ENTRY_STORE = "fieldcontrolentry";
    private static final String PARAMETER_PAGE_ID = "parameterPageId";
    private static final String KEY_MOB_LAYOUT_SCHEME = "mob_layoutsolution";
    private static final String KEY_SYNC_PCSETTING_BUTTON = "syncpcsettingbutton";
    private static final String CACHE_KEY_LAYOUTS = "cache_layouts";
    private static final String KEY_SAVE = "save";
    private static final String KEY_SUBMIT = "submit";
    private static final String KEY_ADUIT = "audit";
    private static final String KEY_MUSTINPUT_D = "mustinput_d";
    private static final String KEY_NUMBER = "number";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String APPCACHE_PARAMSETTING = "bos_billtype_params";
    private static final String PAGECACHE_COPYPKVALUE = "bos.copypkvalue";
    private BillTypeControlEntryMobWidget mobControlEntry;
    private static final List<String> UNSUPPORTED_FIELDS = Arrays.asList("TimeField", "TimeRangeField");
    private Map<String, BillTypeControlInfo> billTypeControlInfoMap = null;
    private static Map<String, String> VISIBLE2STATUS = new HashMap<String, String>();
    private static Map<String, String> LOCK2STATUS = new HashMap<String, String>();
    private static Map<String, String> DISPLAY2STORE = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_DEFAULTVALUE});
        this.addClickListeners(new String[]{MOB_KEY_DEFAULTVALUE});
        this.addClickListeners(new String[]{KEY_SYNC_PCSETTING_BUTTON});
        BasedataEdit tpl = (BasedataEdit)this.getView().getControl("importtpl");
        if (tpl != null) {
            tpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tpl = (BasedataEdit)this.getView().getControl("exporttpl")) != null) {
            tpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void initialize() {
        this.mobControlEntry = new BillTypeControlEntryMobWidget(this.getView(), this.getModel());
    }

    public void click(EventObject evt) {
        String btnKey = ((Control)evt.getSource()).getKey();
        if (KEY_DEFAULTVALUE.equals(btnKey)) {
            int row = this.getModel().getEntryCurrentRowIndex(KEY_FIELD_CONTROL_ENTRY_DISPLAY);
            String fieldType = (String)this.getModel().getValue(KEY_DEFAULTFUNCPARAM, row);
            String fieldKey = (String)this.getModel().getValue(KEY_FIELDKEY, row);
            Map<String, BillTypeControlInfo> billTypeControlInfos = this.getBillTypeControlInfos(this.getCurrentLayoutFormId(), this.getCurrentFormId());
            BillTypeControlInfo billTypeControlInfo = billTypeControlInfos.get(fieldKey);
            if (billTypeControlInfo.getDefValueType() == 2) {
                FormShowParameter parameter = this.createDefValueEditFormShowParatemer(row, fieldType);
                this.getView().showForm(parameter);
            }
        } else if (MOB_KEY_DEFAULTVALUE.equals(btnKey)) {
            this.mobControlEntry.showDefaultValueEditForm("", new CloseCallBack((IFormPlugin)this, MOB_KEY_DEFAULTVALUE));
        } else if (KEY_SYNC_PCSETTING_BUTTON.equals(btnKey)) {
            this.mobControlEntry.syncPCSetting();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        if (KEY_DEFAULTVALUE.equals(closedCallBackEvent.getActionId())) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 != null) {
                Map data = (Map)returnData2;
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_FIELD_CONTROL_ENTRY_DISPLAY);
                this.getModel().setValue(KEY_DEFAULTVALUE, data.get("value"), entryCurrentRowIndex);
            }
        } else if (MOB_KEY_DEFAULTVALUE.equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            Map data = (Map)returnData;
            this.mobControlEntry.postBackDefaultValue(data.get("value"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object billformid = baseShowParameter.getCustomParam(KEY_BILLFORMID);
        if (billformid != null && baseShowParameter.getBillStatus() == BillOperationStatus.ADDNEW) {
            this.getModel().setValue(KEY_BILLFORMID, billformid);
            this.getView().getFormShowParameter().setCustomParam(KEY_BILLFORMID, null);
            this.getView().cacheFormShowParameter();
        }
        this.setDefaultNumber();
        this.drawPage();
        this.drawMobPage();
    }

    private void setDefaultNumber() {
        DynamicObject dataEntity = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        if (dataEntity != null) {
            String currentIsv = AppMetaServiceHelper.getDeveloperInfo();
            if ("kingdee".equals(currentIsv)) {
                this.getModel().setValue(KEY_NUMBER, (Object)(dataEntity.get(KEY_NUMBER) + "_BT_S"));
            } else {
                this.getModel().setValue(KEY_NUMBER, (Object)(dataEntity.get(KEY_NUMBER) + "_BT"));
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.lockLimitEditCell();
        this.mobControlEntry.lockDisplayFields();
        this.decideParameterViewLock();
        this.lockItemButton();
    }

    private void lockItemButton() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_submit"});
        }
    }

    public void afterLoadData(EventObject e) {
        this.drawPage();
        this.drawMobPage();
        this.drawDifferentialInfo(this.getCurrentFormId(), (Long)this.getModel().getDataEntity().getPkValue());
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        String copyPkStr;
        Object copyPkValue = ((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
        String string = copyPkStr = copyPkValue == null ? "0" : copyPkValue.toString();
        if (StringUtils.isNotEmpty((CharSequence)copyPkStr) && !"0".equals(copyPkStr)) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put(PAGECACHE_COPYPKVALUE, copyPkStr);
        }
        this.setDefaultNumber();
        this.drawPage();
        this.drawMobPage();
        this.drawDifferentialInfo(this.getCurrentFormId(), Long.parseLong(copyPkStr));
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate source = (AbstractOperate)evt.getSource();
        if (KEY_SAVE.equals(source.getOperateKey()) || "saveandnew".equals(source.getOperateKey()) || KEY_SUBMIT.equals(source.getOperateKey())) {
            Boolean isDefault = (Boolean)this.getModel().getValue(KEY_ISDEFAULT);
            if (isDefault.booleanValue() && !this.ensureDefaultBilltypeUnique()) {
                evt.setCancel(true);
                evt.setCancelMessage(ResManager.loadKDString((String)"\u5bf9\u4e00\u5f20\u5355\u636e\u800c\u8a00\uff0c\u4e0d\u80fd\u5b58\u5728\u4e24\u4e2a\u9ed8\u8ba4\u5355\u636e\u7c7b\u578b,\u672c\u6b21\u64cd\u4f5c\u53d6\u6d88\u3002", (String)"BillTypeEdit_new_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u5355\u636e\u5b9e\u4f53\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u5355\u636e\u7c7b\u578b\u3002", (String)"BillTypeEdit_new_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else {
                this.buildDifferentialControlInfo(evt);
                this.mobControlEntry.buildDifferentialControlInfo();
            }
        }
        if (KEY_SAVE.equals(source.getOperateKey()) || KEY_SUBMIT.equals(source.getOperateKey())) {
            this.billTypeParameterCheck();
        }
    }

    private void billTypeParameterCheck() {
        StringBuilder sBuilder;
        IBillTypeParameterPlugin plugin;
        IFormView parameterView;
        String parameterPageId = this.getPageCache().get(PARAMETER_PAGE_ID);
        if (StringUtils.isNotBlank((CharSequence)parameterPageId) && (parameterView = this.getView().getView(parameterPageId)) != null && (plugin = this.getBillTypeParaPlug(parameterView)) != null && !plugin.check(sBuilder = new StringBuilder())) {
            throw new KDBizException(sBuilder.toString());
        }
    }

    private IBillTypeParameterPlugin getBillTypeParaPlug(IFormView view) {
        if (view == null) {
            return null;
        }
        FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        if (proxy != null) {
            for (IFormPlugin plugin : proxy.getPlugIns()) {
                if (!(plugin instanceof IBillTypeParameterPlugin)) continue;
                return (IBillTypeParameterPlugin)plugin;
            }
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = evt.getOperateKey();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (KEY_SAVE.equals(operateKey) || KEY_SUBMIT.equals(operateKey)) {
            String parameterPageId = this.getPageCache().get(PARAMETER_PAGE_ID);
            if (StringUtils.isNotBlank((CharSequence)parameterPageId)) {
                this.fireCustomEventParametersave(parameterPageId);
            }
            if (KEY_SUBMIT.equals(operateKey)) {
                billShowParameter.setBillStatus(BillOperationStatus.SUBMIT);
            }
            this.getModel().setDataChanged(false);
            this.getView().updateView();
        } else if (KEY_ADUIT.equals(operateKey)) {
            billShowParameter.setBillStatus(BillOperationStatus.AUDIT);
            String billNumber = this.getCurrentFormId();
            Long billtypeId = (Long)this.getModel().getDataEntity().getPkValue();
            List differentialControlInfos = BillTypeDifferentialHelper.getDifferentialControlInfos((String)billNumber, (long)billtypeId);
            BillTypeDifferentialHelper.storeDifferentialControlInfos((String)billNumber, (Long)billtypeId, (List)differentialControlInfos);
        } else if ("unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            this.lockLimitEditCell();
            this.mobControlEntry.lockDisplayFields();
        }
        this.decideParameterViewLock();
        this.getView().cacheFormShowParameter();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "billformid": {
                ChangeData[] changeData = e.getChangeSet();
                Object newValue = changeData[0].getNewValue();
                Object oldValue = changeData[0].getOldValue();
                if (newValue != null && !newValue.equals(oldValue)) {
                    this.getModel().setValue(KEY_LAYOUT_SCHEME, null);
                }
                this.setDefaultNumber();
                this.drawPage();
                this.drawMobPage();
                break;
            }
            case "layoutsolution": {
                this.drawPage();
                BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
                Object billformid = baseShowParameter.getCustomParam(KEY_BILLFORMID);
                if (billformid != null && baseShowParameter.getBillStatus() == BillOperationStatus.EDIT) {
                    this.drawDifferentialInfo(this.getCurrentFormId(), (Long)this.getModel().getDataEntity().getPkValue());
                }
                this.decideParameterViewLock();
                break;
            }
            case "mob_layoutsolution": {
                this.drawMobPage();
                this.decideParameterViewLock();
            }
        }
    }

    private void drawPage() {
        String formId = this.getCurrentFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String layoutFormId = this.bindLayout(formId);
            this.buildDisplayFieldControlEntry(layoutFormId, formId);
            this.drawBillTypeParameterPage();
            this.updatePrintTemplateComboItem();
            this.lockLimitEditCell();
        }
    }

    private void drawMobPage() {
        String formId = this.getCurrentFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String layoutMobFormId = this.mobControlEntry.bindLayout(formId);
            this.mobControlEntry.init(formId, layoutMobFormId, true);
        }
    }

    private String bindLayout(String formId) {
        Optional<Map> op;
        List layouts = BillTypeServiceHelper.getBillLayoutByFormId((String)formId);
        ComboEdit edit = (ComboEdit)this.getControl(KEY_LAYOUT_SCHEME);
        List items = layouts.stream().map(item -> {
            ILocaleString v = (ILocaleString)item.get("name");
            return new ComboItem(new LocaleString(v.getLocaleValue()), (String)item.get("id"));
        }).collect(Collectors.toList());
        this.getPageCache().put(CACHE_KEY_LAYOUTS, SerializationUtils.toJsonString((Object)layouts));
        edit.setComboItems(items);
        Object val = this.getModel().getValue(KEY_LAYOUT_SCHEME);
        if (StringUtils.isBlank((Object)val) || "null".equalsIgnoreCase(String.valueOf(val))) {
            this.getModel().setValue(KEY_LAYOUT_SCHEME, ((Map)layouts.get(0)).get("id"));
        }
        return (op = layouts.stream().filter(item -> item.get("id").equals(this.getModel().getValue(KEY_LAYOUT_SCHEME))).findFirst()).isPresent() ? (String)op.get().get(KEY_NUMBER) : formId;
    }

    private void buildDifferentialControlInfo(BeforeDoOperationEventArgs evt) {
        int i;
        String layoutFormId = this.getCurrentLayoutFormId();
        if (StringUtils.isBlank((CharSequence)layoutFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u5e03\u5c40\u65b9\u6848\u3002", (String)"BillTypeEdit_new_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            evt.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u5e03\u5c40\u65b9\u6848\u3002", (String)"BillTypeEdit_new_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Map<String, BillTypeControlInfo> fieldControlInfos = this.getBillTypeControlInfos(layoutFormId, this.getCurrentFormId());
        DynamicObjectCollection displayEntry = this.getModel().getEntryEntity(KEY_FIELD_CONTROL_ENTRY_DISPLAY);
        HashSet<Integer> changeFields = new HashSet<Integer>();
        block0: for (i = 0; i < displayEntry.size(); ++i) {
            DynamicObject rowObj = (DynamicObject)displayEntry.get(i);
            String fieldKey = rowObj.getString(KEY_FIELDKEY);
            BillTypeControlInfo ctlInfo = fieldControlInfos.get(fieldKey);
            if (StringUtils.isNotBlank((CharSequence)rowObj.getString(KEY_DEFAULTVALUE)) || !Objects.equals(rowObj.get(KEY_MUSTINPUT_D), ctlInfo.isMustInput())) {
                changeFields.add(i);
                continue;
            }
            for (Map.Entry<String, String> entry : VISIBLE2STATUS.entrySet()) {
                if (Objects.equals(rowObj.get(entry.getKey()), ctlInfo.isVisible(entry.getValue()))) continue;
                changeFields.add(i);
                break;
            }
            for (Map.Entry<String, String> entry : LOCK2STATUS.entrySet()) {
                if (Objects.equals(rowObj.get(entry.getKey()), ctlInfo.isLock(entry.getValue()))) continue;
                changeFields.add(i);
                continue block0;
            }
        }
        if (this.getModel().getEntryRowCount(KEY_FIELD_CONTROL_ENTRY_STORE) > 0) {
            this.getModel().deleteEntryData(KEY_FIELD_CONTROL_ENTRY_STORE);
        }
        if (!changeFields.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_FIELD_CONTROL_ENTRY_STORE, changeFields.size());
            i = 0;
            Iterator iterator = changeFields.iterator();
            while (iterator.hasNext()) {
                int changeFieldIdx = (Integer)iterator.next();
                DynamicObject displayRowObj = (DynamicObject)displayEntry.get(changeFieldIdx);
                for (Map.Entry<String, String> entry : DISPLAY2STORE.entrySet()) {
                    this.getModel().setValue(entry.getValue(), displayRowObj.get(entry.getKey()), i);
                }
                ++i;
            }
        }
    }

    private void drawDifferentialInfo(String formId, long billTypeId) {
        List difInfos = BillTypeDifferentialHelper.getDifferentialControlInfos((String)formId, (long)billTypeId);
        int rows = this.getModel().getEntryRowCount(KEY_FIELD_CONTROL_ENTRY_DISPLAY);
        for (int i = 0; i < rows; ++i) {
            String fieldKey = (String)this.getModel().getValue(KEY_FIELDKEY, i);
            int rowIdex = i;
            Optional<DifferentialControlInfo> difInfo = difInfos.stream().filter(info -> info.getFieldKey().equals(fieldKey)).findFirst();
            if (!difInfo.isPresent()) continue;
            if (!difInfo.get().getLock().isEmpty()) {
                LOCK2STATUS.forEach((statusKey, status) -> {
                    if (((DifferentialControlInfo)difInfo.get()).getLock().containsKey(status)) {
                        this.getModel().setValue(statusKey, ((DifferentialControlInfo)difInfo.get()).getLock().get(status), rowIdex);
                    }
                });
            }
            if (!difInfo.get().getVisible().isEmpty()) {
                VISIBLE2STATUS.forEach((statusKey, status) -> {
                    if (((DifferentialControlInfo)difInfo.get()).getVisible().containsKey(status)) {
                        this.getModel().setValue(statusKey, ((DifferentialControlInfo)difInfo.get()).getVisible().get(status), rowIdex);
                    }
                });
            }
            if (difInfo.get().isMustInput() != null) {
                this.getModel().setValue(KEY_MUSTINPUT_D, (Object)difInfo.get().isMustInput(), rowIdex);
            }
            if (!StringUtils.isNotBlank((CharSequence)difInfo.get().getDefaultValue())) continue;
            this.getModel().setValue(KEY_DEFAULTVALUE, (Object)difInfo.get().getDefaultValue(), rowIdex);
        }
    }

    private boolean ensureDefaultBilltypeUnique() {
        Boolean isDefault = (Boolean)this.getModel().getValue(KEY_ISDEFAULT);
        if (isDefault.booleanValue()) {
            DynamicObject billform = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
            Object pkValue = billform.getPkValue();
            QFilter[] filters = new QFilter[]{new QFilter(KEY_BILLFORMID, "=", pkValue), new QFilter(KEY_ISDEFAULT, "=", (Object)Boolean.TRUE)};
            DynamicObjectCollection col = ORM.create().query(FORMID_BOS_BILLTYPE, "id", filters);
            if (!col.isEmpty()) {
                Object modelPKId = this.getModel().getDataEntity().getPkValue();
                for (DynamicObject billtypeObj : col) {
                    if (Objects.equals(billtypeObj.get("id"), modelPKId)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void drawBillTypeParameterPage() {
        DynamicObject billObj = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        String formId = billObj.getPkValue().toString();
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId);
        String billTypePara = dt.getBillTypePara();
        if (StringUtils.isNotBlank((CharSequence)billTypePara)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"parametercontainor"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"zwsjpanelap"});
            ParameterShowParameter parameterShowParam = new ParameterShowParameter();
            parameterShowParam.getOpenStyle().setShowType(ShowType.InContainer);
            parameterShowParam.getOpenStyle().setTargetKey("parametercontainor");
            parameterShowParam.setFormId(billTypePara);
            Object pkValue = this.getBindBillTypeId();
            if (pkValue != null && !pkValue.equals(0L)) {
                parameterShowParam.setCustomParam("bindformid", (Object)formId);
                parameterShowParam.setCustomParam("bindbilltypeid", pkValue);
                parameterShowParam.setStatus(OperationStatus.VIEW);
            }
            parameterShowParam.setCustomParam("notNeedClose", (Object)"true");
            this.getView().showForm((FormShowParameter)parameterShowParam);
            this.getPageCache().put(PARAMETER_PAGE_ID, parameterShowParam.getPageId());
        }
        log.info("drawBillTypeParameterPage end, formId :{}, billTypePara :{}", (Object)formId, (Object)billTypePara);
    }

    private FormShowParameter createDefValueEditFormShowParatemer(int row, String fieldType) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_defaultvalueedit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> mockContext = new HashMap<String, Object>();
        mockContext.put("_Type_", fieldType);
        mockContext.put("Key", this.getModel().getValue(KEY_FIELDKEY, row));
        DynamicObject bizObj = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        String fieldKey = this.getModel().getValue(KEY_FIELDKEY, row).toString();
        mockContext.put("FormId", bizObj.getPkValue());
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)bizObj.getPkValue().toString());
        IDataEntityProperty prop = (IDataEntityProperty)dt.getAllFields().get(fieldKey);
        if (prop instanceof MulBasedataProp) {
            mockContext.put("BaseEntityId", ((MulBasedataProp)prop).getBaseEntityId());
        } else if (prop instanceof BasedataProp) {
            String id = MetadataDao.getIdByNumber((String)((BasedataProp)prop).getBaseEntityId(), (MetaCategory)MetaCategory.Entity);
            mockContext.put("BaseEntityId", id);
        }
        if (prop instanceof AssistantProp) {
            mockContext.put("AsstTypeId", ((AssistantProp)prop).getAsstTypeId());
        }
        parameter.setCustomParam("context", Collections.singletonList(mockContext));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_DEFAULTVALUE));
        return parameter;
    }

    private void updatePrintTemplateComboItem() {
        String billNumber = this.getCurrentFormId();
        boolean isIsolated = Boolean.parseBoolean(System.getProperty(RequestContext.get().getTenantId() + "_printtpl.org.enable", "false"));
        ComboEdit combo = (ComboEdit)this.getControl("defprinttemplate");
        ArrayList<ComboItem> templateList = new ArrayList<ComboItem>(10);
        List<Map<String, String>> templates = isIsolated ? this.getTemplates(billNumber) : this.getTemplatesByNumber(billNumber);
        for (Map<String, String> template : templates) {
            String templateNo;
            String templateNumber = template.get("templateNumber");
            if (isIsolated && StringUtils.isNotBlank((Object)(templateNo = template.get("templateNo")))) {
                templateNumber = templateNo.toString();
            }
            templateList.add(new ComboItem(new LocaleString(template.get("tempalteName")), templateNumber));
        }
        combo.setComboItems(templateList);
    }

    private List<Map<String, String>> getTemplates(String billNumber) {
        String className = "kd.bos.template.orgctrl.service.PrintTemplateServiceImpl";
        try {
            Class factory = TypesContainer.getOrRegister((String)className);
            List object = (List)MethodUtils.invokeMethod(factory.newInstance(), (String)"getUserPermPrintTemplates", (Object[])new Object[]{billNumber});
            return object;
        }
        catch (Exception e) {
            log.error("\u5957\u6253\u6a21\u7248\u7ec4\u7ec7\u9694\u79bb\u53cd\u5c04\u7c7b\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private String getCurrentFormId() {
        DynamicObject curBill = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        if (curBill == null) {
            return null;
        }
        RefEntityType rdType = (RefEntityType)curBill.getDataEntityType();
        return curBill.get(rdType.getNumberProperty()).toString();
    }

    private String getCurrentLayoutFormId() {
        String id = (String)this.getModel().getValue(KEY_LAYOUT_SCHEME);
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        String layoutCache = this.getPageCache().get(CACHE_KEY_LAYOUTS);
        List layouts = SerializationUtils.fromJsonStringToList((String)layoutCache, Map.class);
        Optional<Map> op = layouts.stream().filter(item -> item.get("id").equals(id)).findFirst();
        return op.isPresent() ? (String)op.get().get(KEY_NUMBER) : null;
    }

    private List<Map<String, String>> getTemplatesByNumber(String billNumber) {
        QFilter[] qFilters = new QFilter[]{new QFilter("basedatafield.number", "=", (Object)billNumber), new QFilter("modeltype", "=", (Object)"PrintModel")};
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bos_formmeta", (String)"number,name", (QFilter[])qFilters);
        ArrayList<Map<String, String>> templateDatas = new ArrayList<Map<String, String>>();
        templates.forEach(template -> {
            HashMap<String, String> singleTemplate = new HashMap<String, String>();
            singleTemplate.put("templateNumber", template.getString(KEY_NUMBER));
            String name = template.getString("name");
            singleTemplate.put("tempalteName", name);
            templateDatas.add(singleTemplate);
        });
        return templateDatas;
    }

    private void buildDisplayFieldControlEntry(String formId, String orginalFormId) {
        this.getModel().beginInit();
        Map<String, BillTypeControlInfo> ctlInfos = this.getBillTypeControlInfos(formId, orginalFormId);
        int size = ctlInfos.size();
        if (this.getModel().getEntryRowCount(KEY_FIELD_CONTROL_ENTRY_DISPLAY) > 0) {
            this.getModel().deleteEntryData(KEY_FIELD_CONTROL_ENTRY_DISPLAY);
        }
        if (size > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_FIELD_CONTROL_ENTRY_DISPLAY, size);
        }
        int i = 0;
        for (Map.Entry<String, BillTypeControlInfo> ctlInfo : ctlInfos.entrySet()) {
            this.buildDisplayFieldControlRow(ctlInfo.getValue(), i++);
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_FIELD_CONTROL_ENTRY_DISPLAY);
    }

    private Map<String, BillTypeControlInfo> getBillTypeControlInfos(String formId, String orginalFormId) {
        if (this.billTypeControlInfoMap == null) {
            Map ctlInfos = null;
            this.billTypeControlInfoMap = ctlInfos = BillTypeDifferentialHelper.getFullControlInfos((String)formId, (String)orginalFormId);
        }
        return this.billTypeControlInfoMap;
    }

    private void buildDisplayFieldControlRow(BillTypeControlInfo ctlInfo, int i) {
        IDataModel model = this.getModel();
        model.setValue(KEY_FIELDKEY, (Object)ctlInfo.getFieldKey(), i);
        model.setValue(KEY_ENTITYFIELDKEY, (Object)ctlInfo.getEntityFieldKey(), i);
        model.setValue(KEY_FIELD_NAME, (Object)ctlInfo.getFieldName(), i);
        model.setValue(KEY_DEFAULTFUNCPARAM, (Object)ctlInfo.getFieldType(), i);
        model.setValue("sysmustinput_d", (Object)ctlInfo.isMustInput(), i);
        model.setValue(KEY_MUSTINPUT_D, (Object)ctlInfo.isMustInput(), i);
        LOCK2STATUS.forEach((statusKey, status) -> model.setValue(statusKey, (Object)ctlInfo.isLock(status), i));
        VISIBLE2STATUS.forEach((statusKey, status) -> model.setValue(statusKey, (Object)ctlInfo.isVisible(status), i));
    }

    private void lockLimitEditCell() {
        String formId = this.getCurrentFormId();
        String layoutFormId = this.getCurrentLayoutFormId();
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)layoutFormId)) {
            return;
        }
        Map<String, BillTypeControlInfo> ctlInfos = this.getBillTypeControlInfos(layoutFormId, formId);
        int i = 0;
        for (Map.Entry<String, BillTypeControlInfo> entry : ctlInfos.entrySet()) {
            BillTypeControlInfo ctlInfo = entry.getValue();
            int rowIndex = i++;
            if (ctlInfo.isMustInput()) {
                this.lockCell(KEY_MUSTINPUT_D, rowIndex);
            }
            LOCK2STATUS.forEach((statusKey, status) -> {
                if (ctlInfo.isLock(status)) {
                    this.lockCell((String)statusKey, rowIndex);
                }
            });
            VISIBLE2STATUS.forEach((statusKey, status) -> {
                if (!ctlInfo.isVisible(status)) {
                    this.lockCell((String)statusKey, rowIndex);
                }
            });
            if (ctlInfo.getDefValueType() == 0 || UNSUPPORTED_FIELDS.contains(ctlInfo.getFieldType())) {
                this.lockCell(KEY_DEFAULTVALUE, rowIndex);
            }
            if (ctlInfo.getMustInputType() != 0) continue;
            this.lockCell(KEY_MUSTINPUT_D, rowIndex);
        }
    }

    private void lockCell(String key, int row) {
        FieldEdit cellEdit = (FieldEdit)this.getView().getControl(key);
        cellEdit.setEntryKey(KEY_FIELD_CONTROL_ENTRY_DISPLAY);
        cellEdit.setEnable("", false, row);
    }

    private void decideParameterViewLock() {
        String parameterPageId = this.getPageCache().get(PARAMETER_PAGE_ID);
        if (StringUtils.isNotBlank((CharSequence)parameterPageId)) {
            IFormView parameterView = this.getView().getViewNoPlugin(parameterPageId);
            if (parameterView == null) {
                return;
            }
            BillShowParameter billshowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            BillEntityType dt = (BillEntityType)this.getModel().getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            String billStatus = (String)this.getModel().getValue(billStatusKey);
            if (BillOperationStatus.SUBMIT == billshowParameter.getBillStatus() || BillOperationStatus.AUDIT == billshowParameter.getBillStatus() || "B".equalsIgnoreCase(billStatus) || "C".equalsIgnoreCase(billStatus)) {
                parameterView.setStatus(OperationStatus.VIEW);
            } else {
                parameterView.setStatus(OperationStatus.EDIT);
            }
            this.getView().sendFormAction(parameterView);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataEntityProperty prop = e.getProperty();
        if ("importtpl".equalsIgnoreCase(prop.getName()) || "exporttpl".equalsIgnoreCase(prop.getName())) {
            ListShowParameter lsp = (ListShowParameter)e.getFormShowParameter();
            lsp.getListFilterParameter().getQFilters().add(new QFilter("bizobject", "=", this.getModel().getValue("billformid_id")));
        }
    }

    public void customEvent(CustomEventArgs e) {
        IFormView parameterView;
        String parameterPageId;
        super.customEvent(e);
        if (StringUtils.equals((CharSequence)e.getEventName(), (CharSequence)APPCACHE_PARAMSETTING) && StringUtils.isNotBlank((CharSequence)(parameterPageId = e.getEventArgs())) && (parameterView = this.getView().getView(parameterPageId)) != null) {
            IParameterModel parameterModel = (IParameterModel)parameterView.getModel();
            parameterModel.setBindFormId(((DynamicObject)this.getModel().getValue(KEY_BILLFORMID)).getPkValue().toString());
            parameterModel.setBindBillTypeId((Long)this.getModel().getDataEntity().getPkValue());
            parameterView.invokeOperation("parametersave");
        }
    }

    private void fireCustomEventParametersave(String parameterPageId) {
        IFormView childView = this.getView().getViewNoPlugin(parameterPageId);
        if (childView == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("methodName", "customEvent");
        ArrayList<String> args = new ArrayList<String>(3);
        args.add("");
        args.add(APPCACHE_PARAMSETTING);
        args.add(parameterPageId);
        params.put("args", args);
        ArrayList<HashMap<String, Object>> paramsList = new ArrayList<HashMap<String, Object>>(1);
        paramsList.add(params);
        String paramsStr = SerializationUtils.toJsonString(paramsList);
        String appId = childView.getFormShowParameter().getServiceAppId();
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
        service.invoke("kd.bos.service.ServiceFactory", "FormService", "batchInvokeAction", new Object[]{this.getView().getPageId(), paramsStr});
    }

    private Object getBindBillTypeId() {
        Object copyPkValue;
        IPageCache pageCache = this.getView().getPageCache();
        Object object = copyPkValue = pageCache.get(PAGECACHE_COPYPKVALUE) == null ? null : Long.valueOf(pageCache.get(PAGECACHE_COPYPKVALUE));
        if (copyPkValue == null) {
            copyPkValue = this.getModel().getDataEntity().getPkValue();
        }
        return copyPkValue;
    }

    static {
        VISIBLE2STATUS.put("vinit_d", "init");
        VISIBLE2STATUS.put("vnew_d", "new");
        VISIBLE2STATUS.put("vedit_d", "edit");
        VISIBLE2STATUS.put("vview_d", "view");
        VISIBLE2STATUS.put("vsubmit_d", KEY_SUBMIT);
        VISIBLE2STATUS.put("vaudit_d", KEY_ADUIT);
        LOCK2STATUS.put("enabled_d", "new");
        LOCK2STATUS.put("editenabled_d", "edit");
        LOCK2STATUS.put("submitenabled_d", KEY_SUBMIT);
        LOCK2STATUS.put("auditenabled_d", KEY_ADUIT);
        DISPLAY2STORE.put(KEY_FIELDKEY, "fieldkey");
        DISPLAY2STORE.put(KEY_ENTITYFIELDKEY, "entityfieldkey");
        DISPLAY2STORE.put("vinit_d", "vinit");
        DISPLAY2STORE.put("vnew_d", "vnew");
        DISPLAY2STORE.put("vedit_d", "vedit");
        DISPLAY2STORE.put("vview_d", "vview");
        DISPLAY2STORE.put("vsubmit_d", "vsubmit");
        DISPLAY2STORE.put("vaudit_d", "vaudit");
        DISPLAY2STORE.put("enabled_d", "enabled");
        DISPLAY2STORE.put("editenabled_d", "editenabled");
        DISPLAY2STORE.put("submitenabled_d", "submitenabled");
        DISPLAY2STORE.put("auditenabled_d", "auditenabled");
        DISPLAY2STORE.put(KEY_MUSTINPUT_D, "mustinput");
        DISPLAY2STORE.put(KEY_DEFAULTVALUE, "defaultvalue");
    }
}

